﻿layui.use(['jquery','flow'], function () {
    var $ = layui.jquery;
    article.Init($);//初始化共用js

    var flow = layui.flow;
    article.Flow($,flow);//加载更多文章
    article.Views($);//文章浏览量
    article.Relation($);//文章上一篇下一篇
   
});
var article = {};
article.Init = function ($) {
    //var $ = layui.jquery,
    var slider = 0;
    blogtype();
    //类别导航开关点击事件
    $('.category-toggle').click(function (e) {
        e.stopPropagation();    //阻止事件冒泡
        categroyIn();
    });
    //类别导航点击事件，用来关闭类别导航
    $('.article-category').click(function () {
        categoryOut();
    });
    //遮罩点击事件
    $('.blog-mask').click(function () {
        categoryOut();
    });
    $("body").delegate(".fa-times", "click", function () {
        $(".search-result").hide().empty(); $("#searchtxt").val("");
        $(".search-icon i").removeClass("fa-times").addClass("fa-search");
    });
    //显示类别导航
    function categroyIn() {
        $('.category-toggle').addClass('layui-hide');
        $('.article-category').unbind('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend');
        $('.blog-mask').unbind('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend');
        $('.blog-mask').removeClass('maskOut').addClass('maskIn');
        $('.blog-mask').removeClass('layui-hide').addClass('layui-show');
        $('.article-category').removeClass('categoryOut').addClass('categoryIn');
        $('.article-category').addClass('layui-show');
    }
    //隐藏类别导航
    function categoryOut() {
        $('.blog-mask').on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
            $('.blog-mask').addClass('layui-hide');
        });
        $('.article-category').on('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
            $('.article-category').removeClass('layui-show');
            $('.category-toggle').removeClass('layui-hide');
        });
        $('.blog-mask').removeClass('maskIn').addClass('maskOut').removeClass('layui-show');
        $('.article-category').removeClass('categoryIn').addClass('categoryOut');
    }
    function blogtype() {
        $('#category li').hover(function () {
            $(this).addClass('current');
            var num = $(this).attr('data-index');
            $('.slider').css({ 'top': ((parseInt(num) - 1) * 40) + 'px' });
        }, function () {
            $(this).removeClass('current');
            $('.slider').css({ 'top': slider });
        });
        $(window).scroll(function (event) {
            var winPos = $(window).scrollTop();
            if (winPos > 750)
                $('#categoryandsearch').addClass('fixed');
            else
                $('#categoryandsearch').removeClass('fixed');
        });
    };
};

//加载更多文章
article.Flow = function ($,flow) {
    $("#LAY_bloglist").html("");
    var type = $("#type").val();
    var keyword = $("#keyword").val();
    if (type=="") type = "index";
    flow.load({
        elem: '#LAY_bloglist',
        isAuto: false,
        isLazyimg: true,
        done: function (page, next) {
            var list = [];
            $.get('/flow', {type: type, page: page, keyword: keyword}, function (res) {
                res = res.data;
                layui.each(res.Data, function (index, item) {
                    var html = '';
                    if (item.is_top==1){
                        item.flag='<div class="fc-flag">置顶</div>';
                    } else {
                        item.flag='';
                    }
                    item.url='/article/'+item.id;
                    item.year = item.createtime
                    var date = new Date(item.createtime*1000);
                    item.year = date.getFullYear();
                    item.month = date.getMonth() + 1;
                    item.day = date.getDate();
                    var tags = ""
                    item.tag.split(",").forEach(function (item) {
                        if (item!=""){
                            tags += '<a class="tag" href="/tag/' + item +'" title="' + item + '">' + item + '</a>';
                        }
                    });
                    item.tags = tags

                    html = jointSingleHtml(html, item);
                    list.push(html);
                });
                next(list.join(''), page < res.Paginator.totalpages)
            }, 'json')
        }
    });

    //搜索
    $('.fa-search').click(function () {
        var keyword = $.trim($('input[name="keyword"]').val());
        if (!keyword) {
            return layer.msg('关键词不能为空');
        }
        location.href = '/search/' + keyword;
    })

    function jointSingleHtml(html, item) {
        html = `
            <section class="article-item zoomIn article">
                        ${item.flag}
                        <h5 class="title">
                            <span class="fc-blue">【${item.catename}】</span>
                            <a href="${item.url}">${item.title}</a>
                        </h5>
                        <div class="time">
                            <span class="day">${item.day}</span>
                            <span class="month fs-18">${item.month}<span class="fs-14">月</span></span>
                            <span class="year fs-18 ml10">${item.year}</span>
                        </div>
                        <div class="content">
                            <a href="${item.url}" class="cover img-light">
                                <img lay-src="${item.thumb}">
                            </a>
                            ${item.description}
                        </div>
                        <div class="read-more" style="clear: both">
                            <a href="${item.url}" class="fc-black f-fwb">继续阅读</a>
                        </div>
                        <aside class="f-oh footer">
                            <div class="f-fl tags">
                                <span class="fa fa-tags fs-16"></span>
                                ${item.tags}
                            </div>
                            <div class="f-fr">
									<span class="read">
										<i class="fa fa-thermometer-half fs-16"></i>
										<i class="num">${item.views}</i>
									</span>
                            </div>
                        </aside>
                    </section>
        `;
        return html;
    }


};

//文章浏览量
article.Views = function ($) {
    var id = $(".readcount").data("id");
    if (id>0){
        $.get('/article_views/'+id, function (res) {
            if (res.status==200){
                var views = res.data;
                $(".readcount").html(views);
            }
        }, 'json')
    }
};

//文章上一篇下一篇
article.Relation = function ($) {
    var id = $(".readcount").data("id");
    var categoryid = $("#categoryid").val();
    if (id>0){
        $.get('/relation/?id='+id+'&categoryid='+categoryid, function (res) {
            if (res.status==200){
                var relation = "";
                if (res.data.Prev.id>0) {
                    relation +='<li class="f-toe">上一篇：<a href="/article/'+res.data.Prev.id+'">'+res.data.Prev.title+'</a></li>';
                } else {
                    relation +='<li class="f-toe">上一篇：<a href="javascript::">没有了...</a></li>';
                }
                if (res.data.Next.id>0) {
                    relation +='<li class="f-toe">下一篇：<a href="/article/'+res.data.Next.id+'">'+res.data.Next.title+'</a></li>';
                } else {
                    relation +='<li class="f-toe">下一篇：<a href="javascript::">没有了...</a></li>';
                }
                $(".b-relation").html(relation);
            }
        }, 'json')
    }
};