package com.jeeww.activiti.service;

import java.io.InputStream;
import java.util.Map;

import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

import com.jeeww.core.vo.Pager;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
public interface ActivitiCoreService {
    /**
     * 功能描述：启动一个流程.
     * @param processDefinationId 流程定义ID
     * @param variables 启动流程的相关参数.
     * @return String 流程实例ID.
     * @throws Exception e.
     */
    String startProcess(String processDefinationId, Map<String, Object> variables) throws Exception;

    /**
     * 功能描述：通过流程定义ID获得流程图.
     * @param processDefinationId 流程定义ID
     * @return InputStream 流程图输入流.
     * @throws Exception e.
     */
    InputStream getProcessDiagramByPdid(String processDefinationId) throws Exception;

    /**
     * 功能描述：通过流程实例ID获得流程图.
     * @param processInstanceId 流程实例ID
     * @return InputStream 流程图输入流.
     * @throws Exception e.
     */
    InputStream getActivieDiagramByPiid(String processInstanceId) throws Exception;

    /**
     * 功能描述：获得流程图正在进行的节点信息.
     * @param processInstanceId 流程实例ID
     * @return String 节点相关信息.
     * @throws Exception e.
     */
    String getActiviePoint(String processInstanceId) throws Exception;

    /**
     * 功能描述：获得流程实例信息.
     * @param pager pager
     * @return String 节点相关信息.
     * @throws Exception e.
     */
    Pager<ProcessInstance> getProcessInstances(final Pager<ProcessInstance> pager) throws Exception;

    /**
     * 功能描述：获取定义的流程信息.
     * @param pager pager
     * @return String 节点相关信息.
     * @throws Exception e.
     */
    Pager<ProcessDefinition> getProcessDefinations(final Pager<ProcessDefinition> pager) throws Exception;

    /**
     * 功能描述：获得指定人的任务信息.
     * @param assignee 指定任务人的id
     * @return String 任务信息.
     * @throws Exception e.
     */
    String getActiveTasksByUid(String assignee) throws Exception;

    /**
     * 功能描述：获得指定组(角色)的任务信息.
     * @param group 指定任务组的id
     * @return String 任务信息.
     * @throws Exception e.
     */
    String getActiveTasksByGroupId(String group) throws Exception;

    /**
     * 功能描述：完成一个任务.
     * @param variables 任务参数
     * @param taskId 任务id
     * @throws Exception e.
     */
    void completeTask(String taskId, Map<String, Object> variables) throws Exception;

    /**
     * 功能描述：部署流程.
     * @throws Exception e.
     */
    void deployActiviti() throws Exception;

    /**
     * 功能描述：根据流程定义ID获得节点的坐标信息等.
     * @param pdid 流程定义ID
     * @throws Exception e.
     * @return String 节点信息.
     */
    String getTaskPointInfoByPdid(String pdid) throws Exception;
}
