package com.jeeww.core.ext;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

/**
 * 功能描述：统一异常处理类.
 * @author 蒋文武
 */
public class CustomerExceptionHandle implements HandlerExceptionResolver {
    /**
     * logger.
     */
    private static Logger logger = Logger.getLogger(CustomerExceptionHandle.class);

    /**
     * 异常处理.
     * @param request request.
     * @param response response.
     * @param handler handler.
     * @param ex Exception.
     * @return ModelAndView 返回页面对象.
     */
    public ModelAndView resolveException(final HttpServletRequest request, final HttpServletResponse response,
            final Object handler, final Exception ex) {
        logger.error("Catch Exception: ", ex);
        Map<String, Object> map = new HashMap<String, Object>();
        String msg = "";
        if (ex.getMessage() != null) {
            msg = ex.getMessage();
        }
        if (ex.getCause() != null) {
            msg = msg + ex.getCause();
        }
        map.put("errorMsg", msg);
        return new ModelAndView("error", map);
    }
}
