package com.jeeww.core.utils;

import com.alibaba.fastjson.JSONObject;
import com.jeeww.core.CommonConstants;

/**
 * 其他工具类.
 * @author 蒋文武
 */
public class MessageUtils {

    /**
     * 设置成功返回消息.
     * @param msgKey 消息ID
     * @return String 唯一标志.
     */
    public static final JSONObject addSuccessMsg(final String msgKey) {
        JSONObject jsonMsg = new JSONObject();
        jsonMsg.put(CommonConstants.MSG_KEY, msgKey);
        jsonMsg.put(CommonConstants.MSG_TYPE, CommonConstants.MSG_SUCCESS);
        return jsonMsg;
    }

    /**
     * 设置成功返回消息.
     * @param msgKey 消息ID
     * @param msgParams 消息参数
     * @return String 唯一标志.
     */
    public static JSONObject addSuccessMsg(final String msgKey, final Object msgParams) {
        JSONObject jsonMsg = new JSONObject();
        jsonMsg.put(CommonConstants.MSG_KEY, msgKey);
        jsonMsg.put(CommonConstants.MSG_TYPE, CommonConstants.MSG_SUCCESS);
        jsonMsg.put(CommonConstants.MSG_PARAMS, msgParams);
        return jsonMsg;
    }

    /**
     * 设置错误返回消息.
     * @param msgKey 消息ID
     * @return String 唯一标志.
     */
    public static final JSONObject addErrorMsg(final String msgKey) {
        JSONObject jsonMsg = new JSONObject();
        jsonMsg.put(CommonConstants.MSG_KEY, msgKey);
        jsonMsg.put(CommonConstants.MSG_TYPE, CommonConstants.MSG_ERROR);
        return jsonMsg;
    }

    /**
     * 设置错误返回消息.
     * @param flag 消息标志,用户自定义标志位，用户业务逻辑判断.
     * @param msgKey 消息信息ID
     * @return String 唯一标志.
     */
    public static final JSONObject addMsg(final String flag, final String msgKey) {
        JSONObject jsonMsg = new JSONObject();
        jsonMsg.put(CommonConstants.MSG_KEY, msgKey);
        jsonMsg.put(CommonConstants.MSG_TYPE, CommonConstants.MSG_NORMAL);
        jsonMsg.put(CommonConstants.MSG_NORMAL_BS_FLAG, flag);
        return jsonMsg;
    }
}
