package com.jeeww.core.vo;

import java.util.List;

/**
 * 类描述：分页查询结果类.
 * @author 蒋文武
 * @param <T> T.
 */
public class Pager<T> implements java.io.Serializable {
    /**
     * .
     */
    private static final long serialVersionUID = 1L;
    /**
     * 每页大小.
     */
    private int pageSize;
    /**
     * 当前页.
     */
    private int page;
    /**
     * 其它查询条件.
     */
    private Object searchModel;
    /**
     * 总记录数.
     */
    private int resultCount;
    /**
     * 返回的记录.
     */
    private List<T> result;

    /**
     * @return the pageSize
     */
    public final int getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize the pageSize to set
     */
    public final void setPageSize(final int pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * @return the page
     */
    public final int getPage() {
        return page;
    }

    /**
     * @param page the page to set
     */
    public final void setPage(final int page) {
        this.page = page;
    }

    /**
     * @return the searchModel
     */
    public final Object getSearchModel() {
        return searchModel;
    }

    /**
     * @param searchModel the searchModel to set
     */
    public final void setSearchModel(final Object searchModel) {
        this.searchModel = searchModel;
    }


    /**
     * @return the result
     */
    public final List<T> getResult() {
        return result;
    }

    /**
     * @param result the result to set
     */
    public final void setResult(final List<T> result) {
        this.result = result;
    }

    /**
     * @return the resultCount
     */
    public int getResultCount() {
        return resultCount;
    }

    /**
     * @param resultCount the resultCount to set
     */
    public void setResultCount(final int resultCount) {
        this.resultCount = resultCount;
    }
}
