package com.jeeww.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

/**
 * 默认拦截器类,没有实现具体的业务，根据需要自己实现.
 * @author jiangww
 */
public class CustomerInterceptor implements HandlerInterceptor {
    /**
     * .
     */
    private Logger log = Logger.getLogger(CustomerInterceptor.class);

    /**
     * .
     */
    public CustomerInterceptor() {
    }

    /**
     * 利用正则映射到需要拦截的路径.
     */
    private String mappingURL;

    /**
     * @param mappingURL mappingURL.
     */
    public void setMappingURL(final String mappingURL) {
        this.mappingURL = mappingURL;
    }

    /**
     * 在业务处理器处理请求之前被调用 如果返回false 从当前的拦截器往回执行所有拦截器的afterCompletion(),再退出拦截器链 如果返回true 执行下一个拦截器,直到所有的拦截器都执行完毕.
     * 再执行被拦截的Controller 然后进入拦截器链, 从最后一个拦截器往回执行所有的postHandle() 接着再从最后一个拦截器往回执行所有的afterCompletion().
     * @param request request.
     * @param response response.
     * @param handler handler.
     * @throws Exception 异常.
     * @return boolean b.
     */
    @Override
    public boolean preHandle(final HttpServletRequest request, final HttpServletResponse response, final Object handler)
            throws Exception {
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=UTF-8");
        if (log.isDebugEnabled()) {
            log.debug("==============执行顺序: 1、preHandle================");
        }
        String url = request.getRequestURL().toString();
        if (mappingURL == null || url.matches(mappingURL)) {
            if (log.isDebugEnabled()) {
                log.debug("==============访问的url：" + url);
            }
        }
        return true;
    }

    /**
     * 在业务处理器处理请求执行完成后,生成视图之前执行的动作.
     * @param request request.
     * @param response response.
     * @param handler handler.
     * @param modelAndView modelAndView.
     * @throws Exception 异常.
     */
    @Override
    public void postHandle(final HttpServletRequest request, final HttpServletResponse response, final Object handler,
            final ModelAndView modelAndView) throws Exception {
        if (log.isDebugEnabled()) {
            request.setAttribute("contextPath", request.getContextPath());
            log.debug("==============执行顺序: 2、postHandle================");
        }
    }

    /**
     * 在DispatcherServlet完全处理完请求后被调用 当有拦截器抛出异常时,会从当前拦截器往回执行所有的拦截器的afterCompletion().
     * @param request request.
     * @param response response.
     * @param handler handler.
     * @param ex ex.
     * @throws Exception 异常.
     */
    @Override
    public void afterCompletion(final HttpServletRequest request, final HttpServletResponse response,
            final Object handler, final Exception ex) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("==============执行顺序: 3、afterCompletion================");
        }
    }
}
