package com.jeeww.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import com.jeeww.security.CustomerUserDetails;

/**
 * 默认拦截器类,拦截页面,没有实现具体的业务，根据需要自己实现.
 * @author jiangww
 */
public class ModelAndViewInterceptor extends HandlerInterceptorAdapter {
    /**
     * .
     */
    private Logger log = Logger.getLogger(ModelAndViewInterceptor.class);

    /**
     * 在业务处理器处理请求执行完成后,生成视图之前执行的动作.
     * @param request request.
     * @param response response.
     * @param handler handler.
     * @param modelAndView modelAndView.
     * @throws Exception 异常.
     */
    @Override
    public void postHandle(final HttpServletRequest request, final HttpServletResponse response, final Object handler,
            final ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            String viewName = modelAndView.getViewName();
            if (log.isDebugEnabled()) {
                log.debug("监控到正在访问页面:" + viewName);
            }
            Object user = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            if (!user.equals("anonymousUser")) {
                CustomerUserDetails userDetail = (CustomerUserDetails) user;
                modelAndView.addObject("userName", userDetail.getUserInfo().getUserName());
                if (userDetail.getUserInfo().getAgtbUserConfigrationInfo() != null) {
                    String theme = userDetail.getUserInfo().getAgtbUserConfigrationInfo().getThemeName();
                    modelAndView.addObject("theme", theme);
                } else {
                    modelAndView.addObject("theme", "blue");
                }
            } else {
                modelAndView.addObject("userName", "未登录");
//                modelAndView.addObject("theme", "gray");
                modelAndView.addObject("theme", "default");
//                modelAndView.addObject("theme", "blue-simple");
//                modelAndView.addObject("theme", "blue2");
//                modelAndView.addObject("theme", "blue");
//                modelAndView.addObject("theme", "green");
//                modelAndView.addObject("theme", "sunny");
//                modelAndView.addObject("theme", "lavender");
            }
        }
    }
}
