package com.jeeww.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;

import com.jeeww.core.ext.SpringContextHolder;
import com.jeeww.core.syspojo.AgtbMenuInfo;
import com.jeeww.core.syspojo.AgtbResourceInfo;

public class InitUserSecutityService {
    static Logger logger = Logger.getLogger(InitUserSecutityService.class);
    private static Map<String, Collection<ConfigAttribute>> resourceMap = new HashMap<String, Collection<ConfigAttribute>>();
    private static final String PROPERTY_SECURITY = "security";
    private static final String PROPERTY_PROJECTCONFIG = "projectConfig.xml";
    private static final String PROPERTY_CHECK_LEVEL = "checkLevel";
    private static final String PROPERTY_CHECK_LEVEL_VALUE = "2";

    public static SessionFactory getSessionFactory() {
        SessionFactory sessionFactory = SpringContextHolder.getBean("sessionFactory");
        return sessionFactory;
    }

    public static Map<String, Collection<ConfigAttribute>> getAllUserInfo() {
        String hql = "from AgtbResourceInfo t ";
        Session session = getSessionFactory().openSession();
        try {
            /**
             * 加载 菜单 校验
             */
            // List<?> ls = session.createQuery(hql).list();
            // List<Resource> resourcesList = new ArrayList<Resource>();
            // for (int i = 0; i < ls.size(); i++) {
            // YzzxCdxx yzzxCdxx = (YzzxCdxx) ls.get(i);
            // Resource resource1 = new Resource();
            // resource1.setName(yzzxCdxx.getCdxh());
            // resource1.setUrl(yzzxCdxx.getQqlj());
            // resourcesList.add(resource1);
            // }
            // for (Resource resource : resourcesList) {
            // Collection<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
            // ConfigAttribute configAttribute = new SecurityConfig(resource.getName());
            // configAttributes.add(configAttribute);
            // resourceMap.put(resource.getUrl(), configAttributes);
            // }

            List<?> ls = session.createQuery(hql).list();
            for (int i = 0; i < ls.size(); i++) {
                AgtbResourceInfo agtbResourceInfo = (AgtbResourceInfo) ls.get(i);
                Collection<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
                ConfigAttribute configAttribute = new SecurityConfig(agtbResourceInfo.getResourceId());
                configAttributes.add(configAttribute);
                resourceMap.put(agtbResourceInfo.getResourceUrl(), configAttributes);
            }
            /**
             * 加载 功能 校验
             */
            // if (SystemConfigUtils.isCheckGnxx()) {
            //
            // }
        } catch (Exception e) {
            logger.error(e.getCause());
        } finally {
            session.close();
        }
        return resourceMap;
    }
}
