package com.jeeww.web.admin.controller.authoritymanage;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.jeeww.constant.WebConstants;
import com.jeeww.core.utils.AgileUiDataUtils;
import com.jeeww.core.vo.Pager;
import com.jeeww.web.BaseController;
import com.jeeww.web.admin.searchmodel.rolemanage.RoleManageSearchModel;
import com.jeeww.web.admin.service.authoritymanage.AuthorityManagerService;
import com.alibaba.fastjson.JSONObject;

/**
 * 功能描述：测试类.
 */
@Controller
@RequestMapping("/admin")
public class AuthorityManagerController extends BaseController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(AuthorityManagerController.class);
    /**
     * 角色主键.
     */
    public static final String C_ROLE_ID = "roleId";
    /**
     * 资源主键.
     */
    public static final String C_RESOURCES = "resourceTreeNodes";

    /**
     * authorityManagerService.
     */
    @Autowired
    private AuthorityManagerService authorityManagerService;

    /**
     * 功能描述 :跳转至用户管理首页.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toAuthorityManagePage.do", method = RequestMethod.GET)
    public ModelAndView toAuthorityManagePage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.debug("跳转至权限管理首页.");
        return new ModelAndView(WebConstants.WEBAPP_ADMIN + "authoritymanage/authoritymanage_main", model);
    }

    /**
     * 功能描述 :获得角色信息列表.
     * @param req req.
     * @return String 返回树形结构json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/queryRoleForAuthorityGrid.do", method = RequestMethod.POST)
    @ResponseBody
    public String queryRoleForAuthorityGrid(final HttpServletRequest req) throws Exception {
        logger.debug("获得角色信息列表.");
        RoleManageSearchModel roleManageSearchModel = new RoleManageSearchModel();
        Pager<?> pager = new Pager<Object>();
        AgileUiDataUtils.initPager(pager, roleManageSearchModel, req);
        return authorityManagerService.queryRoleForAuthorityGrid(pager);
    }

    /**
     * 功能描述 :获得角色的资源信息.
     * @param req req.
     * @return String 返回资源信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getRoleResources.do", method = RequestMethod.POST)
    @ResponseBody
    public String getRoleResources(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得角色的资源信息.");
        }
        String roleId = req.getParameter(C_ROLE_ID);
        return authorityManagerService.getRoleResources(roleId);
    }

    /**
     * 功能描述 :保存菜单和资源的关联信息.
     * @param req req.
     * @return String 返回成功失败标志信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveRoleResource.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveRoleResource(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存菜单和资源的关联信息.");
        }
        String resourceTreeNodes = req.getParameter(C_RESOURCES);
        String roleId = req.getParameter(C_ROLE_ID);
        JSONObject returnObj = authorityManagerService.saveRoleResource(roleId, resourceTreeNodes);
        return getLocalMsg(req, returnObj);
    }
}
