package com.jeeww.web.admin.controller.menumanage;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.jeeww.constant.WebConstants;
import com.jeeww.core.utils.AgileUiDataUtils;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.core.vo.Pager;
import com.jeeww.web.BaseController;
import com.jeeww.web.admin.dto.menumanage.MenuManageDTO;
import com.jeeww.web.admin.searchmodel.menumanage.MenuManageSearchModel;
import com.jeeww.web.admin.service.menumanage.MenuManagerService;
import com.alibaba.fastjson.JSONObject;

/**
 * 功能描述：菜单功能管理类.
 */
@Controller
@RequestMapping("/admin")
public class MenuManagerController extends BaseController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(MenuManagerController.class);
    /**
     * 菜单主键.
     */
    public static final String C_MENU_ID = "menuId";
    /**
     * 资源主键.
     */
    public static final String C_RESOURCE_ID = "resourceId";
    /**
     * 菜单节点.
     */
    public static final String C_MENU_NODES = "menuTreeNodes";
    /**
     * 选择的资源.
     */
    public static final String C_RESOURCE_NODES = "resourceRows";
    /**
     * 菜单功能管理接口.
     */
    @Autowired
    private MenuManagerService menuManagerService;

    /**
     * 功能描述 :跳转到菜单管理主页面.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @return ModelAndView 返回页面index.html.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toMenuManagePage.do", method = RequestMethod.GET)
    public ModelAndView toMenuManagePage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("跳转到菜单管理主页面.");
        }
        return new ModelAndView(WebConstants.WEBAPP_ADMIN + "menumanage/menumanage_main", model);
    }

    /**
     * 功能描述 :获得菜单信息.
     * @param req req.
     * @return String 返回树形结构json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getMenu.do", method = RequestMethod.POST)
    @ResponseBody
    public String getMenu(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得菜单信息.");
        }
        return menuManagerService.getMenu();
    }

    /**
     * 功能描述 :跳转到菜单管理主页面.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @return ModelAndView 返回页面index.html.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toMenuDetailPage.do", method = RequestMethod.GET)
    public ModelAndView toMenuDetailPage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("跳转到菜单录入/查看页面.");
        }
        return new ModelAndView(WebConstants.WEBAPP_ADMIN + "menumanage/menumanage_window", model);
    }

    /**
     * 功能描述 :查询资源信息，显示资源信息及其管理菜单信息.
     * @param req req.
     * @return String 返回树形结构json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getMenuResourceInfo.do", method = RequestMethod.POST)
    @ResponseBody
    public String getMenuResourceInfo(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("查询资源信息，显示资源信息及其管理菜单信息.");
        }
        MenuManageSearchModel searchModel = new MenuManageSearchModel();
        Pager<?> pager = new Pager<Object>();
        AgileUiDataUtils.initPager(pager, searchModel, req);
        return menuManagerService.getMenuResourceInfo(pager);
    }

    /**
     * 功能描述 :获得菜单的资源信息.
     * @param req req.
     * @return String 返回资源信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getMenuResources.do", method = RequestMethod.POST)
    @ResponseBody
    public String getMenuResources(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得菜单的资源信息.");
        }
        String menuId = req.getParameter(C_MENU_ID);
        return menuManagerService.getMenuResources(menuId);
    }

    /**
     * 功能描述 :保存菜单和资源的关联信息.
     * @param req req.
     * @return String 返回成功失败标志信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveMenuResource.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveMenuResource(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存菜单和资源的关联信息.");
        }
        String menuTreeNodes = req.getParameter(C_MENU_NODES);
        String resourceTreeNodes = req.getParameter(C_RESOURCE_NODES);
        JSONObject returnObj = menuManagerService.saveMenuResource(menuTreeNodes, resourceTreeNodes);
        return getLocalMsg(req, returnObj);
    }

    /**
     * 功能描述 :保存菜单信息.
     * @param req req.
     * @return String 返回成功失败标志信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveMenu.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveMenu(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存菜单信息.");
        }
        MenuManageDTO menuManageDTO = new MenuManageDTO();
        BeanUtilsEx.copyProperties(menuManageDTO, req.getParameterMap());
        JSONObject returnObj = menuManagerService.saveMenu(menuManageDTO);
        return getLocalMsg(req, returnObj);
    }

    /**
     * 功能描述 :获得菜单详细信息.
     * @param req req.
     * @return String 返回菜单详细信息json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getMenuDetail.do", method = RequestMethod.GET)
    @ResponseBody
    public String getMenuDetail(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得菜单详细信息.");
        }
        String menuId = req.getParameter("menuId");
        MenuManageSearchModel searchModel = new MenuManageSearchModel();
        if (!StringUtils.isEmpty(menuId)) {
            searchModel.setMenuId(menuId);
        }
        return menuManagerService.getMenuDetail(searchModel);
    }

    /**
     * 功能描述 :删除菜单信息.
     * @param req req.
     * @return String 返回操作标志.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/deleteMenu.do", method = RequestMethod.POST)
    @ResponseBody
    public String deleteMenu(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("删除菜单信息.");
        }
        MenuManageDTO menuManageDTO = new MenuManageDTO();
        BeanUtilsEx.copyProperties(menuManageDTO, req.getParameterMap());
        JSONObject returnObj = menuManagerService.deleteMenu(menuManageDTO);
        return getLocalMsg(req, returnObj);
    }
}
