package com.jeeww.web.admin.controller.usermanage;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.jeeww.constant.WebConstants;
import com.jeeww.core.utils.AgileUiDataUtils;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.core.vo.Pager;
import com.jeeww.web.BaseController;
import com.jeeww.web.admin.dto.usermanage.UserManageDTO;
import com.jeeww.web.admin.searchmodel.usermanage.UserManageSearchModel;
import com.jeeww.web.admin.service.usermanage.UserManagerService;
import com.alibaba.fastjson.JSONObject;

/**
 * 功能描述：测试类.
 */
@Controller
@RequestMapping("/admin")
public class UserManagerController extends BaseController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(UserManagerController.class);
    /**
     * 人员主键.
     */
    public static final String C_USER_ID = "userId";
    /**
     * 传入的角色变量名称.
     */
    public static final String C_ROLES = "roles";

    /**
     * userManagerService.
     */
    @Autowired
    private UserManagerService userManagerService;

    /**
     * 功能描述 :页面跳转至用户管理首页.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toUserManagePage.do", method = RequestMethod.GET)
    public ModelAndView toUserManagePage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("跳转至用户管理首页.");
        return new ModelAndView(WebConstants.WEBAPP_ADMIN + "usermanage/usermanage_main", model);
    }

    /**
     * 功能描述 :查询机构信息.
     * @param req req.
     * @return ModelAndView 返回页面index.html.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/queryUserForGrid.do", method = RequestMethod.POST)
    @ResponseBody
    public String queryUserForGrid(final HttpServletRequest req) throws Exception {
        logger.debug("查询人员信息.");
        UserManageSearchModel userManageSearchModel = new UserManageSearchModel();
        Pager<?> pager = new Pager<Object>();
        AgileUiDataUtils.initPager(pager, userManageSearchModel, req);
        return userManagerService.queryUserForGrid(pager);
    }

    /**
     * 功能描述 :保存用户信息.
     * @param req req.
     * @return String 返回成功失败标志信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveUser.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveUser(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存用户信息.");
        }
        UserManageDTO serManageDTO = new UserManageDTO();
        BeanUtilsEx.copyProperties(serManageDTO, req.getParameterMap());
        JSONObject returnObj = userManagerService.saveUser(serManageDTO);
        return getLocalMsg(req, returnObj);
    }

    /**
     * 功能描述 :删除用户信息.
     * @param req req.
     * @return String 返回操作标志.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/deleteUser.do", method = RequestMethod.POST)
    @ResponseBody
    public String deleteUser(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("删除用户信息.");
        }
        UserManageDTO serManageDTO = new UserManageDTO();
        BeanUtilsEx.copyProperties(serManageDTO, req.getParameterMap());
        JSONObject returnObj = userManagerService.deleteUser(serManageDTO);
        return getLocalMsg(req, returnObj);
    }

    /**
     * 功能描述 :获得人员的角色信息.
     * @param req req.
     * @return String 返回角色信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getUserRoles.do", method = RequestMethod.POST)
    @ResponseBody
    public String getUserRoles(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得人员的角色信息.");
        }
        String userId = req.getParameter(C_USER_ID);
        String s = userManagerService.getUserRoles(userId);
        return s;
    }

    /**
     * 功能描述 :获得人员详细信息.
     * @param req req.
     * @return String 返回人员详细信息json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getUserDetail.do", method = RequestMethod.GET)
    @ResponseBody
    public String getUserDetail(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得人员详细信息.");
        }
        String userId = req.getParameter(C_USER_ID);
        UserManageSearchModel searchModel = new UserManageSearchModel();
        if (!StringUtils.isEmpty(userId)) {
            searchModel.setUserId(userId);
        }
        return userManagerService.getUserDetail(searchModel);
    }

    /**
     * 功能描述 :保存菜单和资源的关联信息.
     * @param req req.
     * @return String 返回成功失败标志信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveUserRoles.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveUserRoles(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存菜单和资源的关联信息.");
        }
        String userId = req.getParameter(C_USER_ID);
        String roles = req.getParameter(C_ROLES);
        JSONObject returnObj = userManagerService.saveUserRoles(userId, roles);
        return getLocalMsg(req, returnObj);
    }

    /**
     * 功能描述 :更改用户自定义主题配置.
     * @param req req.
     * @return String 返回操作标志.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/updateTheme.do", method = RequestMethod.POST)
    @ResponseBody
    public String updateTheme(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("更改用户自定义主题配置.");
        }
        String themeId = req.getParameter("themeId");
        JSONObject returnObj = userManagerService.updateTheme(themeId);
        return getLocalMsg(req, returnObj);
    }

    /**
     * 功能描述 :校验用户输入的密码是否正确.
     * @param req req.
     * @return String 返回操作标志.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/checkPassword.do", method = RequestMethod.POST)
    @ResponseBody
    public String checkPassword(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("校验用户输入的密码是否正确.");
        }
        String oldPassword = req.getParameter("loginPassword");
        return userManagerService.checkPassword(oldPassword);
    }

    /**
     * 功能描述 :修改用户密码.
     * @param req req.
     * @return String 返回操作标志.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/updatePassword.do", method = RequestMethod.POST)
    @ResponseBody
    public String updatePassword(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("修改用户密码.");
        }
        UserManageDTO serManageDTO = new UserManageDTO();
        BeanUtilsEx.copyProperties(serManageDTO, req.getParameterMap());
        JSONObject returnObj = userManagerService.updatePassword(serManageDTO);
        return getLocalMsg(req, returnObj);
    }
}
