package com.jeeww.web.admin.service.authoritymanage;

import com.jeeww.core.vo.Pager;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
public interface AuthorityManagerService {

    /**
     * @param pager pager.
     * @return String.
     * @throws Exception e.
     */
    String queryRoleForAuthorityGrid(Pager<?> pager) throws Exception;

    /**
     * 功能描述 :获得角色的资源信息.
     * @param roleId 角色主键.
     * @return String 返回资源信息.
     * @throws Exception e.
     */
    String getRoleResources(String roleId) throws Exception;

    /**
     * 功能描述 :获得角色的资源信息.
     * @param roleId 角色主键.
     * @param resourceTreeNodes 资源主键.
     * @return JSONObject 返回操作信息.
     * @throws Exception e.
     */
    JSONObject saveRoleResource(String roleId, String resourceTreeNodes) throws Exception;
}
