package com.jeeww.web.admin.service.menumanage;

import com.jeeww.core.vo.Pager;
import com.jeeww.web.admin.dto.menumanage.MenuManageDTO;
import com.jeeww.web.admin.searchmodel.menumanage.MenuManageSearchModel;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
public interface MenuManagerService {

    /**
     * 功能描述：保存新菜单信息.
     * @return String.
     * @throws Exception e.
     */
    String getMenu() throws Exception;

    /**
     * 功能描述 :获得菜单的资源信息.
     * @param menuId 菜单主键.
     * @return String 返回资源信息.
     * @throws Exception e.
     */
    String getMenuResources(String menuId) throws Exception;

    /**
     * 功能描述 :保存菜单和资源的关联信息.
     * @param menuTreeNodes 选择的菜单对象.
     * @param resourceTreeNodes 选择的资源对象.
     * @return String 返回成功失败标志信息.
     * @throws Exception e.
     */
    JSONObject saveMenuResource(String menuTreeNodes, String resourceTreeNodes) throws Exception;

    /**
     * 功能描述 :查询资源信息，显示资源信息及其管理菜单信息..
     * @param pager 查询条件.
     * @return String 返回所有资源类型为主页的资源信息，并且含有菜单关联信息.
     * @throws Exception e.
     */
    String getMenuResourceInfo(Pager<?> pager) throws Exception;

    /**
     * 功能描述 :获得菜单详细信息.
     * @param searchModel 查询条件.
     * @return String 返回菜单详细信息.
     * @throws Exception e.
     */
    String getMenuDetail(MenuManageSearchModel searchModel) throws Exception;

    /**
     * 功能描述 :保存菜单信息.
     * @param menuManageDTO 菜单信息DTO.
     * @return String 返回菜单主键.
     * @throws Exception e.
     */
    JSONObject saveMenu(MenuManageDTO menuManageDTO) throws Exception;

    /**
     * 功能描述 :删除菜单信息.
     * @param menuManageDTO 菜单信息DTO.
     * @return JSONObject 返回操作标记.
     * @throws Exception e.
     */
    JSONObject deleteMenu(MenuManageDTO menuManageDTO) throws Exception;
}
