package com.jeeww.web.admin.service.orgmanage.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.jeeww.core.service.impl.BaseServiceImpl;
import com.jeeww.core.syspojo.AgtbOrganizationInfo;
import com.jeeww.core.syspojo.AgtbOrganizationInfoDAO;
import com.jeeww.core.utils.AgileUtils;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.core.vo.TreeConfig;
import com.jeeww.core.vo.TreeGridConfig;
import com.jeeww.web.admin.dto.orgmanage.OrgManageDTO;
import com.jeeww.web.admin.searchmodel.orgmanage.OrgManageSearchModel;
import com.jeeww.web.admin.service.orgmanage.OrgManagerService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
@Service("OrgManagerServiceImpl")
public class OrgManagerServiceImpl extends BaseServiceImpl implements OrgManagerService {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(OrgManagerServiceImpl.class);
    /**
     * 对AgtbOrganizationInfo对象进行增删改操作的DAO.
     */
    @Autowired
    private AgtbOrganizationInfoDAO agtbOrganizationInfoDAO;

    @Override
    public String queryOrgForTreeGrid(final OrgManageSearchModel orgManageSearchModel) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("orgName:" + orgManageSearchModel.getOrgName() + "--parentOrgId:"
                    + orgManageSearchModel.getParentOrgId());
        }
        TreeGridConfig treeGridConfig = new TreeGridConfig();
        treeGridConfig.setNamedQueryId("queryOrgForTreeGridByHql");
        treeGridConfig.setParentPropertyName("parentOrgId");
        //-------------------cache test------------------
//        List a = agtbOrganizationInfoDAO.getAll();
//        List b = agtbOrganizationInfoDAO.getAll();
        //-------------------cache test------------------
        return getTreeGridByHQLNamedQuery(orgManageSearchModel, treeGridConfig);

        // TreeGridConfig treeGridConfig = new TreeGridConfig();
        // treeGridConfig.setNamedQueryId("queryOrgForTreeGridBySql");
        // treeGridConfig.setParentPropertyName("parentOrgId");
        // return getTreeGridBySQLNamedQuery(orgManageSearchModel, treeGridConfig);
    }

    @Override
    public String getOrgTree(final OrgManageSearchModel searchModel) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("service-----获取机构信息树");
        }
        TreeConfig tree = new TreeConfig();
        tree.setTreeNamedQueryIdForTree("orgManageQueryForTree");
        tree.setTreeNamedQueryIdForCheck("orgManageCheckIsHaveChildren");
        tree.setTreeIdProperty("orgId");
        tree.setTreeNameProperty("orgName");
        JSONArray treeJson = getTreeBySQLNamedQuery(searchModel, tree);
        return JSON.toJSONString(treeJson);
    }

    @Override
    public String getOrgDetail(final OrgManageSearchModel searchModel) throws Exception {
        return getFormBySQLNamedQuery("getOrgDetail", searchModel);
    }

    @Override
    public JSONObject deleteOrg(final String orgId) throws Exception {
        agtbOrganizationInfoDAO.deleteByKey(orgId);
        return successMsg("deleteSuccess");
    }

    @Override
    public JSONObject saveOrg(final OrgManageDTO orgManageDTO) throws Exception {
        String key = orgManageDTO.getOrgId();
        String msgKey = null;
        if (StringUtils.isEmpty(key)) {
            AgtbOrganizationInfo agtbOrgInfo = new AgtbOrganizationInfo();
            BeanUtilsEx.copyProperties(agtbOrgInfo, orgManageDTO);
            agtbOrgInfo.setOrgId(AgileUtils.getKey());
            agtbOrganizationInfoDAO.save(agtbOrgInfo);
            msgKey = "saveSuccess";
        } else {
            AgtbOrganizationInfo agtbOrgInfo = agtbOrganizationInfoDAO.get(key);
            BeanUtilsEx.copyProperties(agtbOrgInfo, orgManageDTO, true);
            agtbOrganizationInfoDAO.update(agtbOrgInfo);
            msgKey = "updateSuccess";
        }
        JSONObject returnObj = successMsg(msgKey);
        returnObj.put("data", key);
        return returnObj;
    }
}
