package com.jeeww.web.admin.service.rolemanage;

import com.jeeww.core.vo.Pager;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
public interface RoleManagerService {

    /**
     * @param pager pager.
     * @return String.
     * @throws Exception e.
     */
    String queryRoleForGrid(Pager<?> pager) throws Exception;

    /**
     * 功能描述 :保存角色信息.
     * @param roleRows 要更新或新增的角色信息.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    JSONObject saveRole(String roleRows) throws Exception;

    /**
     * 功能描述 :删除角色信息.
     * @param roleRows 要删除的角色信息.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    JSONObject deleteRoles(String roleRows) throws Exception;
}
