package com.jeeww.web.admin.service.rolemanage.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.jeeww.core.service.impl.BaseServiceImpl;
import com.jeeww.core.syspojo.AgtbRoleInfo;
import com.jeeww.core.syspojo.AgtbRoleInfoDAO;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.core.utils.AgileUtils;
import com.jeeww.core.vo.Pager;
import com.jeeww.web.admin.dto.rolemanage.RoleManageDTO;
import com.jeeww.web.admin.service.rolemanage.RoleManagerService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
@Service("RoleManagerServiceImpl")
public class RoleManagerServiceImpl extends BaseServiceImpl implements RoleManagerService {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(RoleManagerServiceImpl.class);
    /**
     * 对agtbRoleInfoDAO对象进行增删改操作的DAO.
     */
    @Autowired
    private AgtbRoleInfoDAO agtbRoleInfoDAO;

    @Override
    public String queryRoleForGrid(final Pager<?> pager) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("service---获得用户dataGrid数据");
        }
        return getGridByHQLNamedQuery("queryRoleForGrid", pager);
    }

    @Override
    public JSONObject saveRole(final String roleRows) throws Exception {
        JSONArray roleRowsArray = JSONArray.parseArray(roleRows);
        String msgKey = "roleSaveOrUpdateSuccess";
        JSONObject msgParams = new JSONObject();
        int addNum = 0;
        int modifyNum = 0;
        for (int i = 0; i < roleRowsArray.size(); i++) {
            RoleManageDTO roleManageDTO = new RoleManageDTO();
            BeanUtilsEx.copyProperties(roleManageDTO, roleRowsArray.get(i));
            if (StringUtils.isEmpty(roleManageDTO.getRoleId())) {
                AgtbRoleInfo agtbRoleInfo = new AgtbRoleInfo();
                BeanUtilsEx.copyProperties(agtbRoleInfo, roleManageDTO);
                agtbRoleInfo.setRoleId(AgileUtils.getKey());
                agtbRoleInfoDAO.save(agtbRoleInfo);
                addNum++;
            } else {
                AgtbRoleInfo agtbRoleInfo = agtbRoleInfoDAO.get(roleManageDTO.getRoleId());
                BeanUtilsEx.copyProperties(agtbRoleInfo, roleManageDTO, true);
                agtbRoleInfoDAO.update(agtbRoleInfo);
                modifyNum++;
            }
        }
        msgParams.put("addNum", addNum);
        msgParams.put("modifyNum", modifyNum);
        return successMsg(msgKey, msgParams);
    }

    @Override
    public JSONObject deleteRoles(final String roleRows) throws Exception {
        JSONArray roleRowsArray = JSONArray.parseArray(roleRows);
        String msgKey = "deleteSuccess";
        for (int i = 0; i < roleRowsArray.size(); i++) {
            RoleManageDTO roleManageDTO = new RoleManageDTO();
            BeanUtilsEx.copyProperties(roleManageDTO, roleRowsArray.get(i));
            if (!StringUtils.isEmpty(roleManageDTO.getRoleId())) {
                agtbRoleInfoDAO.deleteByKey(roleManageDTO.getRoleId());
            }
        }
        return successMsg(msgKey);
    }
}
