package com.jeeww.web.admin.service.usermanage;

import com.jeeww.core.vo.Pager;
import com.jeeww.web.admin.dto.usermanage.UserManageDTO;
import com.jeeww.web.admin.searchmodel.usermanage.UserManageSearchModel;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
public interface UserManagerService {
    /**
     * 功能描述：新增保存人员信息.
     * @param userManageDTO 用户DTO.
     * @return JSONObject.
     * @throws Exception e.
     */
    JSONObject deleteUser(UserManageDTO userManageDTO) throws Exception;

    /**
     * 功能描述：新增保存人员信息.
     * @param userManageDTO 用户DTO.
     * @return JSONObject.
     * @throws Exception e.
     */
    JSONObject saveUser(UserManageDTO userManageDTO) throws Exception;

    /**
     * 功能描述 :保存用户和角色的关联信息.
     * @param userId 用户ID.
     * @param roles 选择的角色对象.
     * @return String 返回成功失败标志信息.
     * @throws Exception e.
     */
    JSONObject saveUserRoles(String userId, String roles) throws Exception;

    /**
     * 功能描述 :更改用户密码.
     * @param userId 用户ID.
     * @param oldPassword 旧密码.
     * @param newPassword 新密码.
     * @return String 返回成功失败标志信息.
     * @throws Exception e.
     */
    JSONObject updateUserPassword(String userId, String oldPassword, String newPassword) throws Exception;

    /**
     * @param pager pager.
     * @return String.
     * @throws Exception e.
     */
    String queryUserForGrid(Pager<?> pager) throws Exception;

    /**
     * 功能描述 :获得人员的角色信息.
     * @param userId 人员主键.
     * @return String 返回人员信息.
     * @throws Exception e.
     */
    String getUserRoles(String userId) throws Exception;

    /**
     * 功能描述 :获得人员详细信息.
     * @param searchModel 查询条件.
     * @return String 返回人员详细信息.
     * @throws Exception e.
     */
    String getUserDetail(UserManageSearchModel searchModel) throws Exception;

    /**
     * 功能描述 :更改用户自定义主题配置.
     * @param themeId 自定义主题.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    JSONObject updateTheme(String themeId) throws Exception;

    /**
     * 功能描述 :校验用户输入的密码是否正确.
     * @param oldPassword 旧密码.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    String checkPassword(String oldPassword) throws Exception;

    /**
     * 功能描述 :修改用户密码.
     * @param userManageDTO 密码信息DTO.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    JSONObject updatePassword(UserManageDTO userManageDTO) throws Exception;
}
