package com.jeeww.web.base.controller;

import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.jeeww.dto.MenuInfoDTO;
import com.jeeww.utils.UserDetailUtils;
import com.jeeww.web.base.service.GlobalService;
import com.alibaba.fastjson.JSON;

/**
 * 功能描述：controller父类.
 */
@Controller
public class GlobalController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(GlobalController.class);
    /**
     * baseService.
     */
    @Autowired
    private GlobalService globalService;

    /**
     * 功能描述 :跳转到首页.
     * @param locale locale.
     * @param model model.
     * @return ModelAndView 返回页面index.html.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/index.do", method = RequestMethod.GET)
    public ModelAndView index(final Locale locale, final ModelMap model) throws Exception {
        logger.debug("跳转到首页.");
        List<MenuInfoDTO> menuInfoList = UserDetailUtils.getUserDetail().getMenuList();
        model.addAttribute("menuInfoList", menuInfoList);
        return new ModelAndView("index", model);
    }

    /**
     * 功能描述 :获得子菜单.
     * @param req req.
     * @param res res.
     * @return ModelAndView 返回页面index.html.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getTreeFormAccording.do", method = RequestMethod.POST)
    @ResponseBody
    public String getTreeFormAccording(final HttpServletRequest req, final HttpServletResponse res) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得导航菜单下的树信息.");
        }
        String menuId = req.getParameter("menuId");
        List<MenuInfoDTO> menuInfoList = UserDetailUtils.getUserDetail().getMenuList();
        for (MenuInfoDTO menuInfoDTO : menuInfoList) {
            if (menuInfoDTO.getMenuId().equals(menuId)) {
                return JSON.toJSONString(menuInfoDTO.getAccordingTreeNodes());
            }
        }
        return null;
    }

    /**
     * 功能描述 :获得下拉列表的信息.
     * @param req req.
     * @return ModelAndView 返回页面index.html.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getCombo.do", method = RequestMethod.POST)
    @ResponseBody
    public String getCombo(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得下拉列表的信息.");
        }
        String codeId = req.getParameter("codeId");
        return globalService.getBaseCombo(codeId);
    }

    /**
     * 功能描述 :将代码项转换为名称显示.
     * @param req req.
     * @return ModelAndView 返回页面index.html.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getComboNameByCode.do", method = RequestMethod.POST)
    @ResponseBody
    public String getComboNameByCode(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("将代码项转换为名称显示.");
        }
        String codeId = req.getParameter("codeId");
        String codeValue = req.getParameter("codeValue");
        return globalService.getComboNameByCode(codeId, codeValue);
    }
}
