package com.jeeww.web.base.service.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import com.jeeww.core.service.impl.BaseServiceImpl;
import com.jeeww.core.syspojo.AgtbCodeInfo;
import com.jeeww.core.vo.ComboConfig;
import com.jeeww.utils.CommonComboUtils;
import com.jeeww.web.base.service.GlobalService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
@Service("CommonServiceImpl")
public class GlobalServiceImpl extends BaseServiceImpl implements GlobalService {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(GlobalServiceImpl.class);

    @Override
    public String getBaseCombo(final String codeId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("service---------获取下拉列表-----codeId:" + codeId);
        }
        String combo = CommonComboUtils.getCommonCombo(codeId);
        if (!StringUtils.isEmpty(combo)) {
            return combo;
        } else {
            AgtbCodeInfo agtbCodeInfo = new AgtbCodeInfo();
            agtbCodeInfo.setCodeId(codeId);
            ComboConfig comboConfig = new ComboConfig();
            comboConfig.setComboNamedQueryIdForCombo("getCodeInfo");
            comboConfig.setComboIdProperty("id");
            comboConfig.setComboNameProperty("name");
            String comboStr = getComboBySQLNamedQuery(agtbCodeInfo, comboConfig);
            CommonComboUtils.setCommonCombo(codeId, comboStr);
            return comboStr;
        }
    }

    @Override
    public String getComboNameByCode(final String codeId, final String codeValue) throws Exception {
        String comboString = getBaseCombo(codeId);
        JSONArray jsonArr = (JSONArray) JSONArray.parse(comboString);
        for (Object obj : jsonArr) {
            JSONObject jsonObj = (JSONObject) obj;
            if (codeValue.equals(jsonObj.get("value"))) {
                return (String) jsonObj.get("text");
            }
        }
        return null;
    }
}
