package com.jeeww.web.demo.controller.test;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import com.jeeww.constant.WebConstants;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.web.demo.dto.ActivitiTestDTO;
import com.jeeww.web.demo.service.test.TestService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 功能描述：测试类.
 */
@Controller
@RequestMapping("/demo")
public class DemoController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(DemoController.class);
    /**
     * testService.
     */
    @Autowired
    private TestService testService;
    /**
     * redisTemplate.
     */
    @Autowired
    private RedisTemplate<Object, Object> redisTemplate;

    /**
     * 功能描述 :x.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @param r.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/index.do", method = RequestMethod.GET)
    public ModelAndView demoIndex1(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("跳转到demo首页");
        List<String> values = new ArrayList<String>();
        values.add("1");
        values.add("2");
        // redisTemplate.opsForList().leftPushAll("listKey", values);
        // redisTemplate.opsForValue().set("test2", "yyyyyyyy");
        // logger.info(redisTemplate.opsForList().range("listKey", 0, -1));
        // logger.info(redisTemplate.opsForValue().get("test2"));
        // Map m = new HashMap();
        // m.put("x", "xxxddddddddd");
        // redisTemplate.opsForValue().set("MAP", m);
        // Map mmm = (Map) redisTemplate.opsForValue().get("MAP");
        // logger.info(mmm.get("x"));

        return new ModelAndView(WebConstants.WEBAPP_DEMO + "index", model);
    }

    /**
     * 功能描述 :x.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @param r.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/redirectNewPage.do", method = RequestMethod.GET)
    public ModelAndView redirectNewPage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        String redirectUrl = req.getParameter("redirectUrl").split("\\.")[0];
        logger.info("跳转到" + redirectUrl);
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "onepage/demo-one/" + redirectUrl, model);
    }

    /**
     * 功能描述 :x.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @param r.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/index2.do", method = RequestMethod.GET)
    public ModelAndView demoIndex2(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("跳转到demo首页");
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "onepage/index", model);
    }

    /**
     * 功能描述 :x.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @param r.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toForm.do", method = RequestMethod.GET)
    public ModelAndView toForm(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("跳转到demo首页");
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "onepage/pages/form", model);
    }

    @RequestMapping(
            value = "/toGrid.do", method = RequestMethod.GET)
    public ModelAndView toGrid(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("跳转到demo首页");
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "onepage/pages/grid", model);
    }

    /**
     * 功能描述 :x.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @param r.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toComplexForm.do", method = RequestMethod.GET)
    public ModelAndView toComplexForm(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("跳转到demo首页");
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "onepage/pages/complex_form", model);
    }

    @RequestMapping(
            value = "/toComplexSample1.do", method = RequestMethod.GET)
    public ModelAndView toComplexSample1(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("跳转到demo首页");
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "onepage/pages/complex_sample1", model);
    }

    @RequestMapping(
            value = "/toComplexSample2.do", method = RequestMethod.GET)
    public ModelAndView toComplexSample2(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("跳转到demo首页");
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "onepage/pages/complex_sample2", model);
    }

    /**
     * 下拉框测试数据.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/getCombo.do", method = RequestMethod.POST)
    @ResponseBody
    public String getCombo(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("getCombo.");
        JSONArray j = new JSONArray();
        for (int i = 1; i <= 5; i++) {
            JSONObject v1 = new JSONObject();
            v1.put("id", i);
            v1.put("text", "测试" + i);
            v1.put("desc", "测试" + i + "的描述");
            j.add(v1);
        }
        return j.toJSONString();
    }

    /**
     * 下拉框测试数据.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/getAutoComplete.do", method = RequestMethod.POST)
    @ResponseBody
    public String getAutoComplete(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("getAutoComplete.");
        JSONArray j = new JSONArray();
        String q = req.getParameter("q");
        if ("嘿嘿".equals(q)) {
            for (int i = 1; i <= 10; i++) {
                JSONObject v1 = new JSONObject();
                v1.put("id", i);
                v1.put("text", "嘿嘿" + i);
                v1.put("desc", "嘿嘿" + i + "的描述");
                j.add(v1);
            }
        } else if ("呵呵".equals(q)) {
            for (int i = 1; i <= 5; i++) {
                JSONObject v1 = new JSONObject();
                v1.put("id", i);
                v1.put("text", "呵呵" + i);
                v1.put("desc", "呵呵" + i + "的描述");
                j.add(v1);
            }
        } else if ("哈哈".equals(q)) {
            for (int i = 1; i <= 15; i++) {
                JSONObject v1 = new JSONObject();
                v1.put("id", i);
                v1.put("text", "哈哈" + i);
                v1.put("desc", "哈哈" + i + "的描述");
                j.add(v1);
            }
        } else if ("1".equals(q)) {
            JSONObject v1 = new JSONObject();
            v1.put("id", 1);
            v1.put("text", "关联后台获取的值");
            v1.put("desc", "描述信息描述信息,可选");
            // v1.put("selected", true);
            j.add(v1);
        } else if ("1,2,3".equals(q)) {
            for (int i = 1; i <= 3; i++) {
                JSONObject v1 = new JSONObject();
                v1.put("id", i);
                v1.put("text", "哈哈" + i);
                v1.put("desc", "哈哈" + i + "的描述");
                j.add(v1);
            }
        } else if ("1,2,3,4,5".equals(q)) {
            for (int i = 1; i <= 5; i++) {
                JSONObject v1 = new JSONObject();
                v1.put("id", i);
                v1.put("text", "哈哈" + i);
                v1.put("desc", "哈哈" + i + "的描述");
                j.add(v1);
            }
        } else {
            for (int i = 1; i <= 10; i++) {
                JSONObject v1 = new JSONObject();
                v1.put("id", i);
                v1.put("text", "默认" + i);
                v1.put("desc", "默认" + i + "的描述");
                j.add(v1);
            }
        }
        return j.toJSONString();
    }

    @RequestMapping(
            value = "/getGridTree.do", method = RequestMethod.POST)
    @ResponseBody
    public String getGridTree(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("getCombo.");
        JSONObject dataGrid = new JSONObject();
        dataGrid.put("total", 20);
        JSONArray rows = new JSONArray();
        for (int i = 1; i <= 7; i++) {
            JSONObject row = new JSONObject();
            row.put("id", i);
            row.put("name", "测试任务" + i);
            row.put("persons", "测试人" + i);
            row.put("begin", "2014-09-09");
            row.put("end", "2014-12-09");
            row.put("progress", 6 * i);
            row.put("iconCls", "测试" + i + "的描述");

            for (int j = 1; j <= 3; j++) {
                JSONObject rowChild = new JSONObject();
                rowChild.put("id", i + "-" + j);
                rowChild.put("name", "测试任务" + i + "-" + j);
                rowChild.put("persons", "测试人" + i + "-" + j);
                rowChild.put("begin", "2014-09-09");
                rowChild.put("end", "2014-12-09");
                rowChild.put("progress", 6 * i);
                rowChild.put("iconCls", "测试" + i + "-" + j + "的描述");
                rowChild.put("_parentId", i);
                rows.add(rowChild);
            }

            rows.add(row);
        }
        dataGrid.put("rows", rows);
        JSONArray footerArr = new JSONArray();
        JSONObject footerObject = new JSONObject();
        footerObject.put("name", "任务总计:100");
        footerObject.put("persons", "平均完成时间:8");
        footerArr.add(footerObject);
        dataGrid.put("footer", footerArr);
        return dataGrid.toJSONString();
    }

    /**
     * 下拉框测试数据.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/getDataGrid.do", method = RequestMethod.POST)
    @ResponseBody
    public String getDataGrid(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("getDataGrid.");
        JSONObject dataGrid = new JSONObject();
        dataGrid.put("total", 20);
        JSONArray rows = new JSONArray();
        for (int i = 1; i <= 20; i++) {
            JSONObject row = new JSONObject();
            row.put("productid", i);
            row.put("productname", "测试" + i);
            row.put("unitcost", 8 * i);
            row.put("status", "P");
            row.put("listprice", 6 * i);
            row.put("attr1", "测试" + i + "的描述");
            row.put("itemid", "9001" + i);
            rows.add(row);
        }
        dataGrid.put("rows", rows);
        return dataGrid.toJSONString();
    }

    @RequestMapping(
            value = "/getDataGridRemote.do", method = RequestMethod.POST)
    @ResponseBody
    public String getDataGridRemote(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("getDataGridRemote.");
        JSONObject dataGrid = new JSONObject();
        String q = req.getParameter("q");
        logger.debug(q);
        if ("呵呵".equals(q)) {
            dataGrid.put("total", 20);
            JSONArray rows = new JSONArray();
            for (int i = 1; i <= 20; i++) {
                JSONObject row = new JSONObject();
                row.put("productid", i);
                row.put("productname", "呵呵" + i);
                row.put("unitcost", 8 * i);
                row.put("status", "P");
                row.put("listprice", 6 * i);
                row.put("attr1", "呵呵" + i + "的描述");
                row.put("itemid", "9001" + i);
                rows.add(row);
            }
            dataGrid.put("rows", rows);
        } else if ("哈哈".equals(q)) {
            dataGrid.put("total", 20);
            JSONArray rows = new JSONArray();
            for (int i = 1; i <= 20; i++) {
                JSONObject row = new JSONObject();
                row.put("productid", i);
                row.put("productname", "哈哈" + i);
                row.put("unitcost", 8 * i);
                row.put("status", "P");
                row.put("listprice", 6 * i);
                row.put("attr1", "哈哈" + i + "的描述");
                row.put("itemid", "9001" + i);
                rows.add(row);
            }
            dataGrid.put("rows", rows);
        } else if ("嘿嘿".equals(q)) {
            dataGrid.put("total", 20);
            JSONArray rows = new JSONArray();
            for (int i = 1; i <= 20; i++) {
                JSONObject row = new JSONObject();
                row.put("productid", i);
                row.put("productname", "嘿嘿" + i);
                row.put("unitcost", 8 * i);
                row.put("status", "P");
                row.put("listprice", 6 * i);
                row.put("attr1", "嘿嘿" + i + "的描述");
                row.put("itemid", "9001" + i);
                rows.add(row);
            }
            dataGrid.put("rows", rows);
        } else if ("3".equals(q)) {
            dataGrid.put("total", 20);
            JSONArray rows = new JSONArray();
            for (int i = 3; i <= 3; i++) {
                JSONObject row = new JSONObject();
                row.put("productid", i);
                row.put("productname", "嘿嘿" + i);
                row.put("unitcost", 8 * i);
                row.put("status", "P");
                row.put("listprice", 6 * i);
                row.put("attr1", "嘿嘿" + i + "的描述");
                row.put("itemid", "9001" + i);
                rows.add(row);
            }
            dataGrid.put("rows", rows);
        } else if ("2,3".equals(q)) {
            dataGrid.put("total", 20);
            JSONArray rows = new JSONArray();
            for (int i = 2; i <= 3; i++) {
                JSONObject row = new JSONObject();
                row.put("productid", i);
                row.put("productname", "嘿嘿" + i);
                row.put("unitcost", 8 * i);
                row.put("status", "P");
                row.put("listprice", 6 * i);
                row.put("attr1", "嘿嘿" + i + "的描述");
                row.put("itemid", "9001" + i);
                rows.add(row);
            }
            dataGrid.put("rows", rows);
        } else {
            dataGrid.put("total", 20);
            JSONArray rows = new JSONArray();
            for (int i = 1; i <= 20; i++) {
                JSONObject row = new JSONObject();
                row.put("productid", i);
                row.put("productname", "默认" + i);
                row.put("unitcost", 8 * i);
                row.put("status", "P");
                row.put("listprice", 6 * i);
                row.put("attr1", "默认" + i + "的描述");
                row.put("itemid", "9001" + i);
                rows.add(row);
            }
            dataGrid.put("rows", rows);
        }
        return dataGrid.toJSONString();
    }

    /**
     * 树测试数据.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/getTree.do", method = RequestMethod.POST)
    @ResponseBody
    public String getTree(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("getTree.");
        JSONArray j = new JSONArray();

        for (int i = 1; i <= 3; i++) {
            JSONObject node1 = new JSONObject();
            node1.put("id", i);
            node1.put("text", "测试节点" + i);
            JSONArray children = new JSONArray();
            JSONObject node11 = new JSONObject();
            node11.put("id", i + "" + i);
            node11.put("text", "测试节点" + i + i);
            children.add(node11);
            JSONObject node12 = new JSONObject();
            int jx = i + 1;
            String nodex12 = 1 + "" + jx;
            node12.put("id", nodex12);
            node12.put("text", "测试节点" + nodex12);
            children.add(node12);
            node1.put("children", children);
            j.add(node1);
        }

        return j.toJSONString();
    }

    /**
     * 请假申请页面.
     * @param locale locale
     * @param model model
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/toVacationRequestPage.do", method = RequestMethod.GET)
    public ModelAndView toVacationRequestPage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("请假申请页面");
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "activiti/vacationRequest", model);
    }

    /**
     * 请假审批页面.
     * @param locale locale
     * @param model model
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/toVacationApprovePage.do", method = RequestMethod.GET)
    public ModelAndView toVacationApprovePage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.info("请假审批页面");
        String taskId = req.getParameter("taskId");
        String piid = req.getParameter("piid");
        model.addAttribute("piid", piid);
        model.addAttribute("taskId", taskId);
        return new ModelAndView(WebConstants.WEBAPP_DEMO + "activiti/vacationApprove", model);
    }

    /**
     * 请假流程启动.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/vacationApply.do", method = RequestMethod.POST)
    @ResponseBody
    public String vacationApply(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("启动流程.");
        ActivitiTestDTO activitiTestDTO = new ActivitiTestDTO();
        BeanUtilsEx.copyProperties(activitiTestDTO, req.getParameterMap());
        // 启动一个流程
        Map<String, Object> variables = new HashMap<String, Object>();
        variables.put("employeeName", activitiTestDTO.getEmployeeName());
        variables.put("numberOfDays", activitiTestDTO.getNumberOfDays());
        variables.put("vacationMotivation", activitiTestDTO.getVacationMotivation());
        variables.put("handleTaskUrl", "/demo/toVacationApprovePage.do");
        variables.put("requestUserMail", "jiangww@neusoft.com");
        String processInstanceId = testService.vacationApply(variables);
        logger.info(" processInstanceId:" + processInstanceId);
        return processInstanceId;
    }

    /**
     * 审批请假流程.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/vacationApprove.do", method = RequestMethod.POST)
    @ResponseBody
    public String vacationApprove(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("审批请假流程.");
        ActivitiTestDTO activitiTestDTO = new ActivitiTestDTO();
        BeanUtilsEx.copyProperties(activitiTestDTO, req.getParameterMap());
        String processInstanceId = testService.vacationApprove(activitiTestDTO);
        logger.info(" processInstanceId:" + processInstanceId);
        return processInstanceId;
    }

    /**
     * 请假内容调整.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/vacationAdjust.do", method = RequestMethod.POST)
    @ResponseBody
    public String vacationAdjust(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("请假内容调整.");
        ActivitiTestDTO activitiTestDTO = new ActivitiTestDTO();
        BeanUtilsEx.copyProperties(activitiTestDTO, req.getParameterMap());
        // 启动一个流程
        Map<String, Object> variables = new HashMap<String, Object>();
        variables.put("employeeName", activitiTestDTO.getEmployeeName());
        variables.put("numberOfDays", activitiTestDTO.getNumberOfDays());
        variables.put("vacationMotivation", activitiTestDTO.getVacationMotivation());
        variables.put("handleTaskUrl", "/demo/toVacationApprovePage.do");
        String processInstanceId = testService.vacationApply(variables);
        logger.info(" processInstanceId:" + processInstanceId);
        return processInstanceId;
    }

    /**
     * 载入表单值.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/loadFormData.do", method = RequestMethod.GET)
    @ResponseBody
    public String loadFormData(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("启动流程.");
        return testService.loadFormData();
    }

    /**
     * 下拉框测试数据.
     * @param locale locale
     * @param req req
     * @return r
     * @throws Exception e
     */
    @RequestMapping(
            value = "/submitForm.do", method = RequestMethod.POST)
    @ResponseBody
    public String submitForm(final Locale locale, final HttpServletRequest req) throws Exception {
        logger.debug("submitForm.");
        TestFormBean testFormBean = new TestFormBean();
        BeanUtilsEx.copyProperties(testFormBean, req.getParameterMap());
        // 转型为MultipartHttpRequest
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) req;
        // 获得上传的文件（根据前台的name名称得到上传的文件）
        MultiValueMap<String, MultipartFile> multiValueMap = multipartRequest.getMultiFileMap();
        List<MultipartFile> f = multiValueMap.get("name_file1");
        Enumeration<?> params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String para = (String) params.nextElement();
            logger.error(para + ":" + req.getParameter(para));
        }
        JSONArray j = new JSONArray();
        for (int i = 1; i <= 5; i++) {
            JSONObject v1 = new JSONObject();
            v1.put("id", i);
            v1.put("text", "测试" + i);
            v1.put("desc", "测试" + i + "的描述");
            j.add(v1);
        }
        return j.toJSONString();
    }
}
