﻿/**
 * inputbox - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights
 * reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function validateClass(target, definations) {
		$(target).addClass("inputbox-text");
		if (definations.cusCls) {
			$(target).addClass(definations.cusCls);
		}
	}
	;
	function destroyItem(target) {
		var inputbox = $.data(target, "inputbox");
		inputbox.validating = false;
		var tip = inputbox.tip;
		if (tip) {
			tip.remove();
		}
		$(target).unbind();
		$(target).remove();
	}
	;
	function inputBoxEvent(target) {
		var inputBoxText = $(target);
		var inputbox = $.data(target, "inputbox");
		inputBoxText.unbind(".inputbox").bind("focus.inputbox", function() {
			inputbox.validating = true;
			inputbox.value = undefined;
			(function() {
				if (inputbox.validating) {
					if (inputbox.value != inputBoxText.val()) {
						inputbox.value = inputBoxText.val();
						if (inputbox.timer) {
							clearTimeout(inputbox.timer);
						}
						inputbox.timer = setTimeout(function() {
							$(target).inputbox("validate");
						}, inputbox.definations.delay);
					} else {
						setValidateTipPosition(target);
					}
					setTimeout(arguments.callee, 200);
				}
			})();
		}).bind("blur.inputbox", function() {
			if (inputbox.timer) {
				clearTimeout(inputbox.timer);
				inputbox.timer = undefined;
			}
			inputbox.validating = false;
			removeTip(target);
		}).bind("mouseenter.inputbox", function() {
			if (inputBoxText.hasClass("inputbox-invalid")) {
				setValidateTip(target);
			}
		}).bind("mouseleave.inputbox", function() {
			if (!inputbox.validating) {
				removeTip(target);
			}
		});
	}
	;
	function setValidateTip(target) {
		var message = $.data(target, "inputbox").message;
		var tip = $.data(target, "inputbox").tip;
		if (!tip) {
			tip = $(
			        "<div class=\"inputbox-tip\">" + "<span class=\"inputbox-tip-content\">" + "</span>"
			                + "<span class=\"inputbox-tip-pointer\">" + "</span>" + "</div>").appendTo("body");
			$.data(target, "inputbox").tip = tip;
		}
		tip.find(".inputbox-tip-content").html(message);
		setValidateTipPosition(target);
	}
	;
	function setValidateTipPosition(target) {
		var inputbox = $.data(target, "inputbox");
		if (!inputbox) {
			return;
		}
		var tip = inputbox.tip;
		if (tip) {
			var box = $(target);
			var pointer = tip.find(".inputbox-tip-pointer");
			var content = tip.find(".inputbox-tip-content");
			tip.show();
			tip.css("top", box.offset().top - (content._outerHeight() - box._outerHeight()) / 2);
			if (inputbox.definations.tipPosition == "left") {
				tip.css("left", box.offset().left - tip._outerWidth());
				tip.addClass("inputbox-tip-left");
			} else {
				tip.css("left", box.offset().left + box._outerWidth());
				tip.removeClass("inputbox-tip-left");
			}
			pointer.css("top", (content._outerHeight() - pointer._outerHeight()) / 2);
		}
	}
	;
	function removeTip(target) {
		var tip = $.data(target, "inputbox").tip;
		if (tip) {
			tip.remove();
			$.data(target, "inputbox").tip = null;
		}
	}
	;
	function isValid(target) {
		var inputbox = $.data(target, "inputbox");
		if (inputbox == undefined) {
			return;
		}
		var definations = inputbox.definations;
		var tip = inputbox.tip;
		var box = $(target);
		var value = box.val();
		function addValidateMsg(msg) {
			inputbox.message = msg;
		}
		;
		function functionValid(validType) {
			var validTypeInfo = /([a-zA-Z_]+)(.*)/.exec(validType);
			var validateRule = definations.rules[validTypeInfo[1]];
			if (validateRule && value) {
				var validateRs = $.parser.localEval(validTypeInfo[2]);
				if (!validateRule["validator"](value, validateRs)) {
					box.addClass("inputbox-invalid");
					var message = validateRule["message"];
					if (validateRs) {
						for ( var i = 0; i < validateRs.length; i++) {
							message = message.replace(new RegExp("\\{" + i + "\\}", "g"), validateRs[i]);
						}
					}
					addValidateMsg(definations.invalidMessage || message);
					if (inputbox.validating) {
						setValidateTip(target);
					}
					return false;
				}
			}
			return true;
		}
		;
		if (definations.required) {
			if (value == "") {
				box.addClass("inputbox-invalid");
				addValidateMsg(definations.missingMessage);
				if (inputbox.validating) {
					setValidateTip(target);
				}
				return false;
			}
		}
		if (definations.validType) {
			if (typeof definations.validType == "string") {
				if (!functionValid(definations.validType)) {
					return false;
				}
			} else {
				for ( var i = 0; i < definations.validType.length; i++) {
					if (!functionValid(definations.validType[i])) {
						return false;
					}
				}
			}
		}
		box.removeClass("inputbox-invalid");
		removeTip(target);
		return true;
	}
	;
	$.fn.inputbox = function(definations, param) {
		if (typeof definations == "string") {
			return $.fn.inputbox.methods[definations](this, param);
		}
		definations = definations || {};
		return this.each(function() {
			var inputbox = $.data(this, "inputbox");
			if (inputbox) {
				$.extend(inputbox.definations, definations);
			} else {
				var newDefinations = $.extend({}, $.fn.inputbox.defaults, $.fn.inputbox.parseDefinations(this),
				        definations);
				validateClass(this, newDefinations);
				$.data(this, "inputbox", {
					definations : newDefinations
				});
			}
			inputBoxEvent(this);
		});
	};
	$.fn.inputbox.methods = {
	    destroy : function(jq) {
		    return jq.each(function() {
			    destroyItem(this);
		    });
	    },
	    validate : function(jq) {
		    return jq.each(function() {
			    isValid(this);
		    });
	    },
	    isValid : function(jq) {
		    return isValid(jq[0]);
	    }
	};
	$.fn.inputbox.parseDefinations = function(target) {
		var t = $(target);
		return $.extend({}, $.parser.parseDefinations(target, [ "validType", "missingMessage", "invalidMessage",
		        "tipPosition", {
			        delay : "number"
		        } ]), {
			required : (t.attr("required") ? true : undefined)
		});
	};
	$.fn.inputbox.defaults = {
	    required : false,
	    cusCls : null,
	    validType : null,
	    delay : 200,
	    missingMessage : "此项为必录项.",
	    invalidMessage : null,
	    tipPosition : "right",
	    rules : {
	        email : {
	            validator : function(value) {
		            return /^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i
		                    .test(value);
	            },
	            message : "请输入有效的Email地址."
	        },
	        url : {
	            validator : function(value) {
		            return /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i
		                    .test(value);
	            },
	            message : "请输入有效的URL."
	        },
	        length : {
	            validator : function(value, lengthInfo) {
		            var len = $.trim(value).length;
		            return len >= lengthInfo[0] && len <= lengthInfo[1];
	            },
	            message : "字段大小范围 {0} 到 {1}."
	        },
	        remote : {
	            validator : function(value, param) {
		            var data = {};
		            data[param[1]] = value;
		            var validateResult = $.ajax({
		                url : param[0],
		                dataType : "json",
		                data : data,
		                async : false,
		                cache : false,
		                type : "post"
		            }).responseText;
		            return validateResult == "true";
	            },
	            message : "校验未通过,请修改."
	        }
	    }
	};
})(jQuery);
