﻿/**
 * messager - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function create(el, showType, showSpeed, timeout) {
		var window = $(el).window("window");
		if (!window) {
			return;
		}
		switch (showType) {
		case null:
			window.show();
			break;
		case "slide":
			window.slideDown(showSpeed);
			break;
		case "fade":
			window.fadeIn(showSpeed);
			break;
		case "show":
			window.show(showSpeed);
			break;
		}
		var timeoutFun = null;
		if (timeout > 0) {
			timeoutFun = setTimeout(function() {
				windowShow(el, showType, showSpeed);
			}, timeout);
		}
		window.hover(function() {
			if (timeoutFun) {
				clearTimeout(timeoutFun);
			}
		}, function() {
			if (timeout > 0) {
				timeoutFun = setTimeout(function() {
					windowShow(el, showType, showSpeed);
				}, timeout);
			}
		});
	}
	;
	function windowShow(el, showType, showSpeed) {
		if (el.locked == true) {
			return;
		}
		el.locked = true;
		var windowObj = $(el).window("window");
		if (!windowObj) {
			return;
		}
		switch (showType) {
		case null:
			windowObj.hide();
			break;
		case "slide":
			windowObj.slideUp(showSpeed);
			break;
		case "fade":
			windowObj.fadeOut(showSpeed);
			break;
		case "show":
			windowObj.hide(showSpeed);
			break;
		}
		setTimeout(function() {
			$(el).window("destroy");
		}, showSpeed);
	}
	;
	function getMessageBody(definations) {
		var msgDeafultObj = $
		        .extend({}, $.fn.window.defaults, {
		            collapsible : false,
		            minimizable : false,
		            maximizable : false,
		            shadow : false,
		            draggable : false,
		            resizable : false,
		            closed : true,
		            style : { left : "", top : "", right : 0, zIndex : $.fn.window.defaults.zIndex++,
		                bottom : -document.body.scrollTop - document.documentElement.scrollTop },
		            onBeforeOpen : function() {
			            create(this, msgDeafultObj.showType, msgDeafultObj.showSpeed, msgDeafultObj.timeout);
			            return false;
		            }, onBeforeClose : function() {
			            windowShow(this, msgDeafultObj.showType, msgDeafultObj.showSpeed);
			            return false;
		            } }, { title : "", width : 250, height : 100, showType : "slide", showSpeed : 600, msg : "",
		            timeout : 4000 }, definations);
		msgDeafultObj.style.zIndex = $.fn.window.defaults.zIndex++;
		var messagerBody = $("<div class=\"messager-body\"></div>").html(msgDeafultObj.msg).appendTo("body");
		messagerBody.window(msgDeafultObj);
		messagerBody.window("window").css(msgDeafultObj.style);
		messagerBody.window("open");
		return messagerBody;
	}
	;
	function createMsgWindow(title, msgContent, msgFuns) {
		var win = $("<div class=\"messager-body\"></div>").appendTo("body");
		win.append(msgContent);
		if (msgFuns) {
			var tb = $("<div class=\"messager-button\"></div>").appendTo(win);
			for ( var fun in msgFuns) {
				$("<a></a>").attr("href", "javascript:void(0)").text(fun).css("margin-left", 10).bind("click",
						$.parser.localEval(msgFuns[fun])).appendTo(tb).linkbutton();
			}
		}
		var height = $(win).height()+37;
		win.window({ title : title, noheader : (title ? false : true), width : 300, height : height, modal : true,
		    collapsible : false, minimizable : false, maximizable : false, resizable : false, onClose : function() {
			    setTimeout(function() {
				    win.window("destroy");
			    }, 100);
		    } });
		win.window("window").addClass("messager-window");
		win.children("div.messager-button").children("a:first").focus();
		return win;
	}
	;
	$.messager = {
	    show : function(definations) {
		    return getMessageBody(definations);
	    },
	    alert : function(title, msg, icon, fn) {
		    var msgContent = "<div>" + msg + "</div>";
		    switch (icon) {
		    case "error":
			    msgContent = "<div class=\"messager-icon messager-error\"></div>" + msgContent;
			    break;
		    case "info":
			    msgContent = "<div class=\"messager-icon messager-info\"></div>" + msgContent;
			    break;
		    case "question":
			    msgContent = "<div class=\"messager-icon messager-question\"></div>" + msgContent;
			    break;
		    case "warning":
			    msgContent = "<div class=\"messager-icon messager-warning\"></div>" + msgContent;
			    break;
		    }
		    msgContent += "<div style=\"clear:both;\"/>";
		    var msgFuns = {};
		    msgFuns[$.messager.defaults.ok] = function() {
			    win.window("close");
			    if (fn) {
				    fn();
				    return false;
			    }
		    };
		    var win = createMsgWindow(title, msgContent, msgFuns);
		    return win;
	    },
	    confirm : function(title, msg, fn) {
		    var msgContent = "<div class=\"messager-icon messager-question\"></div>" + "<div>" + msg + "</div>"
		            + "<div style=\"clear:both;\"/>";
		    var msgFuns = {};
		    msgFuns[$.messager.defaults.ok] = function() {
			    win.window("close");
			    if (fn) {
				    fn(true);
				    return false;
			    }
		    };
		    msgFuns[$.messager.defaults.cancel] = function() {
			    win.window("close");
			    if (fn) {
				    fn(false);
				    return false;
			    }
		    };
		    var win = createMsgWindow(title, msgContent, msgFuns);
		    return win;
	    },
	    prompt : function(title, msg, fn) {
		    var msgContent = "<div class=\"messager-icon messager-question\"></div>" + "<div>" + msg + "</div>"
		            + "<br/>" + "<div style=\"clear:both;\"/>"
		            + "<div><input class=\"messager-input\" type=\"text\"/></div>";
		    var msgFuns = {};
		    msgFuns[$.messager.defaults.ok] = function() {
			    win.window("close");
			    if (fn) {
				    fn($(".messager-input", win).val());
				    return false;
			    }
		    };
		    msgFuns[$.messager.defaults.cancel] = function() {
			    win.window("close");
			    if (fn) {
				    fn();
				    return false;
			    }
		    };
		    var win = createMsgWindow(title, msgContent, msgFuns);
		    win.children("input.messager-input").focus();
		    return win;
	    },
	    progress : function(definationsOrMethod) {
		    var getMethodFun = { bar : function() {
			    return $("body>div.messager-window").find("div.messager-p-bar");
		    }, close : function() {
			    var win = $("body>div.messager-window>div.messager-body:has(div.messager-progress)");
			    if (win.length) {
				    win.window("close");
			    }
		    } };
		    if (typeof definationsOrMethod == "string") {
			    var methodFun = getMethodFun[definationsOrMethod];
			    return methodFun();
		    }
		    var msgDefined = $
		            .extend({ title : "", msg : "", text : undefined, interval : 300 }, definationsOrMethod || {});
		    var messagerProgress = "<div class=\"messager-progress\"><div class=\"messager-p-msg\"></div><div class=\"messager-p-bar\"></div></div>";
		    var win = createMsgWindow(msgDefined.title, messagerProgress, null);
		    win.find("div.messager-p-msg").html(msgDefined.msg);
		    var bar = win.find("div.messager-p-bar");
		    bar.progressbar({ text : msgDefined.text });
		    win.window({ closable : false, onClose : function() {
			    if (this.timer) {
				    clearInterval(this.timer);
			    }
			    $(this).window("destroy");
		    } });
		    if (msgDefined.interval) {
			    win[0].timer = setInterval(function() {
				    var v = bar.progressbar("getValue");
				    v += 10;
				    if (v > 100) {
					    v = 0;
				    }
				    bar.progressbar("setValue", v);
			    }, msgDefined.interval);
		    }
		    return win;
	    } };
	$.messager.defaults = { ok : "Ok", cancel : "Cancel" };
})(jQuery);
