﻿/**
 * numberspinner - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function create(target) {
		$(target).addClass("numberspinner-f");
		var definations = $.data(target, "numberspinner").definations;
		$(target).spinner(definations).numberbox(definations);
	}
	;
	function incrementValue(target, opFlag) {
		var definations = $.data(target, "numberspinner").definations;
		var v = parseFloat($(target).numberbox("getValue") || definations.value) || 0;
		if (opFlag == true) {
			v -= definations.increment;
		} else {
			v += definations.increment;
		}
		$(target).numberbox("setValue", v);
	}
	;
	$.fn.numberspinner = function(definations, param) {
		if (typeof definations == "string") {
			var fun = $.fn.numberspinner.methods[definations];
			if (fun) {
				return fun(this, param);
			} else {
				return this.spinner(definations, param);
			}
		}
		definations = definations || {};
		return this.each(function() {
			var numberspinner = $.data(this, "numberspinner");
			if (numberspinner) {
				$.extend(numberspinner.definations, definations);
			} else {
				$.data(this, "numberspinner", { definations : $.extend({}, $.fn.numberspinner.defaults, $.fn.numberspinner
				        .parseDefinations(this), definations) });
			}
			create(this);
		});
	};
	$.fn.numberspinner.methods = {
	    definations : function(jq) {
		    var definations = $.data(jq[0], "numberspinner").definations;
		    return $.extend(definations, { value : jq.numberbox("getValue"),
		        originalValue : jq.numberbox("definations").originalValue });
	    }, setValue : function(jq, value) {
		    return jq.each(function() {
			    $(this).numberbox("setValue", value);
		    });
	    }, getValue : function(jq) {
		    return jq.numberbox("getValue");
	    }, clear : function(jq) {
		    return jq.each(function() {
			    $(this).spinner("clear");
			    $(this).numberbox("clear");
		    });
	    }, reset : function(jq) {
		    return jq.each(function() {
			    var definations = $(this).numberspinner("definations");
			    $(this).numberspinner("setValue", definations.originalValue);
		    });
	    } };
	$.fn.numberspinner.parseDefinations = function(target) {
		return $.extend({}, $.fn.spinner.parseDefinations(target), $.fn.numberbox.parseDefinations(target), {});
	};
	$.fn.numberspinner.defaults = $.extend({}, $.fn.spinner.defaults, $.fn.numberbox.defaults,
	        { spin : function(opFlag) {
		        incrementValue(this, opFlag);
	        } });
})(jQuery);
