﻿/**
 * textareabox - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function setSize(target, sizeValue) {
		var textareaboxDefinations = $.data(target, "textareabox").definations;
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		if (sizeValue) {
			textareaboxDefinations.width = sizeValue;
		} else {
			var clientWidth = $(target).parent()._outerWidth();
			textareaboxObj._outerWidth(clientWidth - 3);
		}
		textareaboxObj.appendTo("body");
		var textareaboxTextObj = textareaboxObj.find("input.textareabox-text");
		var textareaboxIconObj = textareaboxObj.find(".textareabox-icon");
		var iconWidth = textareaboxDefinations.hasIcon ? textareaboxIconObj._outerWidth() : 0;
		textareaboxObj._outerWidth(textareaboxDefinations.width)._outerHeight(textareaboxDefinations.height);
		textareaboxTextObj._outerWidth(textareaboxObj.width() - iconWidth);
		textareaboxTextObj.css({ height : textareaboxObj.height() + "px", lineHeight : textareaboxObj.height() + "px" });
		textareaboxIconObj._outerHeight(textareaboxObj.height());
		textareaboxObj.insertAfter(target);
	}
	;
	function createTextareaboxObj(target, definations) {
		$(target).addClass("textareabox-text");
		$(target).addClass("textareabox-f");
		var textareaboxObj = null;
		if (definations.border) {
			textareaboxObj = $("<span class=\"textareabox\" style=\"border-width:1px\"></span>").insertAfter(target);
		} else {
			textareaboxObj = $("<span class=\"textareabox\"></span>").insertAfter(target);
		}
		return { textareabox : textareaboxObj };
	}
	;
	function destroy(target) {
		var textareaboxTextObj = $.data(target, "textareabox").textareabox.find("input.textareabox-text");
		textareaboxTextObj.inputbox("destroy");
		$.data(target, "textareabox").textareabox.remove();
		$(target).remove();
	}
	;
	function bindEvents(target) {
		var textareaboxObj = $.data(target, "textareabox");
		var textareaboxDefinations = textareaboxObj.definations;
		var textareaboxObjInner = $.data(target, "textareabox").textareabox;
		var textareaboxText = textareaboxObjInner.find(".textareabox-text");
		var textareaboxIcon = textareaboxObjInner.find(".textareabox-icon");
		$(document).unbind(".textareabox").bind("mousedown.textareabox", function(e) {

		});
		textareaboxObjInner.unbind(".textareabox");
		textareaboxText.unbind(".textareabox");
		textareaboxIcon.unbind(".textareabox");
		if (!textareaboxDefinations.disabled) {
			textareaboxText.bind("mousedown.textareabox", function(e) {
				e.stopPropagation();
			}).bind("keydown.textareabox", function(e) {
				switch (e.keyCode) {
					case 38:
						textareaboxDefinations.keyHandler.up.call(target);
						break;
					case 40:
						textareaboxDefinations.keyHandler.down.call(target);
						break;
					case 13:
						e.preventDefault();
						textareaboxDefinations.keyHandler.enter.call(target);
						return false;
					case 9:
					case 27:
						break;
					default:
						if (textareaboxDefinations.editable) {
							if (textareaboxObj.timer) {
								clearTimeout(textareaboxObj.timer);
							}
							textareaboxObj.timer = setTimeout(function() {
								var q = textareaboxText.val();
								if (textareaboxObj.previousValue != q) {
									textareaboxObj.previousValue = q;
									textareaboxDefinations.keyHandler.query.call(target, textareaboxText.val());
									validate(target, true);
								}
							}, textareaboxDefinations.delay);
						}
				}
			});
			textareaboxIcon.bind("click.textareabox", function() {
				textareaboxDefinations.value = textareaboxText.val();
				var name = textareaboxText.attr("name");
				textareaboxDefinations.searcher.call(target, textareaboxDefinations.value, name);
				textareaboxText.focus();
			}).bind("mouseenter.textareabox", function() {
				$(this).addClass("textareabox-icon-hover");
			}).bind("mouseleave.textareabox", function() {
				$(this).removeClass("textareabox-icon-hover");
			}).bind("mousedown.textareabox", function() {
			});
		}
	}
	;
	function validate(target, validateFlag) {
		var textareaboxDefinations = $.data(target, "textareabox").definations;
		var textareaboxObj = $.data(target, "textareabox").textareabox.find("input.textareabox-text");
		textareaboxObj.inputbox(textareaboxDefinations);
		if (validateFlag) {
			textareaboxObj.inputbox("validate");
		}
	}
	;
	function setDisabled(target, flag) {
		var textareaboxDefinations = $.data(target, "textareabox").definations;
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		if (flag) {
			textareaboxDefinations.disabled = true;
			$(target).attr("disabled", true);
			textareaboxObj.find(".textareabox-text").attr("disabled", true);
		} else {
			textareaboxDefinations.disabled = false;
			$(target).removeAttr("disabled");
			textareaboxObj.find(".textareabox-text").removeAttr("disabled");
		}
	}
	;
	function clear(target) {
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		textareaboxObj.find("input.textareabox-text").val("");
	}
	;
	function getTextareaboxValue(target) {
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		return textareaboxObj.find("input.textareabox-text").val();
	}
	;
	function setTextareaboxValue(target, textValue) {
		var textareaboxObj = $.data(target, "textareabox").textareabox;
		textareaboxObj.find("input.textareabox-text").val(textValue);
		validate(target, true);
		$.data(target, "textareabox").previousValue = textValue;
	}
	;
	function textareaboxOnChange(textareaboxObj) {
		var textareaboxDefinations = $.data(textareaboxObj, "textareabox").definations;
		var fn = textareaboxDefinations.onChange;
		textareaboxDefinations.onChange = function() {
		};
		setTextareaboxValue(textareaboxObj, textareaboxDefinations.value);
		textareaboxDefinations.originalValue = textareaboxDefinations.value;
		textareaboxDefinations.onChange = fn;
	}
	;
	$.fn.textareabox = function(definations, param) {
		if (typeof definations == "string") {
			return $.fn.textareabox.methods[definations](this, param);
		}
		definations = definations || {};
		return this.each(function() {
			var textareaboxObj = $.data(this, "textareabox");
			if (textareaboxObj) {
				$.extend(textareaboxObj.definations, definations);
			} else {
				var newDefinations = $.extend({}, $.fn.textareabox.defaults, $.fn.textareabox.parseDefinations(this), definations);
				var r = createTextareaboxObj(this, newDefinations);
				textareaboxObj = $.data(this, "textareabox", { definations : newDefinations, textareabox : r.textareabox,
					previousValue : null });
				$(this).removeAttr("disabled");
			}
			$("input.textareabox-text", textareaboxObj.textareabox).attr("readonly", !textareaboxObj.definations.editable);
			setDisabled(this, textareaboxObj.definations.disabled);
			setSize(this);
			bindEvents(this);
			validate(this);
			textareaboxOnChange(this);
		});
	};
	$.fn.textareabox.methods = { definations : function(jq) {
		return $.data(jq[0], "textareabox").definations;
	}, textbox : function(jq) {
		return $.data(jq[0], "textareabox").textareabox.find("input.textareabox-text");
	}, destroy : function(jq) {
		return jq.each(function() {
			destroy(this);
		});
	}, resize : function(jq, width) {
		return jq.each(function() {
			setSize(this, width);
		});
	}, disable : function(jq) {
		return jq.each(function() {
			setDisabled(this, true);
			bindEvents(this);
		});
	}, enable : function(jq) {
		return jq.each(function() {
			setDisabled(this, false);
			bindEvents(this);
		});
	}, validate : function(jq) {
		return jq.each(function() {
			validate(this, true);
		});
	}, isValid : function(jq) {
		var textareaboxTextObj = $.data(jq[0], "textareabox").textareabox.find("input.textareabox-text");
		return textareaboxTextObj.inputbox("isValid");
	}, clear : function(jq) {
		return jq.each(function() {
			clear(this);
		});
	}, reset : function(jq) {
		return jq.each(function() {
			var textareaboxDefinations = $.data(this, "textareabox").definations;
			$(this).textareabox("setValue", textareaboxDefinations.originalValue);
		});
	}, getValue : function(jq) {
		return getTextareaboxValue(jq[0]);
	}, setValue : function(jq, v) {
		return jq.each(function() {
			setTextareaboxValue(this, v);
		});
	} };
	$.fn.textareabox.parseDefinations = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.inputbox.parseDefinations(target), $.parser.parseDefinations(target, [ "width", "height",
				"separator", { editable : "boolean", hasIcon : "boolean", delay : "number" } ]), {
			multiple : (t.attr("multiple") ? true : undefined), disabled : (t.attr("disabled") ? true : undefined),
			value : (t.val() || undefined), searcher : (t.attr("searcher") ? $.parser.localEval(t.attr("searcher")) : undefined) });
	};
	$.fn.textareabox.defaults = $.extend({}, $.fn.inputbox.defaults, { border : false, width : "auto", height : 60,
		multiple : false, separator : ",", editable : true, disabled : false, value : "", delay : 200,
		keyHandler : { up : function() {
		}, down : function() {
		}, enter : function() {
		}, query : function(q) {
		} }, onChange : function(_60, _61) {
		} });
})(jQuery);
