﻿/**
 * timespinner - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function create(target) {
		var definations = $.data(target, "timespinner").definations;
		$(target).addClass("timespinner-f");
		$(target).spinner(definations);
		$(target).unbind(".timespinner");
		$(target).bind("click.timespinner", function() {
			var startNum = 0;
			if (this.selectionStart != null) {
				startNum = this.selectionStart;
			} else {
				if (this.createTextRange) {
					var textRange = target.createTextRange();
					var s = document.selection.createRange();
					s.setEndPoint("StartToStart", textRange);
					startNum = s.text.length;
				}
			}
			if (startNum >= 0 && startNum <= 2) {
				definations.highlight = 0;
			} else {
				if (startNum >= 3 && startNum <= 5) {
					definations.highlight = 1;
				} else {
					if (startNum >= 6 && startNum <= 8) {
						definations.highlight = 2;
					}
				}
			}
			handelRange(target);
		}).bind("blur.timespinner", function() {
			setValue(target);
		});
	}
	;
	function handelRange(target) {
		var definations = $.data(target, "timespinner").definations;
		var startNum = 0, endNum = 0;
		if (definations.highlight == 0) {
			startNum = 0;
			endNum = 2;
		} else {
			if (definations.highlight == 1) {
				startNum = 3;
				endNum = 5;
			} else {
				if (definations.highlight == 2) {
					startNum = 6;
					endNum = 8;
				}
			}
		}
		if (target.selectionStart != null) {
			target.setSelectionRange(startNum, endNum);
		} else {
			if (target.createTextRange) {
				var textRange = target.createTextRange();
				textRange.collapse();
				textRange.moveEnd("character", endNum);
				textRange.moveStart("character", startNum);
				textRange.select();
			}
		}
		$(target).focus();
	}
	;
	function getDateByNum(target, value) {
		var definations = $.data(target, "timespinner").definations;
		if (!value) {
			return null;
		}
		var vv = value.split(definations.separator);
		for ( var i = 0; i < vv.length; i++) {
			if (isNaN(vv[i])) {
				return null;
			}
		}
		while (vv.length < 3) {
			vv.push(0);
		}
		return new Date(1900, 0, 0, vv[0], vv[1], vv[2]);
	}
	;
	function setValue(target) {
		var definations = $.data(target, "timespinner").definations;
		var value = $(target).val();
		var date = getDateByNum(target, value);
		if (!date) {
			date = getDateByNum(target, definations.value);
		}
		if (!date) {
			definations.value = "";
			$(target).val("");
			return;
		}
		var dateMin = getDateByNum(target, definations.min);
		var dateMax = getDateByNum(target, definations.max);
		if (dateMin && dateMin > date) {
			date = dateMin;
		}
		if (dateMax && dateMax < date) {
			date = dateMax;
		}
		var tt = [ getNum(date.getHours()), getNum(date.getMinutes()) ];
		if (definations.showSeconds) {
			tt.push(getNum(date.getSeconds()));
		}
		var val = tt.join(definations.separator);
		definations.value = val;
		$(target).val(val);
		function getNum(num) {
			return (num < 10 ? "0" : "") + num;
		}
		;
	}
	;
	function highlightTimespinner(target, number) {
		var definations = $.data(target, "timespinner").definations;
		var val = $(target).val();
		if (val == "") {
			val = [ 0, 0, 0 ].join(definations.separator);
		}
		var vv = val.split(definations.separator);
		for ( var i = 0; i < vv.length; i++) {
			vv[i] = parseInt(vv[i], 10);
		}
		if (number == true) {
			vv[definations.highlight] -= definations.increment;
		} else {
			vv[definations.highlight] += definations.increment;
		}
		$(target).val(vv.join(definations.separator));
		setValue(target);
		handelRange(target);
	}
	;
	$.fn.timespinner = function(definations, param) {
		if (typeof definations == "string") {
			var fun = $.fn.timespinner.methods[definations];
			if (fun) {
				return fun(this, param);
			} else {
				return this.spinner(definations, param);
			}
		}
		definations = definations || {};
		return this.each(function() {
			var timespinner = $.data(this, "timespinner");
			if (timespinner) {
				$.extend(timespinner.definations, definations);
			} else {
				$.data(this, "timespinner", { definations : $.extend({}, $.fn.timespinner.defaults, $.fn.timespinner
				        .parseDefinations(this), definations) });
				create(this);
			}
		});
	};
	$.fn.timespinner.methods = { definations : function(jq) {
		var definations = $.data(jq[0], "timespinner").definations;
		return $.extend(definations, { value : jq.val(), originalValue : jq.spinner("definations").originalValue });
	}, setValue : function(jq, v) {
		return jq.each(function() {
			$(this).val(v);
			setValue(this);
		});
	}, getHours : function(jq) {
		var definations = $.data(jq[0], "timespinner").definations;
		var vv = jq.val().split(definations.separator);
		return parseInt(vv[0], 10);
	}, getMinutes : function(jq) {
		var definations = $.data(jq[0], "timespinner").definations;
		var vv = jq.val().split(definations.separator);
		return parseInt(vv[1], 10);
	}, getSeconds : function(jq) {
		var definations = $.data(jq[0], "timespinner").definations;
		var vv = jq.val().split(definations.separator);
		return parseInt(vv[2], 10) || 0;
	} };
	$.fn.timespinner.parseDefinations = function(target) {
		return $.extend({}, $.fn.spinner.parseDefinations(target), $.parser.parseDefinations(target, [ "separator",
		        { showSeconds : "boolean", highlight : "number" } ]));
	};
	$.fn.timespinner.defaults = $.extend({}, $.fn.spinner.defaults, { separator : ":", showSeconds : false,
	    highlight : 0, spin : function(number) {
		    highlightTimespinner(this, number);
	    } });
})(jQuery);
