﻿/**
 * 页面初始化 Download by http://www.codefans.net
 */
$(document).ready(function () {
	//初始化select初始时间
	initSelectTime();
	//初始化时间显示区域
	setCurrentDate();
	//读取cookies,如果存在则填充
	fillTipItems();
	//初始化提醒事件
	iniTipNotifySet();
	//初始化默认select铃声
	$("#sel_bg").val('-1');
	
	
})
/**
 *	初始化select时间,默认当前时间的下一分钟
 */
function initSelectTime() {
	var nowDate = new Date();
	$("#hour").val(nowDate.getHours());
	$("#min").val(nowDate.getMinutes() + 1);
}
/**
 *	设置动态时间
 */
function setCurrentDate() {
	var nowDate = new Date();
	var dateStr = "本机时间：" + nowDate.getHours() + '时' + nowDate.getMinutes() + '分' + nowDate.getSeconds() + '秒'
		$(".time").html(dateStr);
	setTimeout('setCurrentDate()', 1000);
}
/**
 *	添加提醒标签
 */
var tipcount = 1;
function addTip() {
	var nzhour = $("#hour").val(); //小时
	var nzmin = $("#min").val(); //分钟
	var selbg = $("#sel_bg").val(); //音乐
	var tipmsg = $("#tip").val(); //提示信息
	//1:单次  2:每天
	var cfplvalue = $("[type='radio'][name='freq']:checked").val(); //频率value
	var cfpl = (cfplvalue==1?'单次':'每日');
	var nowDate=new Date();
	var setDate=nowDate.getFullYear().toString() + "-" + nowDate.getMonth() + "-" + nowDate.getDate(); //2012-5-2
	var id =(new Date()).getTime()+parseInt(Math.random()*100000);		//id
	if(compareTime(nzhour.toString()+":"+nzmin)<0){
		alert('闹钟时间必须大于当前时间,请重新选择!');
		return ;
	}
	
	if (tipcount <= 8) {
		$("#info-main").append(
			'<div class=info>' +
			'<input type="hidden" name="date" value="'+setDate+'"/>'+
			'<input type="hidden" name="id" value="'+id+'"/>'+
			'<input type="hidden" name="selbg" value="'+selbg+'"/>'+
			'<div class=info-l>' +
			'<span class=info-num' + tipcount + '></span><span val=' + cfplvalue + '>' + cfpl + ':</span>' +
			'<span class=info-t>' + nzhour + ":" + nzmin + '</span>' +
			'<span class=info-c title="' + tipmsg + '">' + tipmsg + '</span>' +
			'</div>' +
			'<div class=info-r>' +
			'<a href="javascript:void(0)" title="删除" onclick="removeTip(this)"></a>' +
			'</div>' +
			'</div>');
		tipcount++;
	} else {
		alert('最多可设置八个提醒，请“取消”之前的提醒后重试');
	}
	setTipToCookies(getTipsItems()); //保存到cookie
	iniTipNotifySet();	//重新注册事件
}
/**
 *	获取页面Tip设置信息,封装成Array
 */
function getTipsItems() {
	var count = 0;
	var tiparray = new Array($(".info").length);
	var nowDate = new Date();
	$(".info").each(function () {
		var obj = new Object();
		obj.id = $(this).find("[type='hidden'][name='id']").val(); //id
		obj.date = $(this).find("[type='hidden'][name='date']").val(); //2012-5-2
		obj.hour = $(this).find("[class='info-t']").text().split(":")[0]; //小时
		obj.min = $(this).find("[class='info-t']").text().split(":")[1]; //分钟
		obj.tipmsg = $(this).find("[class='info-c']").attr("title"); //提示信息
		obj.cfpl = $(this).find("[class^='info-num']").next().text(); //频率文字
		obj.cfplvalue = $(this).find("[class^='info-num']").next().attr("val"); //频率value
		obj.selbg=$(this).find("[type='hidden'][name='selbg']").val();	//音乐
		tiparray[count++] = obj;
	})
	return tiparray;
}

/**
 *	从cookies中读取数据并填充
 */
function fillTipItems() {
	var items = readTipToCookies('tipset');
	if (items == null && items == 'undefined' && items == '')
		return;
	var count = 1;
	$(items).each(function () {
		$("#info-main").append(
			'<div class=info>' +
			'<input type="hidden" name="date" value="'+this.date+'"/>'+
			'<input type="hidden" name="id" value="'+this.id+'"/>'+
			'<input type="hidden" name="selbg" value="'+this.selbg+'"/>'+
			'<div class=info-l>' +
			'<span class=info-num' + count + '></span><span val=' + this.cfplvalue + '>' + this.cfpl + '</span>' +
			'<span class=info-t>' + this.hour + ":" + this.min + '</span>' +
			'<span class=info-c title="' + this.tipmsg + '">' + this.tipmsg + '</span>' +
			'</div>' +
			'<div class=info-r>' +
			'<a href="javascript:void(0)" title="删除" onclick="removeTip(this)"></a>' +
			'</div>' +
			'</div>');
		//将填充后的count给全局tipcoung
		tipcount = ++count;
	})
	
}

/**
 *	将设置信息保存到cookies中
 *	json格式:
 *   {
 *		tipset:[{
 *			id:id,
 *			date:date,
 *			hour:hour,
 *			min:min,
 *			sel_bg:sel_bg,
 *			tipmsg:tipmsg,
 *			cfpl:cfpl,
 *			cfplvalue:cfplvalue,
 *		  }]
 *	  }
 */
function setTipToCookies(arrayobj) {
	var oldTipArray = arrayobj;
	var str = JSON.stringify(oldTipArray);
	//console.debug(str);
	$.cookie("tipset", str);
}

/**
 * 读取cookies 返回 obj对象
 */
function readTipToCookies(name) {
	var myCookie = $.cookie(name);
	if (myCookie == '' || myCookie == null || myCookie == 'undefined') {
		return;
	} else {
		//console.debug(JSON.parse(myCookie));
		return JSON.parse(myCookie);
	}
}

/**
 *	重置序号样式
 */
function setClassNum() {
	var i = 1;
	$("[class^='info-num']").each(function () {
		$(this).attr('class', "info-num" + i);
		i++;
	})
}

/**
 *	删除提醒标签
 */
function removeTip(obj) {
	$(obj).parent().parent().remove();
	tipcount--;
	setClassNum(); //重置序号class
	setTipToCookies(getTipsItems()); //保存到cookie
	iniTipNotifySet();	//重新注册事件
}
/**
  *	根据cookies 注册提示事件
  */
function iniTipNotifySet() {
	var tiparray = readTipToCookies('tipset');
	var msghead = '';
	if(tiparray==undefined||tiparray==''||tiparray==null)
		return;
	$.each(tiparray, function (index, value) {
		msghead = '闹钟提醒';
		var timecomp = getDateByStr(tiparray[index].date, tiparray[index].hour + ":" + tiparray[index].min);
		//console.debug("iniTipNotifySet=>timecomp:"+timecomp+"|obj:"+tiparray[index].id);
		timecomp = countOffset(timecomp);
		if (timecomp > 0) {
			registerTipTimer(timecomp, msghead, tiparray[index]);
		} else if (timecomp == 0) {
			tipNotify(msghead, tiparray[index]);
		} else if (timecomp < 0) {
			msghead = "过期的闹钟提醒";
			tipNotify(msghead, tiparray[index]);
		}
	})
}
/**
 *	根据yyyy-MM-dd HH:mm:ss 时间字符串返回Date类型
 */
function getDateByStr(datestr, timestr) {
	var dates = datestr.split("-");
	var times = timestr.split(":");
	var cookiesdate = new Date();
	cookiesdate.setFullYear(Number(dates[0]));
	cookiesdate.setMonth(Number(dates[1]));
	cookiesdate.setDate(Number(dates[2]));
	cookiesdate.setHours(Number(times[0]));
	cookiesdate.setSeconds(0);
	cookiesdate.setMinutes(Number(times[1]));
	return cookiesdate;
}

/**
 *	根据cookiesdate时间和当前时间获取相差秒数
 */
function countOffset(cookiesdate) {
	var nowDate = new Date();
	//console.debug("cookiesdate:" + cookiesdate);
	//console.debug("秒:" + (cookiesdate - nowDate) / 1000);
	return (cookiesdate - nowDate) / 1000;
}

/**
 *	注册计时器
 */
function registerTipTimer(times, msghead, tipobj) {
	//注销已有事件
	$('body').stopTime(tipobj.id);
	//注册新的事件
	$('body').oneTime(times + 's', tipobj.id, function () {
		startSound(tipobj.selbg);
		//闹钟提醒：“15:32 该休息了！”
		alert(msghead + ":" + tipobj.hour + ":" + tipobj.min + "  " + tipobj.tipmsg);
		//执行回调函数,处理已经提示的信息
		removeTipReg(tipobj);
	});
}

/**
 *	根据tip设置信息弹出通知
 */
function tipNotify(msghead, tipobj) {
	startSound(tipobj.selbg);
	//闹钟提醒：“15:32 该休息了！”
	alert(msghead + ":" + tipobj.hour + ":" + tipobj.min + "  " + tipobj.tipmsg);
	//执行回调函数,处理已经提示的信息
	removeTipReg(tipobj);
}
/**
 *	信息提示后调用的回调函数
 */
function removeTipReg(obj) {
	var tiparray = readTipToCookies('tipset');
	$.each(tiparray, function (index, value) {
		if (tiparray[index] != undefined && tiparray[index] != 'undefined') {
			if (tiparray[index].id == obj.id) { //匹配cookies中元素
				//单次=>删除
				if (tiparray[index].cfplvalue == 1) { 
					tiparray.splice(index, 1);
					//删除页面对应的div
					$("[value='"+obj.id+"']").parent().remove();
				} 
				//每天=>将date+1(即延长执行时间)
				else if (tiparray[index].cfplvalue == 2) { 
					var tempdate = getDateByStr(tiparray[index].date, tiparray[index].hour + ":" + tiparray[index].min);
					tempdate.setDate(tempdate.getDate() + 1);
					tiparray[index].date = tempdate.getFullYear().toString() + "-" + tempdate.getMonth() + "-" + tempdate.getDate();
				}
			}
		}
	})
	closeSound();
	setTipToCookies(tiparray);
}

/**
  *	设置背景音乐
  */
function setBgSound(flag){
	var soundid=$("#sel_bg").val(); //音乐id
	
	if(flag=='select'){
		$("#test_bgs").val('停止');
		startSound(soundid);
	}else if(flag=='btn'){
		if($("#test_bgs").val()=='停止'){
			$("#test_bgs").val('试听');
			closeSound();
		}else if($("#test_bgs").val()=='试听'){
			$("#test_bgs").val('停止');
			startSound(soundid);
		}
	}		
}
/**
  *	根据背景音乐id播放音乐
  */
function startSound(id){
	var path='midi/';
	var soundid=id; //音乐
	path+=soundid+".mid";
	$("bgsound").attr("src",path);
}
/**
  *	停止播放音乐
  */
function closeSound(){
	$("bgsound").attr("src","#");
}

function compareTime(timestr){
	var nowDate=new Date();
	var datestr=nowDate.getFullYear().toString() + "-" + nowDate.getMonth() + "-" + nowDate.getDate()
	var comdate=getDateByStr(datestr,timestr);
	//console.debug("comdate:"+comdate+"||datestr:"+datestr);
	var result=comdate-nowDate;
	//console.debug("result:"+result);
	result=result/1000;
	return result;
}
