/**
 * @author 蓝面小生
 */
(function(){
    Simple.declare("Tip", null, {
        //触发tip的DOM节点
        node: null,
        //显示的内容
        source: "title",
        //延迟显示的时间
        delayShow: 300,
        //延迟隐藏的时间
        hideShow: 200,
        //触发tip的事件
        showEvent: "hover",
        //允许鼠标悬浮在tip上
        allowTipHover: true,
        //是否允许tip跟随鼠标移动
        allTipMove: false,
        //显示动画
        animate: "fade",
        //显示的位置
        position: ['top', 'left'],
        offset: [-10, 0],
        template: "<div class='simple-tip'><div class='simple-tip-flag' rel='tipFlag'></div><div class='simple-tip-content' rel='tipContent'></div></div>",
        init: function(){
            var self = this;
            if (this.node) {
                this.node = $(this.node);
                this.node.bind("tip/over", function(){
                    self.getContent();
                }).bind("tip/out", function(){
                    if (self.showTimeOut) {
                        clearTimeout(self.showTimeOut);
                    }
                    self.hide.call(self);
                });
                this.node.mouseenter(function(e){
                    var that = $(this);
                    that.data("active", true);
                    self.eventX = e.pageX;
                    self.eventY = e.pageY;
                    self.showTimeOut = setTimeout(function(){
                        that.trigger("tip/over");
                    }, self.delayShow);
                    return false;
                });
                
                this.node.mouseleave(function(){
                    var that = $(this);
                    self.hideTimeOut = setTimeout(function(){
                        that.data("active", false);
                        that.trigger("tip/out");
                    }, self.hideShow);
                    return false;
                });
                
                if (this.allTipMove) {
                    this.node.mousemove(function(e){
                        self.eventX = e.pageX;
                        self.eventY = e.pageY;
                        if (self.contentCon) {
                            self.show.call(self);
                        }
                    })
                }
                this.id = "simpleTip_" + new Date().getTime();
            }
        },
        destroy: function(){
            this.node.unbind("tip/over").unbind("tip/out");
        },
        getContent: function(){
            var self = this;
            this.createDom();
            if (this.source == "title") {
                this.getContentCallback(this.node.attr("title"));
            }
            else {
                this.content = this.source(function(data){
                    self.getContentCallback.call(self, data);
                });
            }
        },
        getContentCallback: function(content){
            this.content = content;
            this.show();
        },
        calculatePos: function(){
            var trigger = this.node, tip = this.template, arrow, top = trigger.offset().top, left = trigger.offset().left, pos = this.position[0];
            
            top -= tip.outerHeight() - this.offset[0];
            left += trigger.outerWidth() + this.offset[1];
            
            var height = tip.outerHeight() + trigger.outerHeight();
            if (pos == 'center') {
                top += height / 2;
            }
            if (pos == 'bottom') {
                top += height;
            }
            
            pos = this.position[1];
            var width = tip.outerWidth() + trigger.outerWidth();
            if (pos == 'center') {
                left -= width / 2;
            }
            if (pos == 'left') {
                left -= width;
                left += tip.outerWidth() / 2;
            }
            if (this.position[0] == "top") {
                arrow = "bottom"
            }
            else 
                if (this.position[0] == "bottom") {
                    arrow = "top"
                }
                else 
                    if (this.position[1] == "left") {
                        arrow = "right";
                    }
                    else {
                        arrow = "left";
                    }
            
            this.pos = {
                l: left,
                t: top,
                arrow: arrow
            }
            //return {top: top, left: left};
        },
        createDom: function(){
            var self = this;
            if ($(".simple-tip")[0]) {
                this.template = $(".simple-tip");
            }
            else {
                this.template = $(this.template);
            }
            this.flag = this.template.find("[rel=tipFlag]");
            this.contentCon = this.template.find('[rel=tipContent]');
            
            if (this.allowTipHover) {
                self.template.unbind().mouseenter(function(){
                    clearTimeout(self.hideTimeOut);
                    clearTimeout(self.tHideTime);
                }).mouseleave(function(){
                    self.tHideTime = setTimeout(function(){
                        self.template.hide();
                    }, 200)
                });
            }
            this.template.show().appendTo(document.body);
            this.template[0].id = this.id;
        },
        show: function(){
            if (this.node.data("active")) {
                this.contentCon.html(this.content);
                this.calculatePos();
                this.template.css({
                    top: this.pos.t,
                    left: this.pos.l
                })
                this.flag.removeClass().addClass("simple-tip-flag simple-tip-" + this.pos.arrow);
            }
        },
        hide: function(){
            $(this.template).hide();
        }
    });
    
    Simple.bridgeTojQuery("simpletip,tip", Simple.Tip);
    
    Simple.popTip=function(){
        var Tip = function(text, container, type, timeout){
            this.template = '<div class="simple-load" style="position:fixed;_position:absolute;"><span class="simple-load-l"></span><div class="simple-load-bg"></div><div class="simple-load-text"><i></i><label>正在导入中...</label></div></div>';
            this.text = text;
            this.node = $(this.template).clone();
            this.container = typeof container == "string" ? $(container) : container;
            this.type = type;
            this.timeout = timeout;
            this.init();
        }
        Tip.prototype = {
            init: function(){
                $(".simple-load").remove();
                var self = this;
                switch (this.type) {
                    case "load":
                        this.node.addClass("simple-tip-load");
                        break;
                    case "success":
                        this.node.addClass("simple-tip-success");
                        break;
                    case "info":
                        this.node.addClass("simple-tip-info");
                        break;
                    case "alert":
                        this.node.addClass("simple-tip-alert");
                        break;
                }
                this.show();
				self.timeout=self.timeout||2000;
                if (this.type != "load") {
                    setTimeout(function(){
                        self.hide();
                    }, self.timeout);
                }
            },
            show: function(){
                var self = this;
                $(document.body).append(this.node);
                this.node.find(".simple-load-text label").html(this.text);
                //fix ie6
                var simpleTextWidth = this.node.find(".simple-load-text").width() + parseInt(this.node.find(".simple-load-text").css("paddingLeft"));
                this.node.width(simpleTextWidth);
                this.node.find(".simple-load-bg").width(simpleTextWidth + 10);
                this.setPosition();
                //listen resize
                $(window).resize(function(){
                    self.setPosition();
                });
            },
            hide: function(){
                this.node.remove();
            },
            setPosition: function(){
                var width, height, nodeWidth = this.node.width(), nodeHeight = this.node.height();
                if (this.container) {
                    width = this.container.width();
                    height = this.container.height();
                }
                else {
                    width = document.documentElement.clientWidth;
                    height = document.documentElement.clientHeight;
                }
                
                this.node.css({
                    top: (height - nodeHeight) / 3,
                    left: ((width - nodeWidth) / 2) + 12
                });
            }
        }
        
        return {
            load: function(text, container){
                return new Tip(text, container, "load");
            },
            success: function(text, timeout, container){
                return new Tip(text, container, "success", timeout);
            },
            info: function(text, timeout, container){
                return new Tip(text, container, "info", timeout);
            },
            alert: function(text, timeout, container){
                return new Tip(text, container, "alert", timeout);
            }
        }
    }();
	
    var tipMethod=Simple.popTip;
	$.each(tipMethod,function(k,v){
		jQuery[k+"Tip"]=v;
	})
})();
