/**
 * author:半盏凉茶
 * date:2011-07-04
 */
 
//分页
(function(){
	Simple.declare("Pagination",null, {
		node: null,
		current:1,//当前页码
		count: 0,//记录总数
		size: 10,//每页的记录数量
		maxPage: 5,//最多显示N页，此处建议写单数居中会比较好看
		callBack: function(a,b){},//回调
		_Template: '',//模版
		_PageCount: 0,//分页数量
		_maxPageIndex: 0,//最大页的位置
		init: function(){
			var _self = this;
						
			//计算分页数量
			_self.count % _self.size == 0 ? _self._PageCount =_self. count / _self.size : _self._PageCount = Math.floor(_self.count / _self.size) + 1;

			//初始化分页的最大值
			_self._maxPageIndex = _self.maxPage > _self.count ? _self.count : _self.maxPage;

			//获得分页的一半用于计算
			_self._halfMaxPage = Math.floor(_self.maxPage / 2);		
			
			_self._Go2(_self.current);
		},
		_Go2 : function(page){
			var _self = this;
			_self._Template = '';
			page = parseInt(page);
			
			if(page > _self._PageCount || page < 1){
				alert('您输入的页码超出了范围！');
				return;
			}
			
			_self.current = page;
			
			
			_self._GetPaginationHtml();
			_self._Template +='<span class="Y-page-skip">共 '+ _self._PageCount +' 页,到第<input type="text" class="Y-page-jumpto" value="' + (page) + '"/>页 ';
			_self._Template +='<button title="指定页码" class="Y-page-submit">确定</button></span>';
			
			if(_self.callBack){
				_self.callBack(_self.current, _self.size);
			}
			
			$(_self.node).html(_self._Template);
			
			$('a',_self.node).click(function(){
				_self._Go2($(this).attr('data-pager'));
			})
			
			var jump2 = $('.Y-page-jumpto',_self.node);
			
			jump2.focus(function(){
				jump2.val('');
			});
			
			$('.Y-page-submit',_self.node).click(function(){
				if(jump2.val() == ''){
					alert('请输入页码！');
					return;
				}else if(page == jump2.val()){
					return;
				}
				_self._Go2(jump2.val());
			});
		},
		_GetPaginationHtml : function(){
			var _self = this;
			
			//如果当前页不是第一页则显示上一页的链接
			_self.current > 1 ? _self._style = 'visible' :	_self._style = 'hidden';
				
			_self._Template += '<a class="Y-page-prev" href="javascript:void(0);" data-pager="' + (_self.current - 1) + '" style="visibility: ' + _self._style + ';">&laquo; 上一页</a>';
			
			//当前页超出最大允许页 显示前面的更多按钮
			if(_self.current - _self._halfMaxPage > 1){
				_self._Template += '<a href="javascript:void(0);" data-pager="1">1</a>';
				_self._Template += '<span class="Y-page-break">...</span>';
			}
			_self._Template += _self._GetPagerHtml();
			
			//当所有页数超出最多允许显示的页数时显示更多按钮
			if(_self.current + _self._halfMaxPage < _self._PageCount){
				_self._Template += '<span class="Y-page-break">...</span>';
				_self._Template += '<a href="javascript:void(0);" data-pager="' + _self._PageCount + '">' + _self._PageCount + '</a>';
			}
			
			//如果当前页不是最后页则显示下一页的链接
			_self.current < _self._PageCount ? _self._style = 'visible' :	_self._style = 'hidden';
			_self._Template += '<a class="Y-page-next" href="javascript:void(0);" data-pager="' + (_self.current + 1) + '" style="visibility: ' + _self._style + ';">下一页 &raquo;</a>';
		},
		_GetPagerHtml : function(){
			var _self = this;
			//当前项超出显示列表中的一半
			if(_self.current >_self._maxPageIndex - _self._halfMaxPage){			
				//设置最大的页面值
				_self._maxPageIndex = _self._halfMaxPage + _self.current;	
				
				_self._StartIndex = _self.current - _self._halfMaxPage;
				
				if(_self._maxPageIndex > _self._PageCount){
					//计算超出多少个
					_self._gtNum = _self._maxPageIndex - _self._PageCount;
					_self._maxPageIndex = _self._PageCount;
					
					_self._StartIndex -= _self._gtNum;
				}
			}else{
				_self._maxPageIndex = _self.current + _self._halfMaxPage;
				if(_self._maxPageIndex < _self.maxPage){
					_self._maxPageIndex = _self.maxPage;
				}
				_self._StartIndex = _self.current - _self._halfMaxPage;
			}
						
			var pagerHtml = '';
						
			//设置当 前页码的范围
			if (_self._StartIndex < 1) {
				_self._StartIndex = 1;
			}else if(_self._StartIndex > _self._PageCount){
				_self._StartIndex = _self._PageCount;
			}
			
			for(var i=_self._StartIndex; i<= _self._maxPageIndex ; i++){
				if (i == _self.current) {
					pagerHtml += '<span class="Y-page-cur">' + i + '</span>';
				}
				else {
					pagerHtml += '<a href="javascript:void(0);" data-pager="' + i + '">' + i + '</a>';
				}
			}
			
			return pagerHtml;
		}
	});
        Simple.bridgeTojQuery("pagination,simplePagination", Simple.Pagination);
})();
