/**
 * Y.resize.js
 * 让一个元素可以重设尺寸
 * @author Sunny xing
 * @date 2011-07-01
 * @version 0.2
 */
;(function(){
	Simple.declare("Resize",null,{
		node:null,
		direction:["n","ne","e","se","s","sw","w","nw"],
		maxWidth:null,
		minWidth:null,
		minHeight:null,
		maxHeight:null,
		onresizestart:function(){
			
		},
		onresize:function(){
			
		},
		onresizestop:function(){
			
		},
		init:function(){
			if(this.node){
				console.log(this)
				var node=$(this.node),position=node.css("position");
				if(position=="static"){
					node.css({
						"position":"relative",
						top:0,
						left:0
					});
				}
				this._createHandle(this.node);
				this._triggerEvent();
			}
		},
		destroy:function(){
			$(this.node).find(".simple-resize").remove();
		},
		_triggerEvent:function(){
			var self=this;
			$(".simple-resize",this.node).each(function(){
				var type=$(this).attr("data-event");
				$(this).mousedown(function(e){
					e.preventDefault();
					$(this).trigger("resize/"+type,[e,self.node]);
					return false;
				});
			});
		},
		_createHandle:function(node){
			var self=this;
			if(this.direction){
				$.each(this.direction,function(i,item){
					var divHandle=$('<div/>').addClass("simple-resize simple-resize-"+item).attr("data-event",item);
					divHandle.bind("resize/"+item,function(e,event,node){
						self._doMouseDown.apply(self,[event,node,item]);
					});
					$(node).append(divHandle);
				});
			}
		},
		_doMouseDown:function(e,node,item){
			var self=this;
			this.lastX=e.pageX;
			this.lastY=e.pageY;
			this.nodeWidth=$(node).width();
			this.nodeHeight=$(node).height();
			this.top=(this.getOffset(node)).top;
			this.left=(this.getOffset(node)).left;
			$(document).mousemove(function(e){
				self._doMouseMove.apply(self,[e,node,item]);
			});
			$(document).mouseup(function(e){
				self._doMouseUp.apply(self,[e,node,item]);
			});
			return false;
		},
		_doMouseMove:function(e,node,item){
			if($(".draggable-iframeFix")[0]){
				$(".draggable-iframeFix").show();
			}else{
				 var iframeFixDiv = $("<div/>").css({
                        width: "100%",
                        height: "100%",
                        position: "absolute",
                        opacity: 0,
                        zIndex: 10000,
                        top: 0,
                        left: 0
                    }).addClass("draggable-iframeFix");
                 $(document.body).append(iframeFixDiv);
			}
			var x=e.pageX,y=e.pageY
			changeX=x-this.lastX,changeY=y-this.lastY
			switch(item){
				case "n":
				$(node).css({
					top:this.top+changeY,
					height:this.nodeHeight-changeY
				});
				break;
				case "e":
				$(node).css({
					width:this.nodeWidth+changeX
				});
				break;
				case "s":
				$(node).css({
					height:this.nodeHeight+changeY
				});
				break;
				case "w":
				$(node).css({
					left:this.left+changeX,
					width:this.nodeWidth-changeX
				});
				break;
				case "ne":
				$(node).css({
					top:this.top+changeY,
					height:this.nodeHeight-changeY,
					width:this.nodeWidth+changeX
				});
				break;
				case "se":
				$(node).css({
					height:this.nodeHeight+changeY,
					width:this.nodeWidth+changeX
				});
				break;
				case "sw":
				$(node).css({
					height:this.nodeHeight+changeY,
					left:this.left+changeX,
					width:this.nodeWidth-changeX
				});
				break;
				case "nw":
				$(node).css({
					top:this.top+changeY,
					height:this.nodeHeight-changeY,
					left:this.left+changeX,
					width:this.nodeWidth-changeX
				});
				break;
			}
		},
		_doMouseUp:function(){
			$(document).unbind("mousemove").unbind("mouseup");
			$(".draggable-iframeFix").hide();
		},
		 //获取正确的left和top值
        getOffset: function(el){
            var left = parseInt($(el).css("left")), top = parseInt($(el).css("top")), offset = $(el).offset(), elPos = $(el).css("position"), parent = $(el).parent();
            if (!(isNaN(left) || isNaN(top))) {
                return {
                    left: left,
                    top: top
                }
            }
            else {
                if (elPos == "absolute") {
                    while (parent.css("position") != "relative" && parent != document.body) {
                        parent = parent.parent();
                    }
                    var parentOffset = parent.offset();
					return{
						left:offset.left-parentOffset.left,
						top:offset.top-parentOffset.top
					}
                }else if(elPos == "static"){
					$(el).css({
                    "position": "relative",
                    "top": 0,
                    "left": 0
                	});
					return {
						left:0,
						top:0
					}
				}else{
					//do sth;
					//待修正BUG
					var relativeLeft=0,relativeTop=0;
					if(!isNaN(parseInt($(el).css("right")))){
						relativeLeft=-(parseInt($(el).css("right")));
					}
					if(!isNaN(parseInt($(el).css("bottom")))){
						relativeTop=-(parseInt($(el).css("bottom")));
					}
					return {
						left:relativeLeft,
						top:relativeTop
					}
				}
            }
        }
	});
	Simple.bridgeTojQuery("simpleResize",Simple.Resize);
})();
