/**
 * @author Sunny xing
 */
(function(){
    Simple.declare("Selectable", null,{
        //触发选中元素的父级节点
        node: null,
        //node元素中的子集节点，会被选中,应该是一个jQuery选择器
        selectNode: null,
        //选中的元素加上的类，以表明该元素被选中了
        selectCls: "y-selectable",
        //延迟触发selectable事件
        delay: 3,
        //选择开始时触发的事件
        onselectstart: function(){
        
        },
        //选择结束时触发的事件
        onselectend: function(e,hasSelectNode){
        
        },
        init: function(){
            var self = this;
            $(this.node).mousedown(function(e){
                self._mouseDown.apply(self, [e]);
            });
        },
        //鼠标按下
        _mouseDown: function(e){
            var self = this;
			self.onselectstart.apply(self.node, [e]);
            //create div to show select area
            //this._createSelectArea();
            this.lastX = e.pageX;
            this.lastY = e.pageY;
			this.hasNodeSelected = [];
            $(document).mousemove(function(e){
                self._mouseMove.apply(self, [e]);
            });
            $(document).mouseup(function(e){
                self._mouseUp.apply(self, [e]);
            });
        },
        _mouseMove: function(e){
            var pageX = e.pageX, pageY = e.pageY, addX = Math.abs(pageX - this.lastX), addY = Math.abs(pageY - this.lastY), self = this, selector;
            this._noSelect(document.body, true);
            if (addX > this.delay && addY > this.delay) {
                if (!this.selectProxy) {
                    this._createSelectArea(this.lastX, this.lastY);
                }
                //更新选择范围的DIV的大小
                this.selectProxy.width(addX).height(addY);
                //当改变的值为负值时，更新选中区域的left和top值
                if (pageX - this.lastX < 0) {
                    this.selectProxy.css("left", e.pageX);
                }
                if (pageY - this.lastY < 0) {
                    this.selectProxy.css("top", e.pageY);
                }
                //判断是否与Node节点下的selectNode相交
                if (this.selectNode) {
                    selector = this.selectNode;
                }
                else {
                    selector = "*";
                }
                $(this.node).find(selector).each(function(){
                    //是否相交
                    if (self._isIntersect(this, self.selectProxy[0])) {
						if($(this).attr("y-selected")==1){
							//
						}else{
							self.hasNodeSelected.push(this);
							$(this).addClass(self.selectCls).attr("y-selected",1);
						}
                    }
                    else {
                        $(this).removeClass(self.selectCls).attr("y-selected",0);
                    }
                });
                this.selectstart = true;
            }
        },
        _mouseUp: function(e){
            if (this.selectstart) {
                var self = this;
                //移除创建的div
                if (this.selectProxy) {
                    this.selectProxy.remove();
                }
                //触发选择结束事件
				self.onselectend.apply(self.node, [e, self.hasNodeSelected]);
                this._noSelect(document.body, false);
                this.selectProxy = null;
                this.selectstart = false;
            }
            //解除事件绑定
            $(document).unbind("mousemove").unbind("mouseup");
        },
		_getSelectedNode:function(){
			return this.hasNodeSelected;
		},
        //创建一个DIV来显示选择的范围
        _createSelectArea: function(x, y){
            this.selectProxy = $("<div/>").addClass("simple-selectable-proxy");
            this.selectProxy.css({
                left: x,
                top: y
            });
            this.selectProxy.appendTo(document.body);
        },
        _isIntersect: function(nodeA, nodeB){
            var nodeAOffset = $(nodeA).offset(), nodeBOffset = $(nodeB).offset(), nodeAWidth = $(nodeA).width(), nodeAHeight = $(nodeA).height(), nodeBWidth = $(nodeB).width(), nodeBHeight = $(nodeB).height();
            //不相交的情况
            //A top> B bottom
            //A bottom < B top
            //A right < B left
            //A left >B right
            if (nodeAOffset.top > nodeBOffset.top + nodeBHeight ||
            nodeAOffset.top + nodeAHeight < nodeBOffset.top ||
            nodeAOffset.left + nodeAWidth < nodeBOffset.left ||
            nodeAOffset.left > nodeBOffset.left + nodeBWidth) {
                return false;
            }
            else {
                return true;
            }
        },
        _noSelect: function(target, bool){
        
            if (typeof target.onselectstart != "undefined") //IE route
                target.onselectstart = function(){
                    return false
                }
            else 
                if (typeof target.style.MozUserSelect != "undefined") //Firefox route
                    target.style.MozUserSelect = "none"
                else //All other route (ie: Opera)
                     target.onmousedown = function(){
                        return false
                    }
        }
    });
    Simple.bridgeTojQuery("selectable",Simple.Selectable);
})();
