/**
 * author:半盏凉茶
 * date:2011-10-27
 */
(function(){
    Simple.declare('Slider', null, {
        node : null,
        trigger : true, //传入一个对象或者true   为true则自动生成trigger
        triggerClass : '', //trigger样式
        triggerCurrentClass : '', //trigger current 样式
        content : null, //对应显示的content
        isAuto : true, //是否自动切换
        delay : 0, //操作延时
        speed : 300, //移动速度
        timeout : 3000, //间歇时间
        setup : 1,//每次滚动多少个
        next : null,//下一个
        prev : null,//上一个
        defaultShow : 1, //默认显示第n个
        direction : 'left',//移动方向 仅支持left,top,none
        template : '<ol simpleEvent="trigger"><s:each><li>{0}</li></s:each></ol>',//模版
        bindEvent : 'mouseover',//绑定事件
        ontrigger : null,//移动图片后触发的事件
        ontriggered : null,
        init : function(){
            var s = this;
            s.node = $(s.node);
            s.content = s.node.find(s.content);
						
            s._ = {//内部参数
                current : 0, //当前第n项
                timer : null,//计时器
                autoTimer : null,//自动定时器
                length : 0, //总共有多少项
                width : null, //宽度
                height : null, //高度
                contentParent : null 
            }
			
            s.setDefault();
            s.auto(s);
            s.change(s.defaultShow - 1);
        },
        setDefault: function(){//数据初始化及事件绑定
            var s = this, css;
          
            //初始化轮换内容数量
            s._.length = s.content.length;
          
            //初始化宽高
            s._.width = s.width | s.content.width();
            s._.height = s.height | s.content.height();
          
            s._.contentParent = s.content.parent();          
		  
            css = {
                'position':'relative'
            }; 
		  
            //滚动方向
            if(s.direction == 'left'){
                s._.distance = s._.width;
                s.direction = 'left';
                s.content.css('float','left');
                css['width'] = (s._.width * s._.length) + 'px';
            }else if(s.direction == 'top'){
                s._.distance = s._.height;
                css['height'] = (s._.height * s._.length) + 'px';
            }else{
                
            }
		  
            s._.contentParent.css(css);
          
            if(typeof s.trigger == 'string'){
                s.trigger = $(s.trigger, s.node);
            }
            else if(typeof s.trigger == 'boolean' && s.trigger){
                s._.ts = s.template.indexOf('<s:each>') + '<s:each>'.length;
                s._.te = s.template.lastIndexOf('</s:each>');
                s._.teach = s.template.substring(s._.ts, s._.te);//取出循环部分
                s._.teachHTML = '';
                for(var i=1; i<=s._.length; i++){
                    s._.teachHTML += s._.teach.replace('{0}', i);
                }
              
                s.template = s.template.replace(/<s:each>.*<\/s:each>/, s._.teachHTML);
                s.node.append(s.template);
              
                s._.triggerParent = s.node.find('[simpleEvent=trigger]');
                s._.triggerParent.addClass(s.triggerClass);
              
                s.trigger = s._.triggerParent.children();
            }
          
            s.trigger.eq(s.defaultShow - 1).addClass(s.triggerCurrentClass);
            
            if(s.direction == "left" || s.direction == "top"){
                if(!s.next){
                    s.next = '<span simpleEvent="next">next</span>';
                    s.node.append(s.next);
                    s.next = s.node.find('[simpleEvent=next]');
                }
                else if(typeof s.next == 'string'){
                    s.next = s.node.find(s.next);
                }

                if(!s.prev){
                    s.prev = '<span simpleEvent="prev">prev</span>';
                    s.node.append(s.prev);
                    s.prev = s.node.find('[simpleEvent=prev]');
                }
                else if(typeof s.prev == 'string'){
                    s.prev = s.node.find(s.prev);
                }
            }
          
            s._bindEvent(s);
        },
        _bindEvent : function(s){
            s.trigger.each(function(){
                var el = $(this);
                el.bind(s.bindEvent, function(){
                    clearInterval(s._.autoTimer);
                    clearTimeout(s._.timer);
                    s._.timer = setTimeout(function(){
                        s.change(el.index());
                    }, s.delay);
                });
                
                el.bind("mouseleave", function(){
                    clearTimeout(s._.timer);
                    s.auto(s);
                });
            });

            if(s.next){
                s.next.click(function(){
                     if(s._.current + 1 >= s._.length){
                            s.change(0);
                    }else{
                        s.change(s._.current + 1);
                    }  
                });
            }
            
            if(s.prev){
                s.prev.click(function(){
                    if(s._.current - 1 < 0){
                        s.change(s._.length - 1);
                    }else{
                        s.change(s._.current - 1);
                    }
                });
            }
        },
        //变更显示对象
        change : function(index){
            var s = this,t = [];
			
            if(s.ontrigger){
                s.ontrigger(index);
            }
			            
            s._.current = index;
            
            if(s.direction == 'top' || s.direction == 'left'){
                t[s.direction] = -(index * s._.distance) + 'px';
                s._.contentParent.stop().animate(t, s.speed);
            }else{
                s.content.eq(index).show().siblings().hide();
            }
            
            s.trigger.eq(index).addClass(s.triggerCurrentClass).siblings().removeClass(s.triggerCurrentClass);
            
            if(s.ontriggered){
                s.ontriggered(index);
            }
        },
        auto : function(s){
            if(s.isAuto){
                clearInterval(s._.autoTimer);
                s._.autoTimer = setInterval(function(){
                    if(s._.current + 1 >= s._.length){
                            s.change(0);
                    }else{
                        s.change(s._.current + 1);
                    }
                }, s.timeout);
            }
        }
    });
    
    Simple.bridgeTojQuery("slider,simpleSlider", Simple.Slider);
})();