/**
 * author:半盏凉茶
 * date:2011-06-30
 */
 
//选项卡
(function(){
    Simple.declare("ts.Tab",null, {
		node: null,
		delay: 300, //延时(毫秒为单位)
		defaultShow: 1, //默认显示哪个选项卡
		tabList: '',//选项卡菜单
		tabListCurrentClass: 'current',//选项卡菜单当前项的样式
		tabContent: '',//选项卡内容
		bindEvent: 'mouseover click',//绑定触发的事件
		loadClass:'loading',
		init: function(o){
			var _self = this,
				_tabList = $(this.tabList, this.node),
				_tabListChild = $('*',_tabList),
				_tabContent = $(this.tabContent, this.node);
			
			/* 用户可以为tabList 和 tabContent 自定义编号，未定义的时候代码自动为其编号 */
			$.each(_tabList, function(){
				var t = $(this);

				if(!t.attr('data-item')){
					t.attr('data-item', 'Y-tab-' + (t.index()  + 1))
				}
			});
			
			$.each(_tabContent, function(){
				var t = $(this);

				if(!t.attr('data-item')){
					t.attr('data-item', 'Y-tab-' + (t.index()  + 1))
				}
			});
			
			/* 切换 Tab 代码 */
			_self._Change = function(t, c){
				//如果触发的是当前项则不做改变
				if (!t.hasClass(_self.tabListCurrentClass)) {
					/* 选项卡菜单样式修改 及 内容的显示与隐藏 */
					_tabList.removeClass(_self.tabListCurrentClass);
					t.addClass(_self.tabListCurrentClass);
					_tabContent.hide();
					c.show();
					var iframe = $('iframe', c);
					if (iframe[0] && !iframe.attr('src')) {
						if (_self.loadClass) {
							c.addClass(_self.loadClass);
						}
						
						var src = iframe.attr('data-src');
						iframe.attr('src', src);
						iframe.one('load', function(){
							c.removeClass(_self.loadClass);
						})
					}
				}
			}

			//获取默认的显示的项
			var defaultTabList = $(_self.tabList + '[data-item=Y-tab-' + _self.defaultShow + ']', _self.node);
			var defaultTabContent = $(_self.tabContent + '[data-item=Y-tab-' + _self.defaultShow + ']', _self.node);
			_self._Change(defaultTabList, defaultTabContent);
			
			//_tabListChild.bind(_self.bindEvent, function(){return false;});
			_tabList.bind(_self.bindEvent,function(){
				_self._t = this;
				//如果设置了延时时间开启延时
				if(_self.delay > 0){
					//清除之前的所有延时
					if(_self.timer){ clearTimeout(_self.timer); } 
					
					_self.timer = setTimeout(function(){
						_self._t = $(_self._t);
						var item = _self._t.attr('data-item');
						var c = $(_self.tabContent + '[data-item='  + item + ']', _self.node);
						_self._Change(_self._t,c);
					}, _self.delay);
				}else{
					_self._t = $(_self._t);
					var item = _self._t.attr('data-item');
					var c = $(_self.tabContent + '[data-item='  + item + ']',_self.node);
					_self._Change(_self._t,c);
				}
			});
		}
	});
})();

Simple.bridgeTojQuery("tab,simpleTab", Simple.ts.Tab);