/**
 * @fileoverview 该组件是SimpleUI下面的子项目，autoComplete,自动完成组件
 * @author 蓝面小生
 * @version 0.3
 */
(function(){
	/**
	 * 判断按键的类型
	 * @namespace keyCode
	 */
    Simple.namespace("keyCode");
    Simple.mixin(Simple.keyCode, {
        ENTER: function(e){
            return e.keyCode == 13;
        },
        ESC: function(e){
            return e.keyCode == 27;
        },
        DOWN: function(e){
            return e.keyCode == 40;
        },
        UP: function(e){
            return e.keyCode == 38;
        },
        DEL: function(e){
            return e.keyCode == 46;
        },
        PAGELEFT: function(e){
        
        },
        PAGERIGHT: function(e){
        
        },
        SHIFT: function(e){
            return e.keyCode == 16;
        },
        CTRL: function(e){
            return e.keyCode == 17;
        },
        ALT: function(e){
            return e.keyCode == 18;
        },
        BACKSPACE: function(e){
            return e.keyCode == 8;
        }
    });
    /**
     * 声明一个AutoComplete构造函数
     * @class AutoComplete 
     * @return new AutoComplete instances
     */
    Simple.declare("AutoComplete", null, {
        //触发自动完成的节点
        node: null,
        source: null,
        format: null,
        delay: 0,
		isResult:function(data){
			return data.length;
		},
		dealData:function(data){
			return data;
		},
        onchange: function(value, data){
        
        },
        onselect: function(value, data){
        
        },
        init: function(){
            var self = this;
            this.cacheData = {};
            this.currentData = [];
            this.lastKeyPress = null;
            this.lastSelectedValue = null;
            this.active = false;//当有自动完成的值时
            this.local = $.isArray(this.source);
            //是否已经激活了自动提示
            this.node = $(this.node);
            //bind event
            this.node.bind("autocomplete/keydownEvent", function(e, event){
                self._keydownEvent.apply(self, [event]);
            }).bind("autocomplete/blurEvent", function(){
                self._blurEvent.apply(self);
            }).attr("autocomplete", "off");
            //trigger event
            this.node.keyup(function(e){
                self.node.trigger("autocomplete/keydownEvent", [e]);
            }).blur(function(e){
                self.node.trigger("autocomplete/blurEvent");
            });
        },
        destroy: function(){
            this.node.unbind("autocomplete/keydownEvent").unbind("autocomplete/blurEvent").removeAttr("autocomplete");
        },
        _keydownEvent: function(e){
            var self = this;
            self.lastKeyPress = e.keyCode;
            switch (self.lastKeyPress) {
                case 38:
                    //up
                    e.preventDefault();
                    if (self.active) {
                        self.focusPrev();
                    }
                    else {
                    
                    }
                    break;
                case 40:
                    e.preventDefault();
                    if (self.active) {
                        self.focusNext();
                    }
                    else {
                        self.activeAutoComplete();
                    }
                    break;
                case 9:
                case 13:
                    e.preventDefault();
                    if (self.active) {
                        self.selectCurrent();
                        return false;
                    }
                    break;
                case 27:
                    //esc
                    e.preventDefault();
                    if (self.active) {
                        self.finish();
                    }
                    break;
                default:
                    self.activeAutoComplete();
            }
        },
        _blurEvent: function(){
            if (!this._mouseInSelect) {
                this.finish();
            }
        },
        activeAutoComplete: function(){
            var self = this;
            if (self.timeOutActive) {
                clearTimeout(self.timeOutActive);
            }
            if (self.delay && !self.local) {
                self.timeOutActive = setTimeout(function(){
                    self.activeNow();
                }, self.delay);
            }
            else {
                self.activeNow();
            }
        },
        activeNow: function(){
            var value = $.trim(this.node.val());
            if (value.length < 1) {
                this.finish();
				 this.lastProcessValue=null;
                return;
            }
            if (value != this.lastSelectedValue) {
                //this.active = true;
                this.lastProcessValue = value;
                this.getData(value);
            }
        },
        finish: function(){
            this.active = false;
            this.menuContainer && this.menuContainer.hide();
        },
        getData: function(value){
            var self = this;
            if (this.local) {
                //有数据
                if (this.source.length) {
                    //过滤数据
                    this.currentData = this.filterData(this.source, value);
                    self.parseData(self.currentData);
                }
            }
            else {
                var data = this.getCache(value);
                if (data && data.length) {
                    self.currentData = data;
                    self.parseData(self.currentData);
                }
                else {
                    if (typeof this.source == "string") {
                        var sendData = {}, name = this.node.attr("name");
                        sendData[name] = this.lastProcessValue;
                        $.ajax({
                            url: this.source,
                            data: sendData,
                            dataType: "json",
                            success: function(r){
                                self.currentData = r;
                                self.setCache(value, r);
                                self.parseData(self.currentData)
                            }
                        });
                    }
                    else 
                        if (typeof this.source == "function") {
                            this.source(this.lastProcessValue, function(data){
                                self.currentData = data;
                                self.setCache(value, data);
                                self.parseData(self.currentData);
                            });
                        }
                }
            }
        },
        filterData: function(data, val){
            var newArr = [];
            $.each(data, function(i, n){
                var reg = new RegExp(val, "gi");
                if (n.label) {
                    if (reg.test(n.label) || reg.test(n.value)) {
                        newArr.push(n);
                    }
                }
                else {
                    if (reg.test(n)) {
                        newArr.push(n);
                    }
                }
            });
            return newArr;
        },
        parseData: function(data){
            //var data = this.currentData;
			if(this.isResult(data)){
                this.active = true;
                this.createDom();
				var data=this.dealData(data)
                this.renderMenu(data, this.lastProcessValue);
                this.position();
            }
            else {
                this.finish();
            }
        },
        createDom: function(){
            var self = this;
            if (this.menuContainer) {
                return;
            }
            else {
                var div = $("<div/>").addClass("simple-autocomplete-container").append("<div class='simple-autocomplete-bg'></div>"), ul = $("<ul/>");
                this.menuContainer = div;
                this.menuContainer.append(ul);
                this.menuContainer.appendTo(document.body);
                ul.delegate("li", "mouseover", function(){
                    $(this).addClass("simple-autocomplete-select").siblings().removeClass("simple-autocomplete-select");
                    self._mouseInSelect = true;
                }).delegate("li", "mouseout", function(){
                    self._mouseInSelect = false;
                }).delegate("li", "click", function(){
                    self.node.val($(this).data("value"));
                    self._mouseInSelect = false;
                    self.finish();
                })
            }
        },
        renderMenu: function(data, value){
            var self = this, ul = self.menuContainer.find("ul");
            ul.empty();
            $.each(data, function(i, item){
                if (!self.format) {
                    if (item.label) {
                        var li = $("<li/>"), label = item.label.replace(value, "<b class='orange'>" + value + "</b>");
                        li.data("value", item.value), li.html(label);
                    }
                    else {
                        var li = $("<li/>").data("value", item);
                        item = item.replace(value, "<b class='orange'>" + value + "</b>");
                        li.html(item);
                    }
                }
                else {
                    //TODO:需要修正格式化函数以适应不同的数据源
                    var li = self.format(value, item);
                }
                ul.append(li);
            });
            this.menuContainer.show();
        },
        position: function(){
            this.menuContainer.css("position", "absolute");
            var offset = this.node.offset(), height = this.node.outerHeight(), width = this.node.width();
            this.menuContainer.css({
                top: offset.top + height + 2,
                left: offset.left,
                width: width
            });
        },
        //读取缓存
        getCache: function(value){
            return this.cacheData[value];
        },
        setCache: function(value, data){
            if (this.cacheData.length && this.cacheData.length > 10) {
                this.cacheData = {};
                this.cacheData.length = 0;
            }
            this.cacheData[value] = data;
            this.cacheData.length++;
        },
        //移动选中
        focus: function(index){
            var items = $("li", this.menuContainer), self = this, hasSelect = false;
            if (items.length) {
                for (var i = 0; i < items.length; i++) {
                    if (items.eq(i).hasClass("simple-autocomplete-select")) {
                        self.selectItem(i + index);
                        hasSelect = true;
                        return;
                    }
                }
                if (!hasSelect) {
                    this.selectItem(0);
                }
            }
        },
        focusNext: function(){
            this.focus(1);
        },
        focusPrev: function(){
            this.focus(-1);
        },
        selectItem: function(index){
            var items = $("li", this.menuContainer);
            index = index < 0 ? items.length - 1 : index;
            index = index == items.length ? 0 : index;
            items.removeClass("simple-autocomplete-select");
            items.eq(index).addClass("simple-autocomplete-select");
            var val = $('li.simple-autocomplete-select',this.menuContainer).data("value");
            this.node.val(val);
            if (this.lastSelectedValue && !this.lastSelectedValue != val) {
                this.onchange(val);
            }
            this.lastSelectedValue = val;
            //this.onselect(val);
        },
        selectCurrent: function(){
			var val=$('li.simple-autocomplete-select',this.menuContainer).data("value");
            this.node.val(val);
            this.lastSelectValue = val;
			this.onselect(val);
			this.finish();
        }
    });
    
    Simple.bridgeTojQuery("autocomplete", Simple.AutoComplete);
})();
/**
 * @author 蓝面小生
 * simpleUI子项目
 * simpleDialog 2.3
 */
(function(){
    Simple.declare("dialog.Modal", null, {
        color: "#000",
        opacity: 0.5,
        node: null,
        selectFix: false,
        init: function(){
            var s = this;
            if (s.node) {
                s._appendModal();
				$(window).bind("resize:modal",function(){
					s._appendModal();
				})
                $(window).resize(function(){
                    $(this).trigger("resize:modal");
                });
            }
        },
        _appendModal: function(){
            var s = this, docSize = Simple.getDoc(), overlayHandle, overlayMark, node = s.node, width, height, left, top, offset, position;
            if ($(".simple-modal")[0]) {
                overlayHandle = $(".simple-modal").show();
                overlayMark = overlayHandle.find(".simple-mark");
            }
            else {
                overlayHandle = $("<div/>").addClass("simple-modal");
                overlayMark = $("<div/>").addClass("simple-mark");
                overlayHandle.append(overlayMark).appendTo(document.body);
            }
            if (s.selectFix) {
                if (!overlayHandle.find("iframe")[0]) {
                    overlayHandle.append('<iframe src="javascript:;" class="simple-selectFix" frameBorder="0">');
                }
            }
            if (node == document.body) {
                width = "100%";
                height = "100%";
                left = 0;
                top = 0;
                position = "fixed";
                if (Simple.isIE6) {
                    height = docSize.h;
                    position = "absolute";
                }
            }
            else {
                offset = $(node).offset();
                width = $(node).outerWidth();
                height = $(node).outerHeight();
                left = offset.left;
                top = offset.top;
                position = "absolute";
            }
            overlayMark.css({
                background: s.color,
                opacity: s.opacity
            });
            overlayHandle.css({
                width: width,
                height: height,
                position: position,
                top: top,
                left: left,
                zIndex: 999
            })
            s.overlayHandle = overlayHandle;
            s.overlayMark = overlayMark;
        },
        destroy: function(){
            this.overlayHandle.hide();
			$(window).unbind("resize:modal");
        }
    });
    Simple.bridgeTojQuery("modal,simpleModal", Simple.dialog.Modal);
    
    Simple.mixin(Simple, {
        getDoc: function(){
            return {
                h: Math.max(document.documentElement.scrollHeight, document.documentElement.clientHeight),
                w: Math.max(document.documentElement.scrollWidth, document.documentElement.clientWidth)
            }
        },
        getClient: function(){
            return {
                h: document.documentElement.clientHeight,
                w: document.documentElement.clientWidth
            }
        },
        getSize: function(el, isModal){
            if (!(el instanceof jQuery)) {
                el = $(el);
            }
            if (el.is("body")) {
                if (isModal) {
                    return this.getDoc();
                }
                else {
                    return this.getClient();
                }
            }
            else {
                return {
                    h: el.outerHeight(),
                    w: el.outerWidth()
                }
            }
        }
    });
    Simple.position = {
        at: function(node, referNode, points){
            node = $(node);
            if (node.css("position") == "static") {
                node.css("position", "absolute");
            }
            var rfOffset = $(referNode).offset(), w = node.outerWidth(), h = node.outerHeight(), t, l, rfw = Simple.getSize(referNode).w, rfh = Simple.getSize(referNode).h;
            if (typeof points == "string") {
                switch (points) {
                    case "cc":
                        t = rfOffset.top + (rfh - h) / 2;
                        l = rfOffset.left + (rfw - w) / 2;
                        break;
                    case "rc":
                        t = rfOffset.top + (rfh - h) / 2;
                        l = rfOffset.left + rfw;
                        break;
                    case "bc":
                        t = rfOffset.top + rfh;
                        l = rfOffset.left + (rfw - w) / 2;
                        break;
                    case "lc":
                        t = rfOffset.top + (rfh - h) / 2;
                        l = rfOffset.left - w;
                        break;
                    case "tc":
                        t = rfOffset.top - h;
                        l = rfOffset.left + (rfw - w) / 2;
                        break;
                }
            }
            node.css({
                top: t,
                left: l
            });
        },
        atBody: function(node){
            var node = $(node), pos = node.css("position"), doc = Simple.getSize(document.body);
            if (pos == "fixed") {
                node.css({
                    top: (doc.h - node.height()) / 2,
                    left: (doc.w - node.width()) / 2
                });
            }
            else 
                if (pos == "absolute") {
                    node.css({
                        top: (doc.h - node.height()) / 2 + Math.max(document.documentElement.scrollTop, document.body.scrollTop),
                        left: (doc.w - node.width()) / 2
                    });
                }
        }
    }
    
    Simple.declare("dialog.Base", null, {
        node: null,
        title: "SimpleDialog",
        modal: true,
        position: "",
        ajax: "",
        loadingMessage: "加载中...",
        url: "",
        iframe: false,
        buttons: false,
        handleTool: ["close"],
        maxContainer: "body",
        width: "",
        height: "",
        data: "",
        color: "#000",
        opacity: 0.5,
        selectFix: true,
        onmin: $.noop,
        onmax: $.noop,
        onload: $.noop,
        onclose: $.noop,
        draggable: true,
        dialogTemplate: '<div class="simple-dialog"><table class="simple-dialog-table">' +
        '<tr class="handle"><td class="simple-dialog-tl"></td><td class="simple-dialog-tc" rel="dialogHead"><h2 class="simple-dialog-title" rel="dialogTitle"></h2></td><td class="simple-dialog-tr"></td></tr>' +
        '<tr><td class="simple-dialog-cl"></td><td class="simple-dialog-cc" ><div class="simple-dialog-content" rel="dialogBody"></div><div rel="dialogFoot"></div></td><td class="simple-dialog-cr"></td></tr>' +
        '<tr><td class="simple-dialog-bl"></td><td class="simple-dialog-bc"></td><td class="simple-dialog-br"></td></tr></table></div>',
        init: function(){
            this.dialog = $(this.dialogTemplate);
            this.head = this.dialog.find("[rel='dialogHead']");
            this.titleContainer = this.dialog.find("[rel='dialogTitle']");
            this.body = this.dialog.find("[rel='dialogBody']");
            this.foot = this.dialog.find("[rel='dialogFoot']");
            this._render();
        },
        destroy: function(){
            this.dialog.remove();
            this.modal.data("widget_modal").destroy();
			this.modal.data("widget_modal",false);
        },
        hide: function(){
            this.dialog.hide();
        },
        _render: function(){
            var s = this, bodyContent;
            if (this.modal) {
                this.modal = $(document.body).modal({
                    color: this.color,
                    opacity: this.opacity,
                    selectFix: this.selectFix
                });
            }
            if (this.node) {
                bodyContent = $(this.node).clone(true);
            }
            else 
                if (this.ajax) {
                    this.dialog.addClass("simple-dialog-ajax");
                    bodyContent = "<div class='simple-dialog-load'>" + this.loadingMessage + "</div>";
                    $.ajax({
                        url: this.url,
                        dataType: "html",
                        data: this.data,
                        success: function(r){
                            s.body.html(r);
                            s.setPosition();
                            s.onload.call(s.dialog);
                        },
                        error: function(){
                        
                        }
                    });
                }
                else 
                    if (this.iframe) {
                        this.dialog.addClass("simple-dialog-iframe");
                        bodyContent = '<div class="simple-dialog-load">' + this.loadingMessage + '</div><iframe class="simple-content-iframe" src="' + this.url + '" frameBorder="0" name="SimpleDialogFrame" style="display:none"></iframe>';
                    }
            this.body.html(bodyContent);
            this.titleContainer.html(this.title);
            this.setHandleTool();
            this.drawBtns();
            this.node = this.dialog;
            this.dialog.appendTo(document.body);
            if (this.iframe) {
                window["SimpleDialogFrame"].onload = function(){
                    s.body.find(".simple-dialog-load").remove();
                    s.body.find("iframe").fadeIn();
                    s.setPosition();
                }
            }
            this.dialog.width(this.width).height(this.height);
            this.setPosition();
            if (this.draggable) {
                this.dialog.drag({
                    handle: "[rel='dialogHead']"
                });
            }
        },
        setHandleTool: function(){
            var s = this;
            $.each(this.handleTool, function(i, n){
                var tool = $("<a/>").addClass("simple-dialog-" + n).attr("rel", "dialog" + n).html(n);
                tool.click(s["on" + n]);
                s.head.append(tool);
            });
            //设定关闭事件
            this.head.find("[rel='dialogclose']").click(function(){
                s.onclose.call(s.dialog);
                s.destroy();
            });
            //设定最大化事件
            this.head.find("[rel='dialogmax']").click(function(){
                if (s.dialog.data("max")) {
                    s.dialog.data("max", false);
                    s.dialog.css({
                        top: s.lastTop,
                        left: s.lastLeft,
                        width: s.lastWidth,
                        height: s.lastHeight
                    });
                }
                else {
                    s.lastTop = s.dialog.css("top");
                    s.lastLeft = s.dialog.css("left");
                    s.lastWidth = s.dialog.width();
                    s.lastHeight = s.dialog.height();
                    s.setSize();
                    s.dialog.data("max", true);
                }
            });
            //设定最小化事件
            this.head.find("[rel='dialogmin']").click(function(){
                s.onmin.call(s.dialog);
            });
        },
        setPosition: function(){
            if (this.position) {
                if (typeof this.position == "string") {
                    Simple.position.at(this.dialog, this.position, "cc");
                }
                else {
                    this.dialog.css({
                        top: this.position[1],
                        left: this.position[0]
                    });
                }
            }
            else {
                Simple.position.atBody(this.dialog);
            }
        },
        setHead: function(html){
            this.head.html(html);
        },
        setBody: function(html){
            this.body.html(html);
        },
        setFoot: function(html){
            this.foot.html(html);
        },
        setSize: function(){
            var maxCon = $(this.maxContainer), offset = maxCon.offset(), width = maxCon.width();
            height = maxCon.height();
            if (maxCon.is("body")) {
                height = $(window).height();
            }
            this.dialog.css(offset);
            this.dialog.width(width).height(height);
        },
        drawBtns: function(){
            var s = this,divWrap=$("<div>").addClass("simple-dialog-btn-wrap");
            if (this.buttons) {
                if (this.buttons instanceof Array) {
                    $.each(s.buttons, function(index, item){
                        var divBtn = $("<a/>").addClass("simple-btn").append("<span class='simple-btn-text'><i></i>" + item.text + "</span>");
                        if (item.cls) {
                            divBtn.addClass(item.cls);
                        }
                        if (item.ico) {
                            divBtn.find("i").addClass(item.ico);
                        }
                        if (item.event) {
                            item.click(item.event);
                        }
						divWrap.append(divBtn);
                    });
                }
                else {
                    $.each(s.buttons, function(key, value){
                        var divBtn = $("<a/>").addClass("simple-btn-blue simple-btn").append("<span class='simple-btn-text'>" + key + "</span>");
                        if (typeof value == "function") {
                            divBtn.unbind().bind("click", value);
                        }
                        if (key == "取消") {
                            divBtn.removeClass("simple-btn-blue").addClass("simple-btn-white");
                        }
                       divWrap.append(divBtn);
                    });
                }
				 s.foot.append(divWrap);
            }
        }
    });
    Simple.bridgeTojQuery("dialog,simpleDialog", Simple.dialog.Base);
    //便捷调用
    Simple.ajaxDialog=$.ajaxDialog=function(url,opts){
    	opts=$.extend({},opts,{
    		url:url,
    		ajax:true
    	})
    	return new Simple.dialog.Base(opts)
    }
    Simple.iframeDialog=$.iframeDialog=function(url,opts){
    	opts=$.extend({},opts,{
    		url:url,
    		iframe:true
    	})
    	return new Simple.dialog.Base(opts)
    }
    Simple.alert=$.alert=function(text,callback,opts){
    	opts=$.extend({},opts,{
    		buttons:{
    			"确定":function(){
    				if(typeof callback=="function"){
    					callback();
    				}
    				d.data("widget_dialog").destroy();
    			}
    		}
    	})
    	var d=$("<div class='simple-dialog-alert'>"+text+"</div>").dialog(opts);
    	return d.data("widget_dialog");
    }
    Simple.confirm=$.confirm=function(text,callback,opts){
    	opts=$.extend(opts,{
    		buttons:{
    			"确定":function(){
    				if(typeof callback=="function"){
    					callback();
    				}
    				d.data("widget_dialog").destroy();
    			},
    			"取消":function(){
    				if(typeof opts.oncancel=="function"){
    					opts.oncancel();
    				}
    				d.data("widget_dialog").destroy();
    			}
    		}
    	})
    	var d=$("<div class='simple-dialog-confirm'>"+text+"</div>").dialog(opts);
    	return d.data("widget_dialog");
    }
    //TODO:stack dialog 
    Simple.declare("dialog.Stack", Simple.dialog.Base, {
        init: function(){
        
        },
        destroy: function(){
            this.dialog.hide();
        }
    });
	
})();


/**
 * 使一个元素可以被拖动
 */
(function(){
    Simple.mixin(Simple, {
        getRealPos: function(element){
            var position = element.css("position"), top, left, parentOffset, offset = element.offset(), right, bottom;
            if (position == "static") {
                element.css("position", "relative");
                top = 0;
                left = 0;
            }
            else 
                if (position == "absolute") {
                    var parent = element.parent()
                    while (parent.css("position") == "static" && !parent.is("body")) {
                        parent = parent.parent();
                    }
                    parentOffset = parent.offset();
                    top = offset.top - parentOffset.top;
                    left = offset.left - parentOffset.left;
                }
                else 
                    if (position == "fixed") {
                        top = parseFloat(element.css("top"));
                        left = parseFloat(element.css("left"));
                        if (isNaN(top)) {
                            top = offset.top - Math.max(document.documentElement.scrollTop, document.body.scrollTop);
                        }
                        if (isNaN(left)) {
                            left = offset.left;
                        }
                    }
                    else 
                        if (position == "relative") {
                            top = parseFloat(element.css("top"));
                            left = parseFloat(element.css("left"));
                            right = parseFloat(element.css("right"));
                            bottom = parseFloat(element.css("bottom"));
                            if (isNaN(top)) {
                                if (!isNaN(bottom)) {
                                    top = -bottom
                                }
                                else {
                                    top = 0;
                                }
                            }
                            if (isNaN(left)) {
                                if (!isNaN(right)) {
                                    left = -right
                                }
                                else {
                                    left = 0;
                                }
                            }
                        }
            return {
                left: left,
                top: top
            }
        },
        getCoordinates: function(element){
            var coor = {};
            element = $(element);
            if (element.length < 1) {
                return;
            }
            var offset = element.offset(), right = element.outerWidth() + offset.left, bottom = element.outerHeight() + offset.top;
            Simple.mixin(coor, {
                right: right,
                bottom: bottom
            }, offset);
            return coor;
        },
        getWinScroll: function(){
            return {
                x: Math.max(document.documentElement.scrollLeft, document.body.scrollLeft),
                y: Math.max(document.documentElement.scrollTop, document.body.scrollTop)
            }
        }
    })
    //防止选中文字
    $.fn.noSelect = function(p){
        var prevent = (p == null) ? true : p;
        if (prevent) {
            return this.each(function(){
                if ($.browser.msie || $.browser.safari) 
                    $(this).bind('selectstart', function(){
                        return false;
                    });
                else 
                    if ($.browser.mozilla) {
                        $(this).css('MozUserSelect', 'none');
                        $('body').trigger('focus');
                    }
                    else 
                        if ($.browser.opera) 
                            $(this).bind('mousedown', function(){
                                return false;
                            });
                        else 
                            $(this).attr('unselectable', 'on');
            });
        }
        else {
            return this.each(function(){
                if ($.browser.msie || $.browser.safari) 
                    $(this).unbind('selectstart');
                else 
                    if ($.browser.mozilla) 
                        $(this).css('MozUserSelect', 'inherit');
                    else 
                        if ($.browser.opera) 
                            $(this).unbind('mousedown');
                        else 
                            $(this).removeAttr('unselectable', 'on');
            });
        }
    };
    Simple.declare("Drag", null, {
        node: null,
        handle: null,
        container: null,
        proxy: null,
        delay: 2,
        atCursor: null,
        iframeFix: false,
        direction: "both",
        grid: false,
        revert: false,
        ondragstart: $.noop,
        ondrag: $.noop,
        ondragstop: $.noop,
        dropElements: false,
        ondragenter: $.noop,
        ondragleave: $.noop,
        ondragdrop: $.noop,
        init: function(){
            var self = this;
            if (this.handle) {
                this.handle = $(this.node).find(this.handle);
            }
            else {
                this.handle = $(this.node);
            }
            if (this.dropElements) {
                this.dropElements = $(this.dropElements);
            }
            this.handle.bind("drag/draggable", function(e, event){
                self._movestart.apply(self, [event]);
            })
            this.handle.mousedown(function(e){
                if ($(e.target).is("input")) {
                    return;
                }
                self.handle.trigger("drag/draggable", [e]);
                return false;
            });
        },
        destroy: function(){
            this.handle.unbind("drag/draggable");
        },
        _movestart: function(e){
            e.stopPropagation();
            var s = this, node = $(s.node);
            s.lastX = e.pageX;
            s.lastY = e.pageY;
            s.lastNodeX = Simple.getRealPos(node).left;
            s.lastNodeY = Simple.getRealPos(node).top;
            s.offset = node.offset();
            s.nodeWidth = node.outerWidth();
            s.nodeHeight = node.outerHeight();
            if (typeof s.ondragstart == "function") {
                s.ondragstart.apply(s.node, [e, s]);
            }
            $(document).mousemove(function(e){
                s._moving.apply(s, [e]);
                return false;
            });
            $(document).mouseup(function(e){
                s._movestop.apply(s, [e]);
                return false;
            });
            s._setContainer();
            s._setIframeFix();
            node.hasClass("draggable") && node.addClass("draggable");
            this.overed = null;
            $(document.body).noSelect();
        },
        _moving: function(e){
            var s = this, node = $(this.node), needSetElement;
            s.moveX = e.pageX;
            s.moveY = e.pageY;
            s.changeX = s.moveX - s.lastX;
            s.changeY = s.moveY - s.lastY;
            //延迟拖动
            if (Math.abs(s.changeX) > s.delay && Math.abs(s.changeY) > s.delay) {
				this.hasDrag=true;
                $(document.body).css("cursor", "move");
                $(".draggable-iframeFix").show();
                //网格拖动
                if (this.grid) {
                    this.changeY = Math.round(this.changeY / this.grid[1]) * this.grid[1]
                    this.changeX = Math.round(this.changeX / this.grid[0]) * this.grid[0]
                }
                //拖动区域
                if (s.dragRegion) {
                    if (s.offset.left + s.changeX < s.dragRegion.left) {
                        s.changeX = s.dragRegion.left - s.offset.left
                    }
                    if (s.offset.left + s.changeX + s.nodeWidth > s.dragRegion.right) {
                        s.changeX = s.dragRegion.right - s.offset.left - this.nodeWidth
                    }
                    if (s.offset.top + s.changeY < s.dragRegion.top) {
                        s.changeY = s.dragRegion.top - s.offset.top
                    }
                    if (s.offset.top + s.changeY + s.nodeHeight > s.dragRegion.bottom) {
                        s.changeY = s.dragRegion.bottom - s.offset.top - s.nodeHeight
                    }
                }
                s.left = s.lastNodeX + s.changeX;
                s.top = s.lastNodeY + s.changeY;
                
                if (s.proxy) {
                    s._setProxy();
                    needSetElement = s.proxyElement;
                    s._updatePosition(needSetElement, true);
                }
                else {
                    needSetElement = node;
                    s._updatePosition(needSetElement);
                }
                if (typeof s.ondrag == "function") {
                    s.ondrag.apply(node, [e, s]);
                }
                //检测放置
                this.dropElements && this.checkDroppables();
            }
        },
        _movestop: function(e){
                var s = this, needSetElement;
				if(this.hasDrag){
					this.dropElements && this.checkDroppables(true);
				}
                if (s.proxy) {
                    if (!s.revert) {
                        s._updatePosition($(s.node));
                    }
                    needSetElement = s.proxyElement;
                }
                else {
                    needSetElement = s.node;
                }
                //如果要返回原位
                if (s.revert) {
                    $(s.node).animate({
                        left: s.lastNodeX,
                        top: s.lastNodeY
                    });
                }
                //触发拖动停止事件
                if (typeof s.ondragstop == "function") {
                    s.ondragstop.apply(s.node, [e, s]);
                }
                //解除事件绑定
                $(document).unbind("mousemove").unbind("mouseup");
				this.hasDrag=false;
                //移除标识类
                $(this.node).removeClass('draggable');
                $(document.body).css({
                    "cursor": "default"
                }).noSelect(false);
                $(".draggable-iframeFix").hide();
                if (s.proxyElement) {
                    s.proxyElement.remove();
                    s.proxyElement = null;
                }
        },
        //设置拖动的范围
        _setContainer: function(){
            var region = {};
            if (this.container) {
                if (this.container == document.body) {
                    var DOC = document.documentElement;
                    region.left = 0;
                    region.top = 0;
                    region.right = Math.max(DOC.clientWidth, DOC.scrollWidth);
                    region.bottom = Math.max(DOC.clientHeight, DOC.scrollHeight);
                }
                else {
                    var container = $(this.container);
                    region = Simple.getCoordinates(container);
                }
            }
            else {
                region = null;
            }
            this.dragRegion = region;
        },
        //设置代理
        _setProxy: function(){
            if (this.proxyElement) {
                return;
            }
            var proxy = this.proxy, s = this;
            if (typeof proxy == "string") {
                this.proxyElement = $(this.node).clone().css({
                    "position": "absolute",
                    top: s.lastNodeY,
                    left: s.lastNodeX
                });
            }
            else 
                if (typeof proxy == "function") {
                    this.proxyElement = this.proxy.call(this.node);
                    this.proxyElement.css("position", "absolute");
                }
            this.proxyElement.appendTo(document.body);
        },
        //设置鼠标粘滞 FOR IE
        _setCapture: function(e){
        
        },
        _updatePosition: function(needSetEl, proxy){
            var top = this.top, left = this.left;
            if (proxy) {
                top = this.offset.top + this.changeY;
                left = this.offset.left + this.changeX;
                if (this.atCursor) {
                    top = this.moveY + this.atCursor.top;
                    left = this.moveX + this.atCursor.left;
                }
            }
            if (this.direction == "both") {
                needSetEl.css({
                    top: top,
                    left: left
                });
            }
            else 
                if (this.direction == "x") {
                    needSetEl.css({
                        left: left
                    });
                }
                else {
                    needSetEl.css({
                        top: top
                    });
                }
        },
        _setIframeFix: function(){
            if (this.iframeFix) {
                if (!($(".draggable-iframeFix").is("div"))) {
                    var iframeFixDiv = $("<div/>").css({
                        width: "100%",
                        height: "100%",
                        position: "absolute",
                        opacity: 0,
                        zIndex: 10000,
                        top: 0,
                        left: 0
                    }).addClass("draggable-iframeFix");
                    $(document.body).append(iframeFixDiv);
                }
            }
        },
        checkDroppables: function(isDrop){
            var that = this, overed = this.dropElements.filter(function(i, el){
                el = $(el)
                if (that.proxy) {
                    return that.isInteract(el, that.proxyElement)
                }
                else {
                    return that.isInteract(el, that.node);
                }
            }).last();
            if (this.overed != overed[0]) {
                if (this.overed) {
                    this.ondragleave.apply(this.node, [$(this.overed), this]);
                }
                if (overed[0]) {
                    this.ondragenter.apply(this.node, [overed, this]);
                }
                this.overed = overed[0];
            }
            else {
                if (overed[0]) {
                    if (isDrop) {
                        this.ondragdrop.apply(this.node, [overed, this]);
                    }
                }
            }
        },
        getDroppableCoordinates: function(element){
            if (element) {
                var position = Simple.getCoordinates(element);
                if (element.css("position") == "fixed") {
                    var scroll = Simple.getWinScroll();
                    position.top += scroll.y;
                    position.bottom += scroll.y;
                    position.left += scroll.x;
                    position.right += scroll.x;
                }
                return position;
            }
        },
        isInteract: function(nodeA, nodeB){
            var a = this.getDroppableCoordinates(nodeA), b = this.getDroppableCoordinates(nodeB);
            //不相交的情况
            //A top> B bottom
            //A bottom < B top
            //A right < B left
            //A left >B right
            if (a.top > b.bottom || a.bottom < b.top || a.right < b.left || a.left > b.right) {
                return false;
            }
            else {
                return true;
            }
        }
    });
    Simple.bridgeTojQuery("draggable,drag", Simple.Drag);
})();
/**
 * author:半盏凉茶
 * date:2011-07-04
 */
 
//分页
(function(){
	Simple.declare("Pagination",null, {
		node: null,
		current:1,//当前页码
		count: 0,//记录总数
		size: 10,//每页的记录数量
		maxPage: 5,//最多显示N页，此处建议写单数居中会比较好看
		callBack: function(a,b){},//回调
		_Template: '',//模版
		_PageCount: 0,//分页数量
		_maxPageIndex: 0,//最大页的位置
		init: function(){
			var _self = this;
						
			//计算分页数量
			_self.count % _self.size == 0 ? _self._PageCount =_self. count / _self.size : _self._PageCount = Math.floor(_self.count / _self.size) + 1;

			//初始化分页的最大值
			_self._maxPageIndex = _self.maxPage > _self.count ? _self.count : _self.maxPage;

			//获得分页的一半用于计算
			_self._halfMaxPage = Math.floor(_self.maxPage / 2);		
			
			_self._Go2(_self.current);
		},
		_Go2 : function(page){
			var _self = this;
			_self._Template = '';
			page = parseInt(page);
			
			if(page > _self._PageCount || page < 1){
				alert('您输入的页码超出了范围！');
				return;
			}
			
			_self.current = page;
			
			
			_self._GetPaginationHtml();
			_self._Template +='<span class="Y-page-skip">共 '+ _self._PageCount +' 页,到第<input type="text" class="Y-page-jumpto" value="' + (page) + '"/>页 ';
			_self._Template +='<button title="指定页码" class="Y-page-submit">确定</button></span>';
			
			if(_self.callBack){
				_self.callBack(_self.current, _self.size);
			}
			
			$(_self.node).html(_self._Template);
			
			$('a',_self.node).click(function(){
				_self._Go2($(this).attr('data-pager'));
			})
			
			var jump2 = $('.Y-page-jumpto',_self.node);
			
			jump2.focus(function(){
				jump2.val('');
			});
			
			$('.Y-page-submit',_self.node).click(function(){
				if(jump2.val() == ''){
					alert('请输入页码！');
					return;
				}else if(page == jump2.val()){
					return;
				}
				_self._Go2(jump2.val());
			});
		},
		_GetPaginationHtml : function(){
			var _self = this;
			
			//如果当前页不是第一页则显示上一页的链接
			_self.current > 1 ? _self._style = 'visible' :	_self._style = 'hidden';
				
			_self._Template += '<a class="Y-page-prev" href="javascript:void(0);" data-pager="' + (_self.current - 1) + '" style="visibility: ' + _self._style + ';">&laquo; 上一页</a>';
			
			//当前页超出最大允许页 显示前面的更多按钮
			if(_self.current - _self._halfMaxPage > 1){
				_self._Template += '<a href="javascript:void(0);" data-pager="1">1</a>';
				_self._Template += '<span class="Y-page-break">...</span>';
			}
			_self._Template += _self._GetPagerHtml();
			
			//当所有页数超出最多允许显示的页数时显示更多按钮
			if(_self.current + _self._halfMaxPage < _self._PageCount){
				_self._Template += '<span class="Y-page-break">...</span>';
				_self._Template += '<a href="javascript:void(0);" data-pager="' + _self._PageCount + '">' + _self._PageCount + '</a>';
			}
			
			//如果当前页不是最后页则显示下一页的链接
			_self.current < _self._PageCount ? _self._style = 'visible' :	_self._style = 'hidden';
			_self._Template += '<a class="Y-page-next" href="javascript:void(0);" data-pager="' + (_self.current + 1) + '" style="visibility: ' + _self._style + ';">下一页 &raquo;</a>';
		},
		_GetPagerHtml : function(){
			var _self = this;
			//当前项超出显示列表中的一半
			if(_self.current >_self._maxPageIndex - _self._halfMaxPage){			
				//设置最大的页面值
				_self._maxPageIndex = _self._halfMaxPage + _self.current;	
				
				_self._StartIndex = _self.current - _self._halfMaxPage;
				
				if(_self._maxPageIndex > _self._PageCount){
					//计算超出多少个
					_self._gtNum = _self._maxPageIndex - _self._PageCount;
					_self._maxPageIndex = _self._PageCount;
					
					_self._StartIndex -= _self._gtNum;
				}
			}else{
				_self._maxPageIndex = _self.current + _self._halfMaxPage;
				if(_self._maxPageIndex < _self.maxPage){
					_self._maxPageIndex = _self.maxPage;
				}
				_self._StartIndex = _self.current - _self._halfMaxPage;
			}
						
			var pagerHtml = '';
						
			//设置当 前页码的范围
			if (_self._StartIndex < 1) {
				_self._StartIndex = 1;
			}else if(_self._StartIndex > _self._PageCount){
				_self._StartIndex = _self._PageCount;
			}
			
			for(var i=_self._StartIndex; i<= _self._maxPageIndex ; i++){
				if (i == _self.current) {
					pagerHtml += '<span class="Y-page-cur">' + i + '</span>';
				}
				else {
					pagerHtml += '<a href="javascript:void(0);" data-pager="' + i + '">' + i + '</a>';
				}
			}
			
			return pagerHtml;
		}
	});
        Simple.bridgeTojQuery("pagination,simplePagination", Simple.Pagination);
})();
/**
 * Y.resize.js
 * 让一个元素可以重设尺寸
 * @author Sunny xing
 * @date 2011-07-01
 * @version 0.2
 */
;(function(){
	Simple.declare("Resize",null,{
		node:null,
		direction:["n","ne","e","se","s","sw","w","nw"],
		maxWidth:null,
		minWidth:null,
		minHeight:null,
		maxHeight:null,
		onresizestart:function(){
			
		},
		onresize:function(){
			
		},
		onresizestop:function(){
			
		},
		init:function(){
			if(this.node){
				console.log(this)
				var node=$(this.node),position=node.css("position");
				if(position=="static"){
					node.css({
						"position":"relative",
						top:0,
						left:0
					});
				}
				this._createHandle(this.node);
				this._triggerEvent();
			}
		},
		destroy:function(){
			$(this.node).find(".simple-resize").remove();
		},
		_triggerEvent:function(){
			var self=this;
			$(".simple-resize",this.node).each(function(){
				var type=$(this).attr("data-event");
				$(this).mousedown(function(e){
					e.preventDefault();
					$(this).trigger("resize/"+type,[e,self.node]);
					return false;
				});
			});
		},
		_createHandle:function(node){
			var self=this;
			if(this.direction){
				$.each(this.direction,function(i,item){
					var divHandle=$('<div/>').addClass("simple-resize simple-resize-"+item).attr("data-event",item);
					divHandle.bind("resize/"+item,function(e,event,node){
						self._doMouseDown.apply(self,[event,node,item]);
					});
					$(node).append(divHandle);
				});
			}
		},
		_doMouseDown:function(e,node,item){
			var self=this;
			this.lastX=e.pageX;
			this.lastY=e.pageY;
			this.nodeWidth=$(node).width();
			this.nodeHeight=$(node).height();
			this.top=(this.getOffset(node)).top;
			this.left=(this.getOffset(node)).left;
			$(document).mousemove(function(e){
				self._doMouseMove.apply(self,[e,node,item]);
			});
			$(document).mouseup(function(e){
				self._doMouseUp.apply(self,[e,node,item]);
			});
			return false;
		},
		_doMouseMove:function(e,node,item){
			if($(".draggable-iframeFix")[0]){
				$(".draggable-iframeFix").show();
			}else{
				 var iframeFixDiv = $("<div/>").css({
                        width: "100%",
                        height: "100%",
                        position: "absolute",
                        opacity: 0,
                        zIndex: 10000,
                        top: 0,
                        left: 0
                    }).addClass("draggable-iframeFix");
                 $(document.body).append(iframeFixDiv);
			}
			var x=e.pageX,y=e.pageY
			changeX=x-this.lastX,changeY=y-this.lastY
			switch(item){
				case "n":
				$(node).css({
					top:this.top+changeY,
					height:this.nodeHeight-changeY
				});
				break;
				case "e":
				$(node).css({
					width:this.nodeWidth+changeX
				});
				break;
				case "s":
				$(node).css({
					height:this.nodeHeight+changeY
				});
				break;
				case "w":
				$(node).css({
					left:this.left+changeX,
					width:this.nodeWidth-changeX
				});
				break;
				case "ne":
				$(node).css({
					top:this.top+changeY,
					height:this.nodeHeight-changeY,
					width:this.nodeWidth+changeX
				});
				break;
				case "se":
				$(node).css({
					height:this.nodeHeight+changeY,
					width:this.nodeWidth+changeX
				});
				break;
				case "sw":
				$(node).css({
					height:this.nodeHeight+changeY,
					left:this.left+changeX,
					width:this.nodeWidth-changeX
				});
				break;
				case "nw":
				$(node).css({
					top:this.top+changeY,
					height:this.nodeHeight-changeY,
					left:this.left+changeX,
					width:this.nodeWidth-changeX
				});
				break;
			}
		},
		_doMouseUp:function(){
			$(document).unbind("mousemove").unbind("mouseup");
			$(".draggable-iframeFix").hide();
		},
		 //获取正确的left和top值
        getOffset: function(el){
            var left = parseInt($(el).css("left")), top = parseInt($(el).css("top")), offset = $(el).offset(), elPos = $(el).css("position"), parent = $(el).parent();
            if (!(isNaN(left) || isNaN(top))) {
                return {
                    left: left,
                    top: top
                }
            }
            else {
                if (elPos == "absolute") {
                    while (parent.css("position") != "relative" && parent != document.body) {
                        parent = parent.parent();
                    }
                    var parentOffset = parent.offset();
					return{
						left:offset.left-parentOffset.left,
						top:offset.top-parentOffset.top
					}
                }else if(elPos == "static"){
					$(el).css({
                    "position": "relative",
                    "top": 0,
                    "left": 0
                	});
					return {
						left:0,
						top:0
					}
				}else{
					//do sth;
					//待修正BUG
					var relativeLeft=0,relativeTop=0;
					if(!isNaN(parseInt($(el).css("right")))){
						relativeLeft=-(parseInt($(el).css("right")));
					}
					if(!isNaN(parseInt($(el).css("bottom")))){
						relativeTop=-(parseInt($(el).css("bottom")));
					}
					return {
						left:relativeLeft,
						top:relativeTop
					}
				}
            }
        }
	});
	Simple.bridgeTojQuery("simpleResize",Simple.Resize);
})();
/**
 * @author Sunny xing
 */
(function(){
    Simple.declare("Selectable", null,{
        //触发选中元素的父级节点
        node: null,
        //node元素中的子集节点，会被选中,应该是一个jQuery选择器
        selectNode: null,
        //选中的元素加上的类，以表明该元素被选中了
        selectCls: "y-selectable",
        //延迟触发selectable事件
        delay: 3,
        //选择开始时触发的事件
        onselectstart: function(){
        
        },
        //选择结束时触发的事件
        onselectend: function(e,hasSelectNode){
        
        },
        init: function(){
            var self = this;
            $(this.node).mousedown(function(e){
                self._mouseDown.apply(self, [e]);
            });
        },
        //鼠标按下
        _mouseDown: function(e){
            var self = this;
			self.onselectstart.apply(self.node, [e]);
            //create div to show select area
            //this._createSelectArea();
            this.lastX = e.pageX;
            this.lastY = e.pageY;
			this.hasNodeSelected = [];
            $(document).mousemove(function(e){
                self._mouseMove.apply(self, [e]);
            });
            $(document).mouseup(function(e){
                self._mouseUp.apply(self, [e]);
            });
        },
        _mouseMove: function(e){
            var pageX = e.pageX, pageY = e.pageY, addX = Math.abs(pageX - this.lastX), addY = Math.abs(pageY - this.lastY), self = this, selector;
            this._noSelect(document.body, true);
            if (addX > this.delay && addY > this.delay) {
                if (!this.selectProxy) {
                    this._createSelectArea(this.lastX, this.lastY);
                }
                //更新选择范围的DIV的大小
                this.selectProxy.width(addX).height(addY);
                //当改变的值为负值时，更新选中区域的left和top值
                if (pageX - this.lastX < 0) {
                    this.selectProxy.css("left", e.pageX);
                }
                if (pageY - this.lastY < 0) {
                    this.selectProxy.css("top", e.pageY);
                }
                //判断是否与Node节点下的selectNode相交
                if (this.selectNode) {
                    selector = this.selectNode;
                }
                else {
                    selector = "*";
                }
                $(this.node).find(selector).each(function(){
                    //是否相交
                    if (self._isIntersect(this, self.selectProxy[0])) {
						if($(this).attr("y-selected")==1){
							//
						}else{
							self.hasNodeSelected.push(this);
							$(this).addClass(self.selectCls).attr("y-selected",1);
						}
                    }
                    else {
                        $(this).removeClass(self.selectCls).attr("y-selected",0);
                    }
                });
                this.selectstart = true;
            }
        },
        _mouseUp: function(e){
            if (this.selectstart) {
                var self = this;
                //移除创建的div
                if (this.selectProxy) {
                    this.selectProxy.remove();
                }
                //触发选择结束事件
				self.onselectend.apply(self.node, [e, self.hasNodeSelected]);
                this._noSelect(document.body, false);
                this.selectProxy = null;
                this.selectstart = false;
            }
            //解除事件绑定
            $(document).unbind("mousemove").unbind("mouseup");
        },
		_getSelectedNode:function(){
			return this.hasNodeSelected;
		},
        //创建一个DIV来显示选择的范围
        _createSelectArea: function(x, y){
            this.selectProxy = $("<div/>").addClass("simple-selectable-proxy");
            this.selectProxy.css({
                left: x,
                top: y
            });
            this.selectProxy.appendTo(document.body);
        },
        _isIntersect: function(nodeA, nodeB){
            var nodeAOffset = $(nodeA).offset(), nodeBOffset = $(nodeB).offset(), nodeAWidth = $(nodeA).width(), nodeAHeight = $(nodeA).height(), nodeBWidth = $(nodeB).width(), nodeBHeight = $(nodeB).height();
            //不相交的情况
            //A top> B bottom
            //A bottom < B top
            //A right < B left
            //A left >B right
            if (nodeAOffset.top > nodeBOffset.top + nodeBHeight ||
            nodeAOffset.top + nodeAHeight < nodeBOffset.top ||
            nodeAOffset.left + nodeAWidth < nodeBOffset.left ||
            nodeAOffset.left > nodeBOffset.left + nodeBWidth) {
                return false;
            }
            else {
                return true;
            }
        },
        _noSelect: function(target, bool){
        
            if (typeof target.onselectstart != "undefined") //IE route
                target.onselectstart = function(){
                    return false
                }
            else 
                if (typeof target.style.MozUserSelect != "undefined") //Firefox route
                    target.style.MozUserSelect = "none"
                else //All other route (ie: Opera)
                     target.onmousedown = function(){
                        return false
                    }
        }
    });
    Simple.bridgeTojQuery("selectable",Simple.Selectable);
})();
/**
 * author:半盏凉茶
 * date:2011-10-27
 */
(function(){
    Simple.declare('Slider', null, {
        node : null,
        trigger : true, //传入一个对象或者true   为true则自动生成trigger
        triggerClass : '', //trigger样式
        triggerCurrentClass : '', //trigger current 样式
        content : null, //对应显示的content
        isAuto : true, //是否自动切换
        delay : 0, //操作延时
        speed : 300, //移动速度
        timeout : 3000, //间歇时间
        setup : 1,//每次滚动多少个
        next : null,//下一个
        prev : null,//上一个
        defaultShow : 1, //默认显示第n个
        direction : 'left',//移动方向 仅支持left,top,none
        template : '<ol simpleEvent="trigger"><s:each><li>{0}</li></s:each></ol>',//模版
        bindEvent : 'mouseover',//绑定事件
        ontrigger : null,//移动图片后触发的事件
        ontriggered : null,
        init : function(){
            var s = this;
            s.node = $(s.node);
            s.content = s.node.find(s.content);
						
            s._ = {//内部参数
                current : 0, //当前第n项
                timer : null,//计时器
                autoTimer : null,//自动定时器
                length : 0, //总共有多少项
                width : null, //宽度
                height : null, //高度
                contentParent : null 
            }
			
            s.setDefault();
            s.auto(s);
            s.change(s.defaultShow - 1);
        },
        setDefault: function(){//数据初始化及事件绑定
            var s = this, css;
          
            //初始化轮换内容数量
            s._.length = s.content.length;
          
            //初始化宽高
            s._.width = s.width | s.content.width();
            s._.height = s.height | s.content.height();
          
            s._.contentParent = s.content.parent();          
		  
            css = {
                'position':'relative'
            }; 
		  
            //滚动方向
            if(s.direction == 'left'){
                s._.distance = s._.width;
                s.direction = 'left';
                s.content.css('float','left');
                css['width'] = (s._.width * s._.length) + 'px';
            }else if(s.direction == 'top'){
                s._.distance = s._.height;
                css['height'] = (s._.height * s._.length) + 'px';
            }else{
                
            }
		  
            s._.contentParent.css(css);
          
            if(typeof s.trigger == 'string'){
                s.trigger = $(s.trigger, s.node);
            }
            else if(typeof s.trigger == 'boolean' && s.trigger){
                s._.ts = s.template.indexOf('<s:each>') + '<s:each>'.length;
                s._.te = s.template.lastIndexOf('</s:each>');
                s._.teach = s.template.substring(s._.ts, s._.te);//取出循环部分
                s._.teachHTML = '';
                for(var i=1; i<=s._.length; i++){
                    s._.teachHTML += s._.teach.replace('{0}', i);
                }
              
                s.template = s.template.replace(/<s:each>.*<\/s:each>/, s._.teachHTML);
                s.node.append(s.template);
              
                s._.triggerParent = s.node.find('[simpleEvent=trigger]');
                s._.triggerParent.addClass(s.triggerClass);
              
                s.trigger = s._.triggerParent.children();
            }
          
            s.trigger.eq(s.defaultShow - 1).addClass(s.triggerCurrentClass);
            
            if(s.direction == "left" || s.direction == "top"){
                if(!s.next){
                    s.next = '<span simpleEvent="next">next</span>';
                    s.node.append(s.next);
                    s.next = s.node.find('[simpleEvent=next]');
                }
                else if(typeof s.next == 'string'){
                    s.next = s.node.find(s.next);
                }

                if(!s.prev){
                    s.prev = '<span simpleEvent="prev">prev</span>';
                    s.node.append(s.prev);
                    s.prev = s.node.find('[simpleEvent=prev]');
                }
                else if(typeof s.prev == 'string'){
                    s.prev = s.node.find(s.prev);
                }
            }
          
            s._bindEvent(s);
        },
        _bindEvent : function(s){
            s.trigger.each(function(){
                var el = $(this);
                el.bind(s.bindEvent, function(){
                    clearInterval(s._.autoTimer);
                    clearTimeout(s._.timer);
                    s._.timer = setTimeout(function(){
                        s.change(el.index());
                    }, s.delay);
                });
                
                el.bind("mouseleave", function(){
                    clearTimeout(s._.timer);
                    s.auto(s);
                });
            });

            if(s.next){
                s.next.click(function(){
                     if(s._.current + 1 >= s._.length){
                            s.change(0);
                    }else{
                        s.change(s._.current + 1);
                    }  
                });
            }
            
            if(s.prev){
                s.prev.click(function(){
                    if(s._.current - 1 < 0){
                        s.change(s._.length - 1);
                    }else{
                        s.change(s._.current - 1);
                    }
                });
            }
        },
        //变更显示对象
        change : function(index){
            var s = this,t = [];
			
            if(s.ontrigger){
                s.ontrigger(index);
            }
			            
            s._.current = index;
            
            if(s.direction == 'top' || s.direction == 'left'){
                t[s.direction] = -(index * s._.distance) + 'px';
                s._.contentParent.stop().animate(t, s.speed);
            }else{
                s.content.eq(index).show().siblings().hide();
            }
            
            s.trigger.eq(index).addClass(s.triggerCurrentClass).siblings().removeClass(s.triggerCurrentClass);
            
            if(s.ontriggered){
                s.ontriggered(index);
            }
        },
        auto : function(s){
            if(s.isAuto){
                clearInterval(s._.autoTimer);
                s._.autoTimer = setInterval(function(){
                    if(s._.current + 1 >= s._.length){
                            s.change(0);
                    }else{
                        s.change(s._.current + 1);
                    }
                }, s.timeout);
            }
        }
    });
    
    Simple.bridgeTojQuery("slider,simpleSlider", Simple.Slider);
})();/**
 * author:半盏凉茶
 * date:2011-06-30
 */
 
//选项卡
(function(){
    Simple.declare("ts.Tab",null, {
		node: null,
		delay: 300, //延时(毫秒为单位)
		defaultShow: 1, //默认显示哪个选项卡
		tabList: '',//选项卡菜单
		tabListCurrentClass: 'current',//选项卡菜单当前项的样式
		tabContent: '',//选项卡内容
		bindEvent: 'mouseover click',//绑定触发的事件
		loadClass:'loading',
		init: function(o){
			var _self = this,
				_tabList = $(this.tabList, this.node),
				_tabListChild = $('*',_tabList),
				_tabContent = $(this.tabContent, this.node);
			
			/* 用户可以为tabList 和 tabContent 自定义编号，未定义的时候代码自动为其编号 */
			$.each(_tabList, function(){
				var t = $(this);

				if(!t.attr('data-item')){
					t.attr('data-item', 'Y-tab-' + (t.index()  + 1))
				}
			});
			
			$.each(_tabContent, function(){
				var t = $(this);

				if(!t.attr('data-item')){
					t.attr('data-item', 'Y-tab-' + (t.index()  + 1))
				}
			});
			
			/* 切换 Tab 代码 */
			_self._Change = function(t, c){
				//如果触发的是当前项则不做改变
				if (!t.hasClass(_self.tabListCurrentClass)) {
					/* 选项卡菜单样式修改 及 内容的显示与隐藏 */
					_tabList.removeClass(_self.tabListCurrentClass);
					t.addClass(_self.tabListCurrentClass);
					_tabContent.hide();
					c.show();
					var iframe = $('iframe', c);
					if (iframe[0] && !iframe.attr('src')) {
						if (_self.loadClass) {
							c.addClass(_self.loadClass);
						}
						
						var src = iframe.attr('data-src');
						iframe.attr('src', src);
						iframe.one('load', function(){
							c.removeClass(_self.loadClass);
						})
					}
				}
			}

			//获取默认的显示的项
			var defaultTabList = $(_self.tabList + '[data-item=Y-tab-' + _self.defaultShow + ']', _self.node);
			var defaultTabContent = $(_self.tabContent + '[data-item=Y-tab-' + _self.defaultShow + ']', _self.node);
			_self._Change(defaultTabList, defaultTabContent);
			
			//_tabListChild.bind(_self.bindEvent, function(){return false;});
			_tabList.bind(_self.bindEvent,function(){
				_self._t = this;
				//如果设置了延时时间开启延时
				if(_self.delay > 0){
					//清除之前的所有延时
					if(_self.timer){ clearTimeout(_self.timer); } 
					
					_self.timer = setTimeout(function(){
						_self._t = $(_self._t);
						var item = _self._t.attr('data-item');
						var c = $(_self.tabContent + '[data-item='  + item + ']', _self.node);
						_self._Change(_self._t,c);
					}, _self.delay);
				}else{
					_self._t = $(_self._t);
					var item = _self._t.attr('data-item');
					var c = $(_self.tabContent + '[data-item='  + item + ']',_self.node);
					_self._Change(_self._t,c);
				}
			});
		}
	});
})();

Simple.bridgeTojQuery("tab,simpleTab", Simple.ts.Tab);/**
 * @author 蓝面小生
 */
(function(){
    Simple.declare("Tip", null, {
        //触发tip的DOM节点
        node: null,
        //显示的内容
        source: "title",
        //延迟显示的时间
        delayShow: 300,
        //延迟隐藏的时间
        hideShow: 200,
        //触发tip的事件
        showEvent: "hover",
        //允许鼠标悬浮在tip上
        allowTipHover: true,
        //是否允许tip跟随鼠标移动
        allTipMove: false,
        //显示动画
        animate: "fade",
        //显示的位置
        position: ['top', 'left'],
        offset: [-10, 0],
        template: "<div class='simple-tip'><div class='simple-tip-flag' rel='tipFlag'></div><div class='simple-tip-content' rel='tipContent'></div></div>",
        init: function(){
            var self = this;
            if (this.node) {
                this.node = $(this.node);
                this.node.bind("tip/over", function(){
                    self.getContent();
                }).bind("tip/out", function(){
                    if (self.showTimeOut) {
                        clearTimeout(self.showTimeOut);
                    }
                    self.hide.call(self);
                });
                this.node.mouseenter(function(e){
                    var that = $(this);
                    that.data("active", true);
                    self.eventX = e.pageX;
                    self.eventY = e.pageY;
                    self.showTimeOut = setTimeout(function(){
                        that.trigger("tip/over");
                    }, self.delayShow);
                    return false;
                });
                
                this.node.mouseleave(function(){
                    var that = $(this);
                    self.hideTimeOut = setTimeout(function(){
                        that.data("active", false);
                        that.trigger("tip/out");
                    }, self.hideShow);
                    return false;
                });
                
                if (this.allTipMove) {
                    this.node.mousemove(function(e){
                        self.eventX = e.pageX;
                        self.eventY = e.pageY;
                        if (self.contentCon) {
                            self.show.call(self);
                        }
                    })
                }
                this.id = "simpleTip_" + new Date().getTime();
            }
        },
        destroy: function(){
            this.node.unbind("tip/over").unbind("tip/out");
        },
        getContent: function(){
            var self = this;
            this.createDom();
            if (this.source == "title") {
                this.getContentCallback(this.node.attr("title"));
            }
            else {
                this.content = this.source(function(data){
                    self.getContentCallback.call(self, data);
                });
            }
        },
        getContentCallback: function(content){
            this.content = content;
            this.show();
        },
        calculatePos: function(){
            var trigger = this.node, tip = this.template, arrow, top = trigger.offset().top, left = trigger.offset().left, pos = this.position[0];
            
            top -= tip.outerHeight() - this.offset[0];
            left += trigger.outerWidth() + this.offset[1];
            
            var height = tip.outerHeight() + trigger.outerHeight();
            if (pos == 'center') {
                top += height / 2;
            }
            if (pos == 'bottom') {
                top += height;
            }
            
            pos = this.position[1];
            var width = tip.outerWidth() + trigger.outerWidth();
            if (pos == 'center') {
                left -= width / 2;
            }
            if (pos == 'left') {
                left -= width;
                left += tip.outerWidth() / 2;
            }
            if (this.position[0] == "top") {
                arrow = "bottom"
            }
            else 
                if (this.position[0] == "bottom") {
                    arrow = "top"
                }
                else 
                    if (this.position[1] == "left") {
                        arrow = "right";
                    }
                    else {
                        arrow = "left";
                    }
            
            this.pos = {
                l: left,
                t: top,
                arrow: arrow
            }
            //return {top: top, left: left};
        },
        createDom: function(){
            var self = this;
            if ($(".simple-tip")[0]) {
                this.template = $(".simple-tip");
            }
            else {
                this.template = $(this.template);
            }
            this.flag = this.template.find("[rel=tipFlag]");
            this.contentCon = this.template.find('[rel=tipContent]');
            
            if (this.allowTipHover) {
                self.template.unbind().mouseenter(function(){
                    clearTimeout(self.hideTimeOut);
                    clearTimeout(self.tHideTime);
                }).mouseleave(function(){
                    self.tHideTime = setTimeout(function(){
                        self.template.hide();
                    }, 200)
                });
            }
            this.template.show().appendTo(document.body);
            this.template[0].id = this.id;
        },
        show: function(){
            if (this.node.data("active")) {
                this.contentCon.html(this.content);
                this.calculatePos();
                this.template.css({
                    top: this.pos.t,
                    left: this.pos.l
                })
                this.flag.removeClass().addClass("simple-tip-flag simple-tip-" + this.pos.arrow);
            }
        },
        hide: function(){
            $(this.template).hide();
        }
    });
    
    Simple.bridgeTojQuery("simpletip,tip", Simple.Tip);
    
    Simple.popTip=function(){
        var Tip = function(text, container, type, timeout){
            this.template = '<div class="simple-load" style="position:fixed;_position:absolute;"><span class="simple-load-l"></span><div class="simple-load-bg"></div><div class="simple-load-text"><i></i><label>正在导入中...</label></div></div>';
            this.text = text;
            this.node = $(this.template).clone();
            this.container = typeof container == "string" ? $(container) : container;
            this.type = type;
            this.timeout = timeout;
            this.init();
        }
        Tip.prototype = {
            init: function(){
                $(".simple-load").remove();
                var self = this;
                switch (this.type) {
                    case "load":
                        this.node.addClass("simple-tip-load");
                        break;
                    case "success":
                        this.node.addClass("simple-tip-success");
                        break;
                    case "info":
                        this.node.addClass("simple-tip-info");
                        break;
                    case "alert":
                        this.node.addClass("simple-tip-alert");
                        break;
                }
                this.show();
				self.timeout=self.timeout||2000;
                if (this.type != "load") {
                    setTimeout(function(){
                        self.hide();
                    }, self.timeout);
                }
            },
            show: function(){
                var self = this;
                $(document.body).append(this.node);
                this.node.find(".simple-load-text label").html(this.text);
                //fix ie6
                var simpleTextWidth = this.node.find(".simple-load-text").width() + parseInt(this.node.find(".simple-load-text").css("paddingLeft"));
                this.node.width(simpleTextWidth);
                this.node.find(".simple-load-bg").width(simpleTextWidth + 10);
                this.setPosition();
                //listen resize
                $(window).resize(function(){
                    self.setPosition();
                });
            },
            hide: function(){
                this.node.remove();
            },
            setPosition: function(){
                var width, height, nodeWidth = this.node.width(), nodeHeight = this.node.height();
                if (this.container) {
                    width = this.container.width();
                    height = this.container.height();
                }
                else {
                    width = document.documentElement.clientWidth;
                    height = document.documentElement.clientHeight;
                }
                
                this.node.css({
                    top: (height - nodeHeight) / 3,
                    left: ((width - nodeWidth) / 2) + 12
                });
            }
        }
        
        return {
            load: function(text, container){
                return new Tip(text, container, "load");
            },
            success: function(text, timeout, container){
                return new Tip(text, container, "success", timeout);
            },
            info: function(text, timeout, container){
                return new Tip(text, container, "info", timeout);
            },
            alert: function(text, timeout, container){
                return new Tip(text, container, "alert", timeout);
            }
        }
    }();
	
    var tipMethod=Simple.popTip;
	$.each(tipMethod,function(k,v){
		jQuery[k+"Tip"]=v;
	})
})();
