/**
 * @author 蓝面小生
 */
module("SimpleCore");

test("Simple.mixin",function(){
	ok(Simple.mixin({},{a:1}).a===1,"新的对象产生了");
	ok(Simple.mixin({a:2},{a:1}).a===1,"对象值改变了");
});

test("Simple.define",function(){
	Simple.define("test",function(){
		return {
			test:"test"
		}
	});
	
	ok(Simple.loaded.test,"test模块被装载了");
	equal(Simple.defined.test.test,"test","test模块的返回test值是test");
});

test("Simple.require",function(){
	Simple.require("test",function(t){
		equal(t.test,"test","通过require装载了test模块，且取到的返回值是test");
	});
	//异步测试
	stop();
	Simple.require(["test","test2"],function(t,t2){
		start();
		ok(true,"已经加载test,test2模块");
		ok(t.test=="test","test模块返回的值是test");
		ok(t2.test2=="test2","test2模块返回的值是test2");
	});
});

test("Simple.declare",function(){
	Simple.declare("Dialog",null,{
		count:10,
		init:function(){
			
		},
		show:function(){
			return this.count;
		},
		destroy:function(){
			
		}
	});
	equal(new Simple.Dialog().show(),10,"声明了一个构造函数，对话框的数量为10")
	
	Simple.declare("Overlay",Simple.Dialog,{
		init:function(){
			this.count=20;
		},
		show:function(){
			var b= this.supermethod(arguments);
			return b;
		}
	});
	equal(new Simple.Overlay().count,20,"定义overlay的数量为20");
	
	equal(new Simple.Overlay().show(),10,"调用父级的方法，返回值为10");
	
	Simple.require("Dialog",function(){
		ok(true,"Dialog模块也被装载了")
	})
});


test("Simple.plugin",function(){
	Simple.plugin("title",Simple.Dialog,{
		_init:function(){
			this.title="test";
		},
		methods:{
			getTitle:function(){
				return this.title
			}
		}
	});
	var testPlugin=new Simple.Dialog({
		plugins:["title"]
	})
	equal(testPlugin.getTitle(),"test","Dialog标题是test");
});

test("Simple.bridgeTojQuery",function(){
	
	Simple.bridgeTojQuery("dialog",Simple.Dialog);
	
	ok(jQuery.prototype.dialog,"jquery原型链上已经存在dialog方法了");
	var dialogs=$(document).dialog({
		plugins:["title"]
	});
	equal(dialogs.data("widget_dialog").getTitle(),"test","使用dialogs存储的对象返回值test");
	
	$(document).dialog("destroy");
	
	ok(!dialogs.data("widget_dialog"),"dialogs存储对象已经被销毁");
});
