<?php
!defined('P_W') && exit('Forbidden');
//note config
$connect['url'] = 'http://connect.discuz.qq.com';
$connect['api_url'] = 'http://api.discuz.qq.com';
$connect['avatar_url'] = 'http://avatar.connect.discuz.qq.com';
$connect['callback_url'] = $R_url.'/connect.php?mod=login&op=callback';
//note config
if(!defined('INSTALL_ROOT')) {
	include_once(D_P.'data/bbscache/cache_qqconnect.php');
}
$connect_settings = (array)unserialize($qqconnect_setting);
$connect_settings['qqconnect_api_ip'] = $qqconnect_api_ip;
list($connect_settings['connectappkey']) = explode('|', base64_decode($connect_settings['connectappkey']));

function dstripslashes($string) {
	if(empty($string)) return $string;
	if(is_array($string)) {
		foreach($string as $key => $val) {
			$string[$key] = dstripslashes($val);
		}
	} else {
		$string = stripslashes($string);
	}
	return $string;
}

function dfsockopen($url, $limit = 0, $post = '', $cookie = '', $bysocket = FALSE, $ip = '', $timeout = 15, $block = TRUE) {
	$return = '';
	$matches = parse_url($url);
	$host = $matches['host'];
	$path = $matches['path'] ? $matches['path'].($matches['query'] ? '?'.$matches['query'] : '') : '/';
	$port = !empty($matches['port']) ? $matches['port'] : 80;

	if($post) {
		$out = "POST $path HTTP/1.0\r\n";
		$out .= "Accept: */*\r\n";
		$out .= "Accept-Language: zh-cn\r\n";
		$out .= "Content-Type: application/x-www-form-urlencoded\r\n";
		$out .= "User-Agent: $_SERVER[HTTP_USER_AGENT]\r\n";
		$out .= "Host: $host\r\n";
		$out .= 'Content-Length: '.strlen($post)."\r\n";
		$out .= "Connection: Close\r\n";
		$out .= "Cache-Control: no-cache\r\n";
		$out .= "Cookie: $cookie\r\n\r\n";
		$out .= $post;
	} else {
		$out = "GET $path HTTP/1.0\r\n";
		$out .= "Accept: */*\r\n";
		$out .= "Accept-Language: zh-cn\r\n";
		$out .= "User-Agent: $_SERVER[HTTP_USER_AGENT]\r\n";
		$out .= "Host: $host\r\n";
		$out .= "Connection: Close\r\n";
		$out .= "Cookie: $cookie\r\n\r\n";
	}

	if(function_exists('fsockopen')) {
		$fp = @fsockopen(($ip ? $ip : $host), $port, $errno, $errstr, $timeout);
	} elseif(function_exists('pfsockopen')) {
		$fp = @pfsockopen(($ip ? $ip : $host), $port, $errno, $errstr, $timeout);
	} else {
		$fp = '';
	}

	if(!$fp) {
		return '';
	} else {
		stream_set_blocking($fp, $block);
		stream_set_timeout($fp, $timeout);
		@fwrite($fp, $out);
		$status = stream_get_meta_data($fp);
		if(!$status['timed_out']) {
			while (!feof($fp)) {
				if(($header = @fgets($fp)) && ($header == "\r\n" ||  $header == "\n")) {
					break;
				}
			}

			$stop = false;
			while(!feof($fp) && !$stop) {
				$data = fread($fp, ($limit == 0 || $limit > 8192 ? 8192 : $limit));
				$return .= $data;
				if($limit) {
					$limit -= strlen($data);
					$stop = $limit <= 0;
				}
			}
		}
		@fclose($fp);
		return $return;
	}
}

function authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {
	$ckey_length = 4;
	$key = md5($key != '' ? $key : '');
	$keya = md5(substr($key, 0, 16));
	$keyb = md5(substr($key, 16, 16));
	$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

	$cryptkey = $keya.md5($keya.$keyc);
	$key_length = strlen($cryptkey);

	$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
	$string_length = strlen($string);

	$result = '';
	$box = range(0, 255);

	$rndkey = array();
	for($i = 0; $i <= 255; $i++) {
		$rndkey[$i] = ord($cryptkey[$i % $key_length]);
	}

	for($j = $i = 0; $i < 256; $i++) {
		$j = ($j + $box[$i] + $rndkey[$i]) % 256;
		$tmp = $box[$i];
		$box[$i] = $box[$j];
		$box[$j] = $tmp;
	}

	for($a = $j = $i = 0; $i < $string_length; $i++) {
		$a = ($a + 1) % 256;
		$j = ($j + $box[$a]) % 256;
		$tmp = $box[$a];
		$box[$a] = $box[$j];
		$box[$j] = $tmp;
		$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
	}

	if($operation == 'DECODE') {
		if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
			return substr($result, 26);
		} else {
			return '';
		}
	} else {
		return $keyc.str_replace('=', '', base64_encode($result));
	}

}

function connect_writelog($file, $log) {
	global $timestamp;
	$yearmonth = get_date($timestamp, 'Ym');
	$logdir = D_P.'data/log/';
	dmkdir($logdir);
	$logfile = $logdir.$yearmonth.'_'.$file.'.php';
	if(@filesize($logfile) > 2048000) {
		$dir = opendir($logdir);
		$length = strlen($file);
		$maxid = $id = 0;
		while($entry = readdir($dir)) {
			if(strpos($entry, $yearmonth.'_'.$file) !== false) {
				$id = intval(substr($entry, $length + 8, -4));
				$id > $maxid && $maxid = $id;
			}
		}
		closedir($dir);

		$logfilebak = $logdir.$yearmonth.'_'.$file.'_'.($maxid + 1).'.php';
		@rename($logfile, $logfilebak);
	}
	if($fp = @fopen($logfile, 'a')) {
		@flock($fp, 2);
		$log = is_array($log) ? $log : array($log);
		foreach($log as $tmp) {
			fwrite($fp, "<?PHP exit;?>\t".str_replace(array('<?', '?>'), '', $tmp)."\n");
		}
		fclose($fp);
	}
}

function dmkdir($dir, $mode = 0777, $makeindex = TRUE){
	if(!is_dir($dir)) {
		dmkdir(dirname($dir));
		@mkdir($dir, $mode);
		if(!empty($makeindex)) {
			@touch($dir.'/index.html'); @chmod($dir.'/index.html', 0777);
		}
	}
	return true;
}

function dreferer() {
	global $referer;
	S::gp(array('referer'));

	$referer = !empty($referer) ? $referer : $_SERVER['HTTP_REFERER'];
	$referer = substr($referer, -1) == '?' ? substr($referer, 0, -1) : $referer;

	$referer = htmlspecialchars($referer);
	$referer = str_replace('&amp;', '&', $referer);
	return strip_tags($referer);
}

//pw cache_qqconnect
function updatecache_qqconnect() {
	global $db;
	$query=$db->query("SELECT * FROM pw_hack WHERE hk_name LIKE 'qqconnect_%'");
	$configdb="<?php\n//Discuz! cache file\r\n";
	while(@extract($db->fetch_array($query))) {
		$hk_name = key_cv($hk_name);
		$configdb .= "\$$hk_name=".pw_var_export($hk_value).";\r\n";
	}
	$configdb.="?>";
	writeover(D_P.'data/bbscache/cache_qqconnect.php',$configdb);
}

function de_checkVar(&$var) {
	if (is_array($var)) {
		foreach ($var as $key => $value) {
			S::de_checkVar($var[$key]);
		}
	} elseif (P_W != 'admincp') {
		$var = str_replace(array('&#46;&#46;', '&#41;', '&#60;', '&#61;'),array('..', ')', '<', '='), $var);
	}
}

if(!function_exists('processLogin')) {
	function processLogin($userId, $user = null, $cktime = '31536000', $lgt = 0) {
		global $timestamp, $db_ckpath, $db_ckdomain, $db_autoban;
		if (!$user) {
			$userService = L::loadClass('UserService', 'user'); /* @var $userService PW_UserService */
			$user = $userService->get($userId, true, true);
		}

		$pwuser = $user['username'];
		$md5_pwpwd = $user['password'];
		$safecv = $user['safecv'];

		require_once(R_P . 'require/checkpass.php');
		$logininfo = checkpass($pwuser, $md5_pwpwd, $safecv, $lgt);
		if (!is_array($logininfo)) {
			Showmsg($logininfo);
		}
		list($winduid, , $windpwd, ) = $logininfo;

		/*update cache*/
		$_cache = getDatastore();
		$_cache->delete("UID_".$winduid);

		$cktime != 0 && $cktime += $timestamp;
		Cookie("winduser",StrCode($winduid."\t".$windpwd."\t".$safecv),$cktime);
		Cookie("ck_info",$db_ckpath."\t".$db_ckdomain);
		Cookie('lastvisit','',0);//$lastvistԽעĻԱյûԱ

		if ($db_autoban) {
			require_once(R_P.'require/autoban.php');
			autoban($winduid);
		}

		return $logininfo;
	}
}
//pw

//note cloud
function generateSiteSignUrl($params = array(), $isEncode = true, $isCamelCase = false) {
	global $timestamp, $winduid, $connect;

	$ts = $timestamp;
	$sId = $connect['my_siteid'];
	$sKey = $connect['my_sitekey'];
	$uid = $winduid;

	if(!is_array($params)) {
		$params = array();
	}

	unset($params['sig'], $params['ts']);

	if ($isCamelCase) {
		$params['sId'] = $sId;
		$params['sSiteUid'] = $uid;
	} else {
		$params['s_id'] = $sId;
		$params['s_site_uid'] = $uid;
	}
	$params['link_url'] = 'admin.php?adminjob=hack&hackset=qqconnect';
	$params['self_url'] = 'admin.php?adminjob=hack&hackset=qqconnect&action=service';
	ksort($params);

	$str = buildArrayQuery($params, '', $isEncode);
	$sig = md5(sprintf('%s|%s|%s', $str, $sKey, $ts));

	$params['ts'] = $ts;
	$params['sig'] = $sig;

	$url = buildArrayQuery($params, '', $isEncode);
	return $url;
}


function buildArrayQuery($data, $key = '', $isEncode = false) {

	if ($key) {
		$query =  array($key => $data);
	} else {
		$query = $data;
	}

	if ($isEncode) {
		return cloud_http_build_query($query, '', '&');
	} else {
		return cloud_http_build_query($query);
	}
}

function cloud_http_build_query($data, $numeric_prefix='', $arg_separator='', $prefix='') {
	$render = array();
	if (empty($arg_separator)) {
		$arg_separator = @ini_get('arg_separator.output');
		empty($arg_separator) && $arg_separator = '&';
	}
	foreach ((array) $data as $key => $val) {
		if (is_array($val) || is_object($val)) {
			$_key = empty($prefix) ? "{$key}[%s]" : sprintf($prefix, $key) . "[%s]";
			$_render = cloud_http_build_query($val, '', $arg_separator, $_key);
			if (!empty($_render)) {
				$render[] = $_render;
			}
		} else {
			if (is_numeric($key) && empty($prefix)) {
				$render[] = urlencode("{$numeric_prefix}{$key}") . "=" . urlencode($val);
			} else {
				if (!empty($prefix)) {
					$_key = sprintf($prefix, $key);
					$render[] = urlencode($_key) . "=" . urlencode($val);
				} else {
					$render[] = urlencode($key) . "=" . urlencode($val);
				}
			}
		}
	}
	$render = implode($arg_separator, $render);
	if (empty($render)) {
		$render = '';
	}
	return $render;
}


//note connect
function connect_get_request_token() {
	global $connect, $referer, $onlineip;

	$api_url = $connect['api_url'].'/oauth/requestToken';

	$extra = array();
	$extra['oauth_callback'] = urlencode($connect['callback_url'] . '&referer=' . urlencode($referer));
	$sig_params = connect_get_oauth_signature_params($extra);
	$sig_params['oauth_signature'] = connect_get_oauth_signature($api_url, $sig_params, 'POST');

	$params = array (
		'client_ip' => $onlineip
	);

	S::gp(array('type', 'statfrom'), 'G');
	$params['type'] = $type;
	if(empty ($params['type'])) {
		$params['type'] = 'login';
	}
	if($statfrom) {
		$params['statfrom'] = $statfrom;
	}
	$params = array_merge($sig_params, $params);

	$response = connect_output_php($api_url.'?', cloud_http_build_query($params, '', '&'));
	return $response;
}

function connect_get_oauth_signature_params($extra = array ()) {
	global $timestamp, $connect_settings;

	$params = array (
		'oauth_consumer_key' => $connect_settings['connectappid'],
		'oauth_nonce' => connect_get_nonce(),
		'oauth_signature_method' => 'HMAC_SHA1',
		'oauth_timestamp' => $timestamp
	);
	if($extra) {
		$params = array_merge($params, $extra);
	}
	ksort($params);

	return $params;
}

function connect_get_oauth_signature($url, $params, $method = 'POST', $oauth_token_secret = '') {
	global $connect_settings;

	$method = strtoupper($method);
	if(!in_array($method, array ('GET', 'POST'))) {
		return FALSE;
	}

	$url = urlencode($url);

	$param_str = urlencode(cloud_http_build_query($params, '', '&'));

	$base_string = $method.'&'.$url.'&'.$param_str;

	$key = $connect_settings['connectappkey'].'&'.$oauth_token_secret;

	if(function_exists('hash_hmac')) {
		$signature = hash_hmac('sha1', $base_string, $key);
	} else {
		$signature = connect_custom_hmac('sha1', $base_string, $key);
	}
	return $signature;
}

function connect_output_php($url, $postData = '') {
	global $connect_settings;

	$response = dfsockopen($url, 0, $postData, '', false, $connect_settings['qqconnect_api_ip']);
	$result = (array) unserialize($response);
	return $result;
}

function connect_get_nonce() {
	$mt = microtime();
	$rand = mt_rand();

	return md5($mt.$rand);
}

function connect_custom_hmac($algo, $data, $key, $raw_output = false) {
	$algo = strtolower($algo);
	$pack = 'H'.strlen($algo ('test'));
	$size = 64;
	$opad = str_repeat(chr(0x5C), $size);
	$ipad = str_repeat(chr(0x36), $size);

	if(strlen($key) > $size) {
		$key = str_pad(pack($pack, $algo ($key)), $size, chr(0x00));
	} else {
		$key = str_pad($key, $size, chr(0x00));
	}

	for ($i = 0; $i < strlen($key) - 1; $i++) {
		$opad[$i] = $opad[$i] ^ $key[$i];
		$ipad[$i] = $ipad[$i] ^ $key[$i];
	}

	$output = $algo ($opad.pack($pack, $algo ($ipad.$data)));

	return ($raw_output) ? pack($pack, $output) : $output;
}

function connect_errlog($errno, $error) {
	global $timestamp;
	connect_writelog('errorlog', $timestamp."\t[QQConnect]".$errno." ".$error);
}

function connect_check_sig($params) {
	global $connect_settings;

	if(!$params) {
		return false;
	}

	$valid_params = array();
	foreach($params as $key => $value) {
		if(substr($key, 0, 4) == 'con_') {
			$valid_params[$key] = $value;
		}
	}
	$sig = $valid_params['con_sig'];
	unset($valid_params['con_sig']);
	ksort($valid_params);
	$str = '';
	foreach($valid_params as $k => $v) {
		if($v) {
			$str .= $k.'='.$v.'&';
		}
	}

	return $sig === md5($str.$connect_settings['connectappkey']);
}

function connect_params($params, & $connect_params) {
	if(!$params) {
		return false;
	}
	$connect_params = array ();
	foreach ($params as $key => $value) {
		if(substr($key, 0, 4) == 'con_') {
			$connect_params[substr($key, 4)] = $value;
		}
	}
}

function connect_get_access_token($request_token, $verify_code) {
	global $connect, $onlineip;

	$api_url = $connect['api_url'].'/oauth/accessToken';

	$extra = array();
	$extra['oauth_token'] = $request_token;
	$extra['oauth_verifier'] = $verify_code;
	$sig_params = connect_get_oauth_signature_params($extra);
	$oauth_token_secret = GetCookie('con_request_token_secret');
	$sig_params['oauth_signature'] = connect_get_oauth_signature($api_url, $sig_params, 'POST', $oauth_token_secret);

	$params = array (
		'client_ip' => $onlineip
	);
	$params = array_merge($sig_params, $params);

	Cookie('con_request_token');
	Cookie('con_request_token_secret');


	$response = connect_output_php($api_url.'?', cloud_http_build_query($params, '', '&'));
	return $response;
}

function connect_auth_field($is_user_info, $is_feed) {
	if ($is_user_info && $is_feed) {
		return 1;
	} elseif (!$is_user_info && !$is_feed) {
		return 0;
	} elseif ($is_user_info && !$is_feed) {
		return 2;
	} elseif (!$is_user_info && $is_feed) {
		return 3;
	}
}

function connect_filter_username($username) {
	$username = str_replace(' ', '_', trim($username));
	return substrs($username, 15, '');
}

function connect_user_unbind() {
	global $connect, $connect_member, $onlineip;

	$api_url = $connect['api_url'].'/connect/user/unbind';

	$extra = array (
		'oauth_token' => $connect_member['conuin']
	);
	$sig_params = connect_get_oauth_signature_params($extra);
	$oauth_token_secret = $connect_member['conuinsecret'];
	$sig_params['oauth_signature'] = connect_get_oauth_signature($api_url, $sig_params, 'POST', $oauth_token_secret);

	$params = array (
		'client_ip' => $onlineip
	);
	$params = array_merge($sig_params, $params);
	$params['response_type'] = 'php';

	$response = connect_output_php($api_url.'?', cloud_http_build_query($params, '', '&'));
	return $response;
}

function cloudDNSCheck($url) {
	if (!$url) {
		return false;
	}
	$matches = parse_url($url);
	$host = $matches['host'] ? $matches['host'] : $matches['path'];
	if (!$host) {
		return false;
	}
	$ip = gethostbyname($host);
	if ($ip == $host) {
		return false;
	} else {
		return $ip;
	}
}

function cloudAPIConnectTest($type = 1, $ip = '') {

	if($type == 1) {
		$url = 'http://api.discuz.qq.com/site.php';
		$result = dfsockopen($url, 0, '', '', false, $ip, 5);
	} elseif($type == 2) {
		$url = 'http://api.manyou.com/uchome.php';
		$result = dfsockopen($url, 0, 'action=siteRefresh', '', false, $ip, 5);
	}

	$result = trim($result);

	if(!$result) {
		return false;
	}

	$result = @unserialize($result);
	if(!$result) {
		return false;
	}
	return true;
}

function connect_user_bind_js($params) {
	global $connect;

	$jsname = GetCookie('connect_js_name');
	if($jsname != 'user_bind') {
		return false;
	}

	$jsparams = unserialize(base64_decode(GetCookie('connect_js_params')));
	$jsurl = $connect['url'].'/notify/user/bind';

	if($jsparams) {
		$params = array_merge($params, $jsparams);
	}

	$func = 'connect_'.$jsname.'_params';
	$other_params = $func ();
	$params = array_merge($other_params, $params);
	$params['sig'] = connect_get_sig($params, connect_get_sig_key());
	$jsurl .= '?'.cloud_http_build_query($params, '', '&');

	Cookie('connect_js_name');
	Cookie('connect_js_params');
	return connect_output_javascript($jsurl);
}

function connect_get_sig_key() {
	global $connect_settings;
	return $connect_settings['connectappid'] . '|' . $connect_settings['connectappkey'];
}

function connect_get_sig($params, $app_key) {
	ksort($params);
	$base_string = '';
	foreach($params as $key => $value) {
		$base_string .= $key.'='.$value;
	}
	$base_string .= $app_key;
	return md5($base_string);
}

function connect_output_javascript($jsurl) {
	return '<script language="JavaScript">function con_handle_response(str){}</script><script language="JavaScript" src="'.$jsurl.'"></script>';
}

function connect_user_bind_params() {
	global $connect_settings, $winduid, $timestamp;

	$userService = L::loadClass('UserService', 'user'); /* @var $userService PW_UserService */
	$userinfo = $userService->get($winduid);

	switch ($userinfo['gender']) {
		case 1 :
			$sex = 'male';
			break;
		case 2 :
			$sex = 'female';
			break;
		default :
			$sex = 'unknown';
	}

	$is_public_email = 2;
	$birthday = $userinfo['bday'];
	$params = array (
		'oauth_consumer_key' => $connect_settings['connectappid'],
		'u_id' => $winduid,
		'username' => $userinfo['username'],
		'email' => $userinfo['email'],
		'birthday' => $birthday,
		'sex' => $sex,
		'is_public_email' => $is_public_email,
		'is_use_qq_avatar' => 2,
		's_id' => null,
		'avatar_input' => null,
		'avatar_agent' => null,
		'site_ucenter_id' => null
	);

	return $params;
}
?>