<?php
if(!defined('IN_CONNECT')) {
	exit('Access Denied');
}

S::gp(array('op'), 'GP');
if(!in_array($op, array('init', 'callback', 'change', 'bind'))) {
	Showmsg('undefined_action');
}

$referer = dreferer();
preg_match('/^(http|https|ftp|javascript):/i', $referer, $matches);
if($matches) {
	$referer = 'index.php';
}

if($op == 'init') {
	Cookie('con_request_token');
	Cookie('con_request_token_secret');

	$response = connect_get_request_token();
	if(!isset($response['status']) || $response['status'] !== 0) {
		if(!isset($response['status'])) {
			connect_errlog('100', getLangInfo('connect', 'connect_errlog_server_no_response', '', true));
		} else {
			connect_errlog($response['status'], $response['result']);
		}
		refreshto($referer, getLangInfo('connect', 'connect_get_request_token_failed', '', true));
	}

	$request_token = $response['result']['oauth_token'];
	$request_token_secret = $response['result']['oauth_token_secret'];

	Cookie('con_request_token', $request_token);
	Cookie('con_request_token_secret', $request_token_secret);

	$params = array(
		'oauth_token' => $request_token,
		'oauth_consumer_key' => $connect_settings['connectappid'],
	);

	S::gp(array('type'), 'GP');
	if($type) {
		$params['type'] = $type;
	}

	$redirect = $connect['url'] . '/oauth/authorize?'.cloud_http_build_query($params, '', '&');
	ObHeader($redirect);

} elseif($op == 'callback') {
	foreach($_GET as $_key => $_value) {
		de_checkVar($_GET[$_key]);
	}

	$params = $_GET;
	if(!connect_check_sig($params)) {
		connect_errlog('103', getLangInfo('connect', 'connect_errlog_sig_incorrect', '', true));
		refreshto($referer, getLangInfo('connect', 'connect_get_access_token_failed', '', true));
	}

	if(!isset($params['receive'])) {
		echo '<script type="text/javascript">setTimeout("window.location.href=\'connect.php?receive=yes&'.str_replace("'", "\'", cloud_http_build_query($_GET, '', '&')).'\'", 1)</script>';
		exit;
	}

	connect_params($params, $connect_params);

	$request_token = $connect_params['oauth_token'];
	$verify_code = $connect_params['oauth_verifier'];
	if($request_token && $verify_code) {
		$response = connect_get_access_token($request_token, $verify_code);
		if(!isset($response['status']) || $response['status'] != 0) {
			connect_errlog($response['status'], $response['result']);
			refreshto($referer, getLangInfo('connect', 'connect_get_access_token_failed', '', true));
		}
		$conuin = $response['result']['oauth_token'];
		$conuinsecret = $response['result']['oauth_token_secret'];
		$conopenid = $response['result']['openid'];
		if(!$conuin || !$conuinsecret || !$conopenid) {
			connect_errlog('101', getLangInfo('connect', 'connect_errlog_access_token_incomplete', '', true));
			refreshto($referer, getLangInfo('connect', 'connect_get_access_token_failed', '', true));
		}
	} else {
		connect_errlog('102', getLangInfo('connect', 'connect_errlog_request_token_not_authorized', '', true));
		refreshto($referer, getLangInfo('connect', 'connect_get_access_token_failed', '', true));
	}

	/*޸ĺ̨ļ*/
	if($db->get_value("SELECT uid FROM pw_uin_black WHERE uin=".S::sqlEscape($conopenid))) {
		$params = array(
			'oauth_token' => $request_token,
			'oauth_consumer_key' => $connect_settings['connectappid']
		);
		refreshto($referer, getLangInfo('connect', 'connect_uin_in_blacklist', '', true), 3);
	}

	$referer = $referer && (strpos($referer, 'login.php') === false) && (strpos($referer, 'mod=login') === false) ? $referer : 'index.php';

	$is_notify = $connect_params['is_notify'] ? true : false;

	$conispublishfeed = $conispublisht = 0;

	$is_user_info = $connect_params['is_user_info'] ? $connect_params['is_user_info'] : 0;
	$is_feed = $connect_params['is_feed'] ? $connect_params['is_feed'] : 0;

	if($is_feed) {
		$conispublishfeed = $conispublisht = 1;
	}
	$user_auth_fields = connect_auth_field($is_user_info, $is_feed);

	$connect_member = array();
	$connect_member = $db->get_one("SELECT uid, conuin, conuinsecret, conopenid FROM pw_member_connect WHERE conopenid=".S::sqlEscape($conopenid));


	if($connect_member) {
		$member = $db->get_one("SELECT uid, conisbind FROM pw_members WHERE uid=".S::sqlEscape($connect_member['uid']));
		if($member) {
			if(!$member['conisbind']) {
				unset($connect_member);
			} else {
				$connect_member['conisbind'] = $member['conisbind'];
			}
		} else {
			$db->query("DELETE FROM pw_member_connect WHERE uid = ".S::sqlEscape($connect_member['uid'])." LIMIT 1");
			unset($connect_member);
		}
	}

	$connect_is_unbind = $connect_params['is_unbind'] == 1 ? 1 : 0;
	if($connect_is_unbind && $connect_member && !$winduid) {
		Cookie('connect_js_name', 'user_bind', $timestamp + 86400);
		Cookie('connect_js_params', base64_encode(serialize(array('type' => 'registerbind'))), $timestamp + 86400);
	}

	//note ѵ¼̳
	if($winduid) {
		if($connect_member && $connect_member['uid'] != $winduid) {
			refreshto($referer, getLangInfo('connect', 'connect_register_bind_uin_already', '', true));
		}

		$current_connect_member = $db->get_one("SELECT * FROM pw_member_connect WHERE uid=".S::sqlEscape($winduid));
		if($current_connect_member) {
			if($current_connect_member['conopenid'] && $current_connect_member['conopenid'] != $conopenid) {
				refreshto($referer, getLangInfo('connect', 'connect_register_bind_already', '', true));
			}
			if(empty($connect_member['conuinsecret']) || empty($connect_member['conopenid']) || $connect_member['conuinsecret'] != $conuinsecret) {
				$db->query("UPDATE pw_member_connect SET conuin=".S::sqlEscape($conuin).", conuinsecret=".S::sqlEscape($conuinsecret).", conopenid=".S::sqlEscape($conopenid).", conispublishfeed=".S::sqlEscape($conispublishfeed).", conispublisht=".S::sqlEscape($conispublisht).", conisregister='0', conisfeed=".S::sqlEscape($user_auth_fields)." WHERE uid=".S::sqlEscape($winduid));
			} else {
				$db->query("UPDATE pw_member_connect SET conispublishfeed=".S::sqlEscape($conispublishfeed).", conispublisht=".S::sqlEscape($conispublisht).", conisregister='0', conisfeed=".S::sqlEscape($user_auth_fields)." WHERE uid=".S::sqlEscape($winduid));
			}
		} else {
			$db->query("INSERT INTO pw_member_connect (uid, conuin, conuinsecret, conopenid, conispublishfeed, conispublisht, conisregister, conisfeed) VALUES (".S::sqlEscape($winduid).", ".S::sqlEscape($conuin).", ".S::sqlEscape($conuinsecret).", ".S::sqlEscape($conopenid).", ".S::sqlEscape($conispublishfeed).", ".S::sqlEscape($conispublisht).", '0', ".S::sqlEscape($user_auth_fields).")");
		}
		$db->query("UPDATE pw_members SET conisbind='1' WHERE uid=".S::sqlEscape($winduid));

		Cookie('connect_js_name', 'user_bind', $timestamp + 86400);
		Cookie('connect_js_params', base64_encode(serialize(array('type' => 'loginbind'))), $timestamp + 86400);
		Cookie('connect_login', 1, $timestamp + 31536000);
		Cookie('connect_is_bind', '1', $timestamp + 31536000);
		Cookie('connect_uin', $conopenid, $timestamp + 31536000);
		if($is_feed) {
			Cookie('connect_synpost_tip', 1, $timestamp + 31536000);
		}
		$db->query("INSERT INTO pw_connect_memberbindlog (uid, uin, type, dateline) VALUES ('$winduid', '$conopenid', '1', '$timestamp')");

		refreshto($referer, getLangInfo('connect', 'connect_register_bind_success', '', true));

	} else {

		if($connect_member) {
			if(empty($connect_member['conuinsecret']) || empty($connect_member['conopenid']) || $connect_member['conuinsecret'] != $conuinsecret) {
				$db->update("UPDATE pw_member_connect SET conuin='$conuin', conuinsecret='$conuinsecret', conopenid='$conopenid', conispublishfeed='$conispublishfeed', conispublisht='$conispublisht', conisfeed='$user_auth_fields' WHERE uid='$connect_member[uid]'");
			} else {
				$db->update("UPDATE pw_member_connect SET conisfeed='$user_auth_fields' WHERE uid='$connect_member[uid]'");
			}

			$params['mod'] = 'login';
			list($winduid, $groupid, $windpwd, $showmsginfo) = processLogin($connect_member['uid']);

			require_once(file_exists(D_P."data/groupdb/group_$groupid.php") ? Pcv(D_P."data/groupdb/group_$groupid.php") : D_P."data/groupdb/group_1.php");
			Loginipwrite($winduid);

			if(GetCookie('o_invite') && $db_modes['o']['ifopen'] == 1) {
				list($o_u,$hash,$app) = explode("\t",GetCookie('o_invite'));
				if (is_numeric($o_u) && strlen($hash) == 18) {
					require_once(R_P.'require/o_invite.php');
				}
			}
			$jumpurl = isset($sessionInfo['sessiondata']['httpReferer']) ? $sessionInfo['sessiondata']['httpReferer'] : $db_bfn;
			//passport
			if ($db_pptifopen && $db_ppttype == 'server' && ($db_ppturls || $forward)) {
				$tmp = $jumpurl;
				$jumpurl = $forward ? $forward : $db_ppturls;
				$forward = $tmp;
				require_once(R_P.'require/passport_server.php');
			}
			//passport

			refreshto($referer, 'have_login');

		} else {
			$encode[] = authcode($conuin, 'ENCODE');
			$encode[] = authcode($conuinsecret, 'ENCODE');
			$encode[] = authcode($conopenid, 'ENCODE');
			$encode[] = authcode($user_auth_fields, 'ENCODE');
			$auth_hash = authcode(implode('|', $encode), 'ENCODE');
			Cookie('con_auth_hash', $auth_hash);

			unset($params['op']);
			$params['mod'] = 'register';
			$params['referer'] = $referer;
			$params['con_auth_hash'] = $auth_hash;
			unset($params['con_oauth_token']);
			unset($params['con_oauth_verifier']);

			$redirect = 'connect.php?'.cloud_http_build_query($params, '', '&');
			ObHeader($redirect);
		}
	}

} elseif($op == 'change') {

	Cookie('con_request_token');
	Cookie('con_request_token_secret');

	$response = connect_get_request_token();
	if(!isset($response['status']) || $response['status'] !== 0) {
		connect_errlog($response['status'], $response['result']);
		refreshto($referer, getLangInfo('connect', 'connect_get_request_token_failed', '', true));
	}

	$request_token = $response['result']['oauth_token'];
	$request_token_secret = $response['result']['oauth_token_secret'];

	Cookie('con_request_token', $request_token);
	Cookie('con_request_token_secret', $request_token_secret);

	$params = array(
		'oauth_token' => $request_token,
		'oauth_consumer_key' => $connect_settings['connectappid']
	);

	$redirect = $connect['url'] . '/discuz/login?'.cloud_http_build_query($params, '', '&');
	ObHeader($redirect);
} elseif($op == 'bind') {
	InitGP(array('step'));
	if(2 == $step) {
		PostCheck(0,$db_gdcheck & 2,$loginq,0);
		require_once(R_P . 'require/checkpass.php');

		InitGP(array('pwuser','pwpwd','question','customquest','answer','cktime','hideid','jumpurl','lgt','keepyear'),'P');
		if (!$pwuser || !$pwpwd) Showmsg('login_empty');

		$loginUser = array('username' => $pwuser, 'password' => md5($pwpwd));
		$loginUser['safecv'] = $db_ifsafecv ? questcode($question, $customquest, $answer) : '';

		$logininfo = checkpass($loginUser['username'], $loginUser['password'], $loginUser['safecv'], $lgt);
		if(!is_array($logininfo)) {
			Showmsg($logininfo);
		}
		list($winduid, , $windpwd, ) = $logininfo;

		$conisbind = $db->get_value("SELECT conisbind FROM pw_members WHERE uid='$winduid'");
		if($conisbind) {
			Showmsg(getLangInfo('connect', 'connect_register_bind_already', '', true));
		}

		InitGP(array('auth_hash', 'is_feed', 'is_notify'));
		$auth_code = authcode($auth_hash);
		$auth_code = explode('|', authcode($auth_hash));
		$conuin = authcode($auth_code[0]);
		$conuinsecret = authcode($auth_code[1]);
		$conopenid = authcode($auth_code[2]);
		$user_auth_fields = authcode($auth_code[3]);

		$conispublishfeed = $conispublisht = 0;
		if($is_feed) {
			$conispublishfeed = $conispublisht = 1;
		}

		if($conuin && $conuinsecret && $conopenid) {
			$connect_member = $db->get_one("SELECT uid FROM pw_member_connect WHERE uid='$winduid'");
			if($connect_member) {
				$db->query("UPDATE pw_member_connect SET conuin='$conuin', conuinsecret='$conuinsecret', conopenid='$conopenid', conispublishfeed='$conispublishfeed', conispublisht='$conispublisht', conisregister='0', conisqzoneavatar='0', conisfeed='$user_auth_fields' WHERE uid='$winduid'");
			} else {
				$db->query("INSERT INTO pw_member_connect (uid, conuin, conuinsecret, conopenid, conispublishfeed, conispublisht, conisregister, conisqzoneavatar, conisfeed) VALUES ('$winduid', '$conuin', '$conuinsecret', '$conopenid', '$conispublishfeed', '$conispublisht', '0', '0', '$user_auth_fields')");
			}
			$db->query("UPDATE pw_members SET conisbind='1' WHERE uid='$winduid'");
			$db->query("INSERT INTO pw_connect_memberbindlog (uid, uin, type, dateline) VALUES ('$winduid', '$conopenid', '1', '$timestamp')");

			Cookie('connect_js_name', 'user_bind', $timestamp + 86400);
			Cookie('connect_js_params', base64_encode(serialize(array('type' => 'registerbind'))), $timestamp + 86400);
			Cookie('connect_login', 1, $timestamp + 31536000);
			Cookie('connect_is_bind', '1', $timestamp + 31536000);
			Cookie('connect_uin', $conopenid, $timestamp + 31536000);
			if($is_feed) {
				Cookie('connect_synpost_tip', 1, $timestamp + 31536000);
			}

			list($winduid, $groupid, $windpwd, $showmsginfo) = processLogin(null, $loginUser, $cktime, $lgt);

			require_once(file_exists(D_P."data/groupdb/group_$groupid.php")
				? Pcv(D_P."data/groupdb/group_$groupid.php") : D_P."data/groupdb/group_1.php");
			($_G['allowhide'] && $hideid) ? Cookie('hideid',"1",$cktime) : Loginipwrite($winduid);

			if (GetCookie('o_invite') && $db_modes['o']['ifopen'] == 1) {
				list($o_u,$hash,$app) = explode("\t",GetCookie('o_invite'));
				if (is_numeric($o_u) && strlen($hash) == 18) {
					require_once(R_P.'require/o_invite.php');
				}
			}
			if (empty($jumpurl) || false !== strpos($jumpurl, $regurl)) {
				$jumpurl = isset($sessionInfo['sessiondata']['httpReferer']) ? $sessionInfo['sessiondata']['httpReferer'] : $db_bfn;
			}
			//passport
			if ($db_pptifopen && $db_ppttype == 'server' && ($db_ppturls || $forward)) {
				$tmp = $jumpurl;
				$jumpurl = $forward ? $forward : $db_ppturls;
				$forward = $tmp;
				require_once(R_P.'require/passport_server.php');
			}
			//passport

			refreshto($jumpurl, 'have_login');
		} else {
			refreshto(dreferer(), getLangInfo('connect', 'connect_get_access_token_failed', '', true));
		}
	}
}
?>