<?php
require '../../class/class_core.php';
require_once '../../function/function_cache.php';
if(!defined('IN_DISCUZ')) {
	exit('Access Denied');
}
class easy_toolabr{
    protected $discuz;
    public function __construct($input) {
        $discuz = & discuz_core::instance();
        $discuz->init();
        $this->discuz=$discuz;
        header("Content-type: text/html; charset=utf-8");
        global $_G;
        loadcache('plugin');
        $groupid=$_G['groupid'];
        $api='api_'.$input['action'];
        $groups=unserialize($_G['cache']['plugin']['easy_toolbar_dzx'][$api]); 
        if(is_array($groups) && !empty($groups) && $groups[0]!=''){
            if(!in_array($groupid, $groups)){
                var_dump($groups);
                var_dump($groupid);
                exit;
            }
        }
    }
    
    public function versionAction(){
        exit('0.5');
    }
    
    public function memberAction(){
        global $_G;
        $member=$this->array2utf8($_G['member']);
        $rs=array('uid'=>$member['uid'],'username'=>$member['username'],'adminid'=>$member['adminid'],'groupid'=>$member['groupid']);
        echo json_encode($rs);
    }
    
    
    public function threadsAction($input){
        header('Content-type: application/json');
        $all=isset($input['all'])?intval($input['all']):0;
        $special=isset($input['special'])?$input['special']:array();
        $forums=isset($input['forums'])?$input['forums']:array();
        $page=isset($input['page'])?intval($input['page']):1;
        $rows=isset($input['rows'])?intval($input['rows']):10;
        $notify=isset($input['notify'])?intval($input['notify']):0;
        $start=($page-1)*$rows;
        $where='';
        if(!$all){
            if(!empty($special)){
                foreach($special as $key=>$value){
                    $special[$key]=intval($value);
                }
                $special= implode(',', $special);
                $where = $where ? $where.' OR ' : ' WHERE ';
                $where.='special in ('.$special.')';
            }
            if(!empty($forums)){
                foreach($forums as $key=>$value){
                    $forums[$key]=intval($value);
                }                
                $forums = implode(',', $forums);
                $where = $where ? $where.' OR ' : ' WHERE ';
                $where.='fid in ('.$forums.')';               
            }
        }
        if($notify){
            $time=time();
            $time=$time-$notify;
            $notifyWhere=" P.dateline > ".$time;
            if(!$where){
                $where=' WHERE '.$notifyWhere;
            }else{
                $where.= ' AND '.$notifyWhere;
            }
        }
        $sql="SELECT T.tid,T.subject,P.pid,P.message,P.dateline,P.author
            FROM ".DB::table('forum_post')." AS P 
            LEFT JOIN ".DB::table('forum_thread')
            ." AS T ON P.tid=T.tid ".
            $where."
            ORDER BY P.pid DESC
            LIMIT ".$start.','.$rows;
        //var_dump($sql);exit;
        $query = DB::query($sql);

        $rs=array();
        while($row=DB::fetch($query)){
            $rs[]=array(
                'id'=>$row['pid'],
                'cell'=>array($row['tid'],  strip_tags($row['subject']),strip_tags($row['message']),strip_tags($row['author']))
                //'cell'=>array('tid'=>$row['tid'],'subject'=>$row['subject'],'message'=>$row['message'],'auth'=>$row['auth'])
            );
        }
        $query = DB::query("SELECT count(*)
            FROM ".DB::table('forum_thread')." AS T 
            LEFT JOIN ".DB::table('forum_post')
            ." AS P ON T.tid=P.tid "
            .$where);
        $records=DB::fetch($query);
        $records=array_pop($records);
        $total=ceil($records/$rows);
    $rs=$this->array2utf8($rs);
    $rs=array(
        'page'=>$page,
        'total'=>$total,
        'records'=>$records,
        'rows'=>$rs
    );
    
    $json= $this->jsonEncode($rs);
    $string=$input['callback'].'('.$json.')';
    echo $string;
    }
    
    public function forumsAction(){
        $query = DB::query("SELECT fid,name
            FROM ".DB::table('forum_forum')." WHERE type<>'group' AND status=1");
        $rs=array();
        while($row=DB::fetch($query)){
            $row['name']=strip_tags($row['name']);
            $rs[]=$row;
        }
        $rs=$this->array2utf8($rs);
        $json=$this->jsonEncode($rs);
        $string=$_GET['callback'].'('.$json.')';
        echo $string;
    }
    
    public function chatoutAction($input){
        global $_G;        
        $tid=isset($input['tid'])?intval($input['tid']):0;
        if(!$tid){
            return;
        }
        if(!$_G['member']['uid']){
            echo '您还没有登录！';
            return;
        }
        if($_G['member']['adminid']<0){
            echo '您没有发贴权限!';
            return;
        }        
        $sql='SELECT * FROM '.DB::table('forum_post').' WHERE tid='.$tid.' ORDER BY pid DESC LIMIT 20';
        $query=DB::query($sql);
        
        $string='';
        while($row=DB::fetch($query)){
            $row=$this->array2utf8($row);
            $stringTemp='';
            $stringTemp.='<strong>'.$row['author'].'&nbsp;&nbsp;'.date('h:i:s',$row['dateline']).'</strong><br/>';
            $message=$row['message'];
            $stringTemp.='<div class="message">'.$message.'</div>';
            $string=$stringTemp.$string;
        }
        echo $string;
        exit;
    }
    
    public function chatinAction($input){
        global $_G;
        $row['tid']=isset($input['tid'])?intval($input['tid']):0;
        $row['message']=isset($input['message'])?$input['message']:'';
        if(!$row['tid'] or !$row['message']){
            return;
        }
        if(!$_G['member']['uid']){
            echo '您还没有登录！';
            echo '您还没有登录！';
            return;
        }
        if($_G['member']['adminid']<0){
            echo '您没有发贴权限!';
            return;
        }
        $row['authorid']=$_G['member']['uid'];
        $row['author']=$_G['member']['username'];
        $row['useip']=$_G['clientip'];
        $row['dateline']=$_G['timestamp'];
        
        $row['first']=0;
        $row['subject']='';
        $row['bbcodeoff']=-1;
        $row['smileyoff']=-1;
        $sql="SELECT fid FROM ".DB::table('forum_thread')." WHERE tid=".$row['tid'];
        $query=DB::query($sql);
        $fidRow=DB::fetch($query);
        $row['fid']=$fidRow['fid'];
        $row=$this->utf82other($row);
        $this->insert($row,DB::table('forum_post')); 
    }
    
    private function insert($row,$table){
        $sql="INSERT INTO ".$table." (fid,tid,first,author,authorid,subject,dateline,message,useip,bbcodeoff,smileyoff) VALUES ({$row['fid']},{$row['tid']},{$row['first']},'{$row['author']}',{$row['authorid']},'{$row['subject']}','{$row['dateline']}','{$row['message']}','{$row['useip']}','{$row['bbcodeoff']}','{$row['smileyoff']}')";
        DB::query($sql);
    }
    
    private function string2utf8($string){
        global $_G;       
        if($_G['charset'] == 'utf-8'){
            return $string;
        }else{
            return mb_convert_encoding($string,'UTF-8',$_G['charset']);
        }
    }
    
    private function array2utf8($array){
        global $_G;
        if($_G['charset'] == 'utf-8'){
            return $array;
        }
        foreach($array as $key=>$value){
                if(is_string($value)){
                    $array[$key]=mb_convert_encoding($value,'UTF-8',$_G['charset']);
                }elseif(is_array($value)){
                    $array[$key]=$this->array2utf8($value);
                }
        }
        return $array;
    }
    
    private function utf82other($array){
        global $_G;
        if($_G['charset'] == 'utf-8'){
            return $array;
        }
        foreach($array as $key=>$value){
                if(is_string($value)){
                    $array[$key]=mb_convert_encoding($value,$_G['charset'],'UTF-8');
                }elseif(is_array($value)){
                    $array[$key]=$this->array2utf8($value);
                }
        }
        return $array;        
    }
    
    private function jsonEncode($var) {
    if (function_exists('json_encode')) {
        return json_encode($var);
    } else {
        switch (gettype($var)) {
            case 'boolean':
                return $var ? 'true' : 'false'; // Lowercase necessary!
            case 'integer':
            case 'double':
                return $var;
            case 'resource':
            case 'string':
                return '"'. str_replace(array("\r", "\n", "<", ">", "&"),
                    array('\r', '\n', '\x3c', '\x3e', '\x26'),
                    addslashes($var)) .'"';
            case 'array':
                // Arrays in JSON can't be associative. If the array is empty or if it
                // has sequential whole number keys starting with 0, it's not associative
                // so we can go ahead and convert it as an array.
                if (empty ($var) || array_keys($var) === range(0, sizeof($var) - 1)) {
                    $output = array();
                    foreach ($var as $v) {
                        $output[] = $this->encode($v);
                    }
                    return '[ '. implode(', ', $output) .' ]';
                }
                // Otherwise, fall through to convert the array as an object.
            case 'object':
                $output = array();
                foreach ($var as $k => $v) {
                    $output[] = $this->encode(strval($k)) .': '. $this->encode($v);
                }
                return '{ '. implode(', ', $output) .' }';
            default:
                return 'null';
    }}}
}