/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.scripting.Namespace;
import org.zkoss.zk.scripting.Namespaces;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Grid;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelExt;
import org.zkoss.zul.impl.HeaderElement;

public class Column
extends HeaderElement {
    private String _sortDir = "natural";
    private Comparator _sortAsc;
    private Comparator _sortDsc;

    public Column() {
    }

    public Column(String label) {
        this.setLabel(label);
    }

    public Column(String label, String src) {
        this.setLabel(label);
        this.setImage(src);
    }

    public Grid getGrid() {
        Component parent = this.getParent();
        return parent != null ? (Grid)parent.getParent() : null;
    }

    public String getSortDirection() {
        return this._sortDir;
    }

    public void setSortDirection(String sortDir) throws WrongValueException {
        if (sortDir == null || !"ascending".equals(sortDir) && !"descending".equals(sortDir) && !"natural".equals(sortDir)) {
            throw new WrongValueException("Unknown sort direction: " + sortDir);
        }
        if (!Objects.equals((Object)this._sortDir, (Object)sortDir)) {
            this._sortDir = sortDir;
            this.smartUpdate("z.sort", this._sortDir);
        }
    }

    public Comparator getSortAscending() {
        return this._sortAsc;
    }

    public void setSortAscending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortAsc, (Object)sorter)) {
            if (sorter == null) {
                this.smartUpdate("z.asc", null);
            } else if (this._sortAsc == null) {
                this.smartUpdate("z.asc", "true");
            }
            this._sortAsc = sorter;
        }
    }

    public void setSortAscending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.setSortAscending(this.toComparator(clsnm));
    }

    public Comparator getSortDescending() {
        return this._sortDsc;
    }

    public void setSortDescending(Comparator sorter) {
        if (!Objects.equals((Object)this._sortDsc, (Object)sorter)) {
            if (sorter == null) {
                this.smartUpdate("z.dsc", null);
            } else if (this._sortDsc == null) {
                this.smartUpdate("z.dsc", "true");
            }
            this._sortDsc = sorter;
        }
    }

    public void setSortDescending(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.setSortDescending(this.toComparator(clsnm));
    }

    private Comparator toComparator(String clsnm) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class cls;
        if (clsnm == null || clsnm.length() == 0) {
            return null;
        }
        Page page = this.getPage();
        Class clazz = cls = page != null ? page.getZScriptClass(clsnm) : Classes.forNameByThread((String)clsnm);
        if (cls == null) {
            throw new ClassNotFoundException(clsnm);
        }
        if (!Comparator.class.isAssignableFrom(cls)) {
            throw new UiException("Comparator must be implemented: " + clsnm);
        }
        return (Comparator)cls.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sort(boolean ascending) {
        Comparator cmpr;
        String dir = this.getSortDirection();
        if (ascending ? "ascending".equals(dir) : "descending".equals(dir)) {
            return false;
        }
        Comparator comparator = cmpr = ascending ? this._sortAsc : this._sortDsc;
        if (cmpr == null) {
            return false;
        }
        Grid grid = this.getGrid();
        if (grid == null) {
            return false;
        }
        HashMap backup = new HashMap();
        Namespace ns = Namespaces.beforeInterpret(backup, (Component)this, (boolean)true);
        try {
            ListModel model = grid.getModel();
            if (model != null) {
                if (!(model instanceof ListModelExt)) {
                    throw new UiException("ListModelExt must be implemented in " + model.getClass().getName());
                }
                ((ListModelExt)((Object)model)).sort(cmpr, ascending);
            } else {
                Components.sort((List)grid.getRows().getChildren(), (Comparator)cmpr);
            }
        }
        finally {
            Namespaces.afterInterpret(backup, (Namespace)ns, (boolean)true);
        }
        Iterator it = grid.getColumns().getChildren().iterator();
        while (it.hasNext()) {
            Column hd;
            hd.setSortDirection((hd = (Column)((Object)it.next())) != this ? "natural" : (ascending ? "ascending" : "descending"));
        }
        return true;
    }

    public boolean sort(boolean ascending, boolean force) {
        if (force) {
            this.setSortDirection("natural");
        }
        return this.sort(ascending);
    }

    public void onSort() {
        String dir = this.getSortDirection();
        if ("ascending".equals(dir)) {
            this.sort(false);
        } else if ("descending".equals(dir)) {
            this.sort(true);
        } else if (!this.sort(true)) {
            this.sort(false);
        }
    }

    public String getSclass() {
        String scls = super.getSclass();
        if (scls != null) {
            return scls;
        }
        return this._sortAsc != null || this._sortDsc != null ? "sort" : null;
    }

    public String getOuterAttrs() {
        String clkattrs;
        StringBuffer sb = new StringBuffer(80);
        if (this._sortAsc != null) {
            sb.append(" z.asc=\"true\"");
        }
        if (this._sortDsc != null) {
            sb.append(" z.dsc=\"true\"");
        }
        if (!"natural".equals(this._sortDir)) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sort", (String)this._sortDir);
        }
        if ((clkattrs = this.getAllOnClickAttrs(false)) != null) {
            sb.append(clkattrs);
        }
        String attrs = super.getOuterAttrs();
        if (sb.length() == 0) {
            return attrs;
        }
        return sb.insert(0, attrs).toString();
    }

    protected void invalidateWhole() {
        Grid grid = this.getGrid();
        if (grid != null) {
            grid.invalidate();
        }
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Columns)) {
            throw new UiException("Unsupported parent for column: " + parent);
        }
        super.setParent(parent);
    }
}

