/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zk.ui.ext.render.ChildChangedAware;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.ComboitemRenderer;
import org.zkoss.zul.ComboitemRendererExt;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.impl.InputElement;

public class Combobox
extends Textbox {
    private static final Log log = Log.lookup((Class)Combobox.class);
    private static final String DEFAULT_IMAGE = "~./zul/img/combobtn.gif";
    private String _img;
    private boolean _autodrop;
    private boolean _autocomplete;
    private boolean _btnVisible = true;
    private transient Comboitem _selItem;
    private ListModel _model;
    private ComboitemRenderer _renderer;
    private transient ListDataListener _dataListener;
    private transient EventListener _eventListener;
    private static final ComboitemRenderer _defRend = new ComboitemRenderer(){

        public void render(Comboitem item, Object data) {
            item.setLabel(Objects.toString((Object)data));
            item.setValue(data);
        }
    };

    public Combobox() {
        this.setSclass("combobox");
    }

    public Combobox(String value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    protected String coerceToString(Object value) {
        Constraint constr = this.getConstraint();
        String val = super.coerceToString(value);
        if (val.length() > 0 && constr != null && constr instanceof SimpleConstraint && (((SimpleConstraint)constr).getFlags() & 0x200) != 0) {
            Iterator it = this.getItems().iterator();
            while (it.hasNext()) {
                String label = ((Comboitem)((Object)it.next())).getLabel();
                if (!val.equalsIgnoreCase(label)) continue;
                return label;
            }
        }
        return val;
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                } else if (!this.getItems().isEmpty()) {
                    this.getItems().clear();
                }
                this.initDataListener();
                this._model = model;
                this._model.addListDataListener(this._dataListener);
                if (model instanceof ListSubModel) {
                    this.addEventListener("onChanging", this._eventListener);
                }
            }
            this.postOnInitRender(null);
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            if (this._model instanceof ListSubModel) {
                this.removeEventListener("onChanging", this._eventListener);
            }
            this._model = null;
            if (!this.getItems().isEmpty()) {
                this.getItems().clear();
            }
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Combobox.this.postOnInitRender(null);
                }
            };
        }
        if (this._eventListener == null) {
            this._eventListener = new EventListener(){

                public void onEvent(Event event) throws Exception {
                    InputEvent ie;
                    if (Combobox.this.getModel() instanceof ListSubModel && !(ie = (InputEvent)event).isChangingBySelectBack()) {
                        Combobox.this.postOnInitRender(ie.getValue());
                    }
                }
            };
        }
    }

    public ComboitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ComboitemRenderer renderer) {
        this._renderer = renderer;
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ComboitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    private ListModel syncModel(String index) {
        ComboitemRenderer renderer = null;
        ListModel subset = this._model instanceof ListSubModel ? ((ListSubModel)((Object)this._model)).getSubModel(index, -1) : this._model;
        int newsz = subset.getSize();
        if (!this.getItems().isEmpty()) {
            this.getItems().clear();
        }
        for (int j = 0; j < newsz; ++j) {
            if (renderer == null) {
                renderer = this.getRealRenderer();
            }
            this.newUnloadedItem(renderer).setParent((Component)this);
        }
        return subset;
    }

    private final Comboitem newUnloadedItem(ComboitemRenderer renderer) {
        Comboitem item = null;
        if (renderer instanceof ComboitemRendererExt) {
            item = ((ComboitemRendererExt)((Object)renderer)).newComboitem(this);
        }
        if (item == null) {
            item = new Comboitem();
            item.applyProperties();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender(Event data) {
        Renderer renderer = new Renderer();
        ListModel subset = this.syncModel(data.getData() != null ? (String)data.getData() : this.getValue());
        try {
            int pgsz = subset.getSize();
            int ofs = 0;
            ListIterator it = this.getItems().listIterator(ofs);
            for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                renderer.render(subset, (Comboitem)((Object)it.next()));
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onInitRenderLater", (Component)this, null);
    }

    private void postOnInitRender(String idx) {
        Events.postEvent((String)"onInitRender", (Component)this, (Object)idx);
    }

    private static final ComboitemRenderer getDefaultItemRenderer() {
        return _defRend;
    }

    private ComboitemRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : Combobox.getDefaultItemRenderer();
    }

    public boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("z.adr", autodrop);
        }
    }

    public boolean isAutocomplete() {
        return this._autocomplete;
    }

    public void setAutocomplete(boolean autocomplete) {
        if (this._autocomplete != autocomplete) {
            this._autocomplete = autocomplete;
            this.smartUpdate("z.aco", autocomplete);
        }
    }

    public void setOpen(boolean open) {
        if (open) {
            this.open();
        } else {
            this.close();
        }
    }

    public void open() {
        this.response("dropdn", (AuResponse)new AuInvoke((Component)this, "dropdn", true));
    }

    public void close() {
        this.response("dropdn", (AuResponse)new AuInvoke((Component)this, "dropdn", false));
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("z.btnVisi", visible);
        }
    }

    public String getImage() {
        return this._img != null ? this._img : DEFAULT_IMAGE;
    }

    public void setImage(String img) {
        if (img != null && (img.length() == 0 || DEFAULT_IMAGE.equals(img))) {
            img = null;
        }
        if (!Objects.equals((Object)this._img, (Object)img)) {
            this._img = img;
            this.invalidate();
        }
    }

    public List getItems() {
        return this.getChildren();
    }

    public int getItemCount() {
        return this.getItems().size();
    }

    public Comboitem getItemAtIndex(int index) {
        return (Comboitem)((Object)this.getItems().get(index));
    }

    public Comboitem appendItem(String label) {
        Comboitem item = new Comboitem(label);
        item.setParent((Component)this);
        return item;
    }

    public Comboitem removeItemAt(int index) {
        Comboitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public Comboitem getSelectedItem() {
        return this._selItem;
    }

    public void setSelectedItem(Comboitem item) {
        this.setSelectedIndex(this.getItems().indexOf((Object)item));
    }

    public void setSelectedIndex(int jsel) {
        if (jsel >= this.getItemCount()) {
            throw new UiException("Out of bound: " + jsel + " while size=" + this.getItemCount());
        }
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel < 0) {
            this._selItem = null;
            this.setValue("");
        } else {
            this._selItem = this.getItemAtIndex(jsel);
            this.setValue(this._selItem.getLabel());
        }
    }

    public int getSelectedIndex() {
        return this._selItem != null ? this.getItems().indexOf((Object)this._selItem) : -1;
    }

    public void setMultiline(boolean multiline) {
        if (multiline) {
            throw new UnsupportedOperationException("Combobox doesn't support multiline");
        }
    }

    public void setRows(int rows) {
        if (rows != 1) {
            throw new UnsupportedOperationException("Combobox doesn't support multiple rows, " + rows);
        }
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        boolean aco = this.isAutocomplete();
        boolean adr = this.isAutodrop();
        if (!(this.isAsapRequired("onOpen") || this.isAsapRequired("onSelect") || aco || adr)) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        this.appendAsapAttr(sb, "onOpen");
        this.appendAsapAttr(sb, "onSelect");
        if (aco) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.aco", (String)"true");
        }
        if (adr) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.adr", (String)"true");
        }
        return sb.toString();
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        String style = this.getInnerStyle();
        return style.length() > 0 ? attrs + " style=\"" + style + '\"' : attrs;
    }

    private String getInnerStyle() {
        StringBuffer sb = new StringBuffer(32).append(HTMLs.getTextRelevantStyle((String)this.getRealStyle()));
        HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)this.getWidth());
        HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)this.getHeight());
        return sb.toString();
    }

    protected int getRealStyleFlags() {
        return super.getRealStyleFlags() | 1 | 2;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (!(newChild instanceof Comboitem)) {
            throw new UiException("Unsupported child for Combobox: " + newChild);
        }
        return super.insertBefore(newChild, refChild);
    }

    public boolean isChildable() {
        return true;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this.smartUpdate("repos", "true");
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this.smartUpdate("repos", "true");
    }

    final void reIndex() {
        String value = this.getValue();
        if (this._selItem == null || !Objects.equals((Object)value, (Object)this._selItem.getLabel())) {
            this._selItem = null;
            Iterator it = this.getItems().iterator();
            while (it.hasNext()) {
                Comboitem item = (Comboitem)((Object)it.next());
                if (!Objects.equals((Object)value, (Object)item.getLabel())) continue;
                this._selItem = item;
                break;
            }
        }
    }

    public Object clone() {
        int idx = this.getSelectedIndex();
        Combobox clone = (Combobox)super.clone();
        clone._selItem = idx > -1 && clone.getItemCount() > idx ? clone.getItemAtIndex(idx) : null;
        return clone;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.getSelectedIndex());
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int idx = s.readInt();
        if (idx > -1 && this.getItemCount() > idx) {
            this._selItem = this.getItemAtIndex(idx);
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends InputElement.ExtraCtrl
    implements ChildChangedAware,
    Selectable {
        protected ExtraCtrl() {
            super(Combobox.this);
        }

        public boolean isChildChangedAware() {
            return true;
        }

        public void selectItemsByClient(Set selItems) {
            Combobox.this._selItem = selItems != null && !selItems.isEmpty() ? (Comboitem)((Object)selItems.iterator().next()) : null;
        }
    }

    private class Renderer
    implements Serializable {
        private final ComboitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Combobox.this.getRealRenderer();
        }

        private void render(ListModel subset, Comboitem item) throws Throwable {
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            try {
                this._renderer.render(item, subset.getElementAt(Combobox.this.getItems().indexOf((Object)item)));
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error(t);
                }
                throw ex;
            }
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

