/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.impl.LabelImageElement;

public class Comboitem
extends LabelImageElement {
    private String _desc = "";
    private Object _value;
    private String _content = "";
    private boolean _disabled = false;

    public Comboitem() {
        this.setSclass("item");
    }

    public Comboitem(String label) {
        this();
        this.setLabel(label);
    }

    public Comboitem(String label, String image) {
        this();
        this.setLabel(label);
        this.setImage(image);
    }

    public String getSclass() {
        String scls = super.getSclass();
        if (this.isDisabled()) {
            return scls.length() > 0 ? scls + " disd" : "disd";
        }
        return scls;
    }

    public void setLabel(String label) {
        String old = this.getLabel();
        if (!Objects.equals((Object)old, (Object)label)) {
            Combobox cb = (Combobox)this.getParent();
            boolean reIndex = cb != null && cb.getSelectedItem() == this;
            super.setLabel(label);
            if (reIndex) {
                Constraint constr = cb.getConstraint();
                if (constr != null && constr instanceof SimpleConstraint && (((SimpleConstraint)constr).getFlags() & 0x200) != 0) {
                    cb.setValue(label);
                } else {
                    cb.reIndex();
                }
            }
        }
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.invalidate();
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public String getDescription() {
        return this._desc;
    }

    public void setDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        if (!this._desc.equals(desc)) {
            this._desc = desc;
            this.invalidate();
        }
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content == null) {
            content = "";
        }
        if (!Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this.invalidate();
        }
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Combobox)) {
            throw new UiException("Comboitem's parent must be Combobox");
        }
        Combobox old = (Combobox)this.getParent();
        boolean reIndex = parent != old && old != null && old.getSelectedItem() == this;
        super.setParent(parent);
        if (reIndex) {
            this.postOnReIndex(old);
        }
    }

    private void postOnReIndex(Combobox old) {
        Events.postEvent((String)"onReIndex", (Component)this, (Object)old);
    }

    public void onReIndex(Event evt) {
        Combobox cb = (Combobox)evt.getData();
        if (cb != null) {
            cb.reIndex();
        }
    }

    public boolean isChildable() {
        return false;
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(60).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disd", (boolean)this.isDisabled());
        return sb.toString();
    }
}

