/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.client.InnerWidth;
import org.zkoss.zk.ui.ext.client.RenderOnDemand;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Foot;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Paging;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.RowRendererExt;
import org.zkoss.zul.Rows;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.XulElement;

public class Grid
extends XulElement {
    private static final Log log;
    private transient Rows _rows;
    private transient Columns _cols;
    private transient Foot _foot;
    private transient Collection _heads;
    private String _align;
    private ListModel _model;
    private RowRenderer _renderer;
    private transient ListDataListener _dataListener;
    private transient Paginal _pgi;
    private transient Paging _paging;
    private transient EventListener _pgListener;
    private transient EventListener _pgImpListener;
    private String _scOddRow = "odd";
    private int _preloadsz = 7;
    private String _innerWidth = "100%";
    private static final RowRenderer _defRend;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Grid() {
        this.setSclass("grid");
        this.init();
    }

    private void init() {
        this._heads = new AbstractCollection(){

            public int size() {
                int sz = Grid.this.getChildren().size();
                if (Grid.this._rows != null) {
                    --sz;
                }
                if (Grid.this._foot != null) {
                    --sz;
                }
                if (Grid.this._paging != null) {
                    --sz;
                }
                return sz;
            }

            public Iterator iterator() {
                return new Iter();
            }
        };
    }

    public Rows getRows() {
        return this._rows;
    }

    public Columns getColumns() {
        return this._cols;
    }

    public Foot getFoot() {
        return this._foot;
    }

    public Collection getHeads() {
        return this._heads;
    }

    public Component getCell(int row, int col) {
        Rows rows = this.getRows();
        if (rows == null) {
            return null;
        }
        List children = rows.getChildren();
        if (children.size() <= row) {
            return null;
        }
        return (children = ((Row)((Object)children.get(row))).getChildren()).size() <= col ? null : (Component)children.get(col);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this._rows != null ? this._rows.getChildren().size() : 0);
                    this.addPagingListener(this._pgi);
                }
            }
        }
    }

    private void newInternalPaging() {
        if (!$assertionsDisabled && !this.inPagingMold()) {
            throw new AssertionError((Object)"paging mold only");
        }
        if (!($assertionsDisabled || this._paging == null && this._pgi == null)) {
            throw new AssertionError();
        }
        Paging paging = new Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        paging.setTotalSize(this._rows != null ? this._rows.getChildren().size() : 0);
        paging.setParent((Component)this);
        this.addPagingListener(this._pgi);
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new EventListener(){

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Grid.this, evt.getPageable(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._pgImpListener == null) {
            this._pgImpListener = new EventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(Event event) {
                    if (Grid.this._rows != null && Grid.this._model != null && Grid.this.inPagingMold()) {
                        Renderer renderer = new Renderer();
                        try {
                            Paginal pgi = Grid.this.getPaginal();
                            int pgsz = pgi.getPageSize();
                            int ofs = pgi.getActivePage() * pgsz;
                            ListIterator it = Grid.this._rows.getChildren().listIterator(ofs);
                            while (--pgsz >= 0 && it.hasNext()) {
                                renderer.render((Row)((Object)it.next()));
                            }
                        }
                        catch (Throwable ex) {
                            renderer.doCatch(ex);
                        }
                        finally {
                            renderer.doFinally();
                        }
                    }
                    if (Grid.this._rows != null) {
                        Grid.this._rows.invalidate();
                    }
                }
            };
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public Paging getPaging() {
        return this._paging;
    }

    public int getPageSize() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi.getPageSize();
    }

    public void setPageSize(int pgsz) {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        this._pgi.setPageSize(pgsz);
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                } else {
                    if (this._rows != null) {
                        this._rows.getChildren().clear();
                    }
                    this.smartUpdate("z.model", "true");
                }
                this.initDataListener();
                this._model = model;
                this._model.addListDataListener(this._dataListener);
            }
            this.syncModel(-1, -1);
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            if (this._rows != null) {
                this._rows.getChildren().clear();
            }
            this.smartUpdate("z.model", null);
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Grid.this.onListDataChange(event);
                }
            };
        }
    }

    public RowRenderer getRowRenderer() {
        return this._renderer;
    }

    public void setRowRenderer(RowRenderer renderer) {
        this._renderer = renderer;
    }

    public void setRowRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setRowRenderer((RowRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public int getPreloadSize() {
        return this._preloadsz;
    }

    public void setPreloadSize(int sz) {
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        this._preloadsz = sz;
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("z.innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    private void syncModel(int min, int max) {
        int oldsz;
        RowRenderer renderer = null;
        int newsz = this._model.getSize();
        int n = oldsz = this._rows != null ? this._rows.getChildren().size() : 0;
        if (oldsz > 0) {
            ListIterator it;
            if (newsz > 0 && min < oldsz) {
                if (max < 0 || max >= oldsz) {
                    max = oldsz - 1;
                }
                if (max >= newsz) {
                    max = newsz - 1;
                }
                if (min < 0) {
                    min = 0;
                }
                it = new ArrayList(this._rows.getChildren()).listIterator(min);
                while (min <= max && it.hasNext()) {
                    Row row = (Row)((Object)it.next());
                    if (row.isLoaded()) {
                        if (renderer == null) {
                            renderer = this.getRealRenderer();
                        }
                        this.unloadRow(renderer, row);
                    }
                    ++min;
                }
            }
            if (oldsz > newsz) {
                it = this._rows.getChildren().listIterator(newsz);
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
            }
        }
        if (this._rows == null) {
            new Rows().setParent((Component)this);
        }
        for (int j = oldsz; j < newsz; ++j) {
            if (renderer == null) {
                renderer = this.getRealRenderer();
            }
            this.newUnloadedRow(renderer).setParent((Component)this._rows);
        }
    }

    private final Row newUnloadedRow(RowRenderer renderer) {
        Row row = null;
        if (renderer instanceof RowRendererExt) {
            row = ((RowRendererExt)((Object)renderer)).newRow(this);
        }
        if (row == null) {
            row = new Row();
            row.applyProperties();
        }
        row.setLoaded(false);
        this.newUnloadedCell(renderer, row);
        return row;
    }

    private Component newUnloadedCell(RowRenderer renderer, Row row) {
        Object cell = null;
        if (renderer instanceof RowRendererExt) {
            cell = ((RowRendererExt)((Object)renderer)).newCell(row);
        }
        if (cell == null) {
            cell = Grid.newRenderLabel(null);
            cell.applyProperties();
        }
        cell.setParent((Component)row);
        return cell;
    }

    private static Label newRenderLabel(String value) {
        Label label = new Label(value != null && value.length() > 0 ? value : " ");
        label.setPre(true);
        return label;
    }

    private final void unloadRow(RowRenderer renderer, Row row) {
        if (!(renderer instanceof RowRendererExt) || (((RowRendererExt)((Object)renderer)).getControls() & 2) == 0) {
            List cells = row.getChildren();
            boolean bNewCell = cells.isEmpty();
            if (!bNewCell) {
                ListIterator it = cells.listIterator(1);
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
                Component cell = (Component)cells.get(0);
                boolean bl = bNewCell = !(cell instanceof Label);
                if (bNewCell) {
                    cell.detach();
                } else {
                    ((Label)cell).setValue("");
                }
            }
            if (bNewCell) {
                this.newUnloadedCell(renderer, row);
            }
            row.setLoaded(false);
        } else {
            this._rows.insertBefore((Component)this.newUnloadedRow(renderer), (Component)row);
            row.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender() {
        Renderer renderer = new Renderer();
        try {
            int ofs;
            int pgsz;
            if (this.inPagingMold()) {
                int cnt;
                pgsz = this._pgi.getPageSize();
                ofs = this._pgi.getActivePage() * pgsz;
                if (ofs >= (cnt = this._rows.getChildren().size()) && (ofs = cnt - pgsz) < 0) {
                    ofs = 0;
                }
            } else {
                pgsz = 20;
                ofs = 0;
            }
            ListIterator it = this._rows.getChildren().listIterator(ofs);
            for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                renderer.render((Row)((Object)it.next()));
            }
            if (!this.inPagingMold() && this.getRows().getChildren().size() > pgsz) {
                ((Row)((Object)this.getRows().getChildren().get(pgsz))).setAttribute("org.zkoss.zul.SkipSibling", Boolean.TRUE);
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    private void postOnInitRender() {
        Events.postEvent((String)"onInitRender", (Component)this, null);
        this.smartUpdate("z.render", true);
    }

    private void onListDataChange(ListDataEvent event) {
        int newsz = this._model.getSize();
        int oldsz = this._rows.getChildren().size();
        int min = event.getIndex0();
        int max = event.getIndex1();
        if (min < 0) {
            min = 0;
        }
        boolean done = false;
        switch (event.getType()) {
            case 1: {
                if (max < 0) {
                    max = newsz - 1;
                }
                if (max - min + 1 != newsz - oldsz) {
                    log.warning("Conflict event: number of added rows not matched: " + event);
                    break;
                }
                RowRenderer renderer = null;
                Row before = min < oldsz ? (Row)((Object)this._rows.getChildren().get(min)) : null;
                for (int j = min; j <= max; ++j) {
                    if (renderer == null) {
                        renderer = this.getRealRenderer();
                    }
                    this._rows.insertBefore((Component)this.newUnloadedRow(renderer), (Component)before);
                }
                done = true;
                break;
            }
            case 2: {
                int cnt;
                if (max < 0) {
                    max = oldsz - 1;
                }
                if ((cnt = max - min + 1) != oldsz - newsz) {
                    log.warning("Conflict event: number of removed rows not matched: " + event);
                    break;
                }
                ListIterator it = this._rows.getChildren().listIterator(min);
                while (--cnt >= 0 && it.hasNext()) {
                    it.next();
                    it.remove();
                }
                done = true;
            }
        }
        if (!done) {
            this.syncModel(min, max);
        }
        this.postOnInitRender();
    }

    private static final RowRenderer getDefaultRowRenderer() {
        return _defRend;
    }

    private RowRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : Grid.getDefaultRowRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderRow(Row row) {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            renderer.render(row);
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = this._rows.getChildren().iterator();
            while (it.hasNext()) {
                renderer.render((Row)((Object)it.next()));
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void renderRows(Set rows) {
        this.renderItems(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set rows) {
        if (this._model == null) {
            if (log.debugable()) {
                log.debug("No model no render");
            }
            return;
        }
        if (rows.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                renderer.render((Row)((Object)it.next()));
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public String getOddRowSclass() {
        return this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("z.scOddRow", scls);
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
            }
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        if (this._align != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        }
        if (this._model != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.model", (boolean)true);
            List rows = this.getRows().getChildren();
            int index = rows.size();
            ListIterator it = rows.listIterator(index);
            while (it.hasPrevious() && !((Row)((Object)it.previous())).isLoaded()) {
                --index;
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.lastLoadIdx", (int)(index - 1));
        }
        if (this._scOddRow != null) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.scOddRow", (String)this._scOddRow);
        }
        return sb.toString();
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Rows) {
            if (this._rows != null && this._rows != newChild) {
                throw new UiException("Only one rows child is allowed: " + (Object)((Object)this) + "\nNote: rows is created automatically if live data");
            }
            this._rows = (Rows)newChild;
        } else if (newChild instanceof Columns) {
            if (this._cols != null && this._cols != newChild) {
                throw new UiException("Only one columns child is allowed: " + (Object)((Object)this));
            }
            this._cols = (Columns)newChild;
        } else if (newChild instanceof Foot) {
            if (this._foot != null && this._foot != newChild) {
                throw new UiException("Only one foot child is allowed: " + (Object)((Object)this));
            }
            this._foot = (Foot)newChild;
        } else if (newChild instanceof Paging) {
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + (Object)((Object)this));
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
            this._paging = (Paging)newChild;
            this._pgi = this._paging;
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported child for grid: " + newChild);
        }
        if (super.insertBefore(newChild, refChild)) {
            if (!(newChild instanceof Auxhead)) {
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    public boolean removeChild(Component child) {
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._rows == child) {
            this._rows = null;
        } else if (this._cols == child) {
            this._cols = null;
        } else if (this._foot == child) {
            this._foot = null;
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        }
        this.invalidate();
        return true;
    }

    public Object clone() {
        Grid clone = (Grid)((Object)super.clone());
        clone.init();
        int cnt = 0;
        if (clone._rows != null) {
            ++cnt;
        }
        if (clone._cols != null) {
            ++cnt;
        }
        if (clone._foot != null) {
            ++cnt;
        }
        if (clone._paging != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof Rows) {
                this._rows = (Rows)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Columns) {
                this._cols = (Columns)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Foot) {
                this._foot = (Foot)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Paging)) continue;
            this._paging = (Paging)child;
            this._pgi = this._paging;
            if (--cnt != 0) continue;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal(-1);
        if (this._model != null) {
            this.initDataListener();
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        $assertionsDisabled = !Grid.class.desiredAssertionStatus();
        log = Log.lookup((Class)Grid.class);
        _defRend = new RowRenderer(){

            public void render(Row row, Object data) {
                Label label = Grid.newRenderLabel(Objects.toString((Object)data));
                label.applyProperties();
                label.setParent((Component)row);
                row.setValue(data);
            }
        };
    }

    private class Iter
    implements Iterator {
        private final ListIterator _it;

        private Iter() {
            this._it = Grid.this.getChildren().listIterator();
        }

        public boolean hasNext() {
            while (this._it.hasNext()) {
                Object o = this._it.next();
                if (!(o instanceof Columns) && !(o instanceof Auxhead)) continue;
                this._it.previous();
                return true;
            }
            return false;
        }

        public Object next() {
            Object o;
            while (!((o = this._it.next()) instanceof Columns) && !(o instanceof Auxhead)) {
            }
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements InnerWidth,
    RenderOnDemand {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Grid.this);
        }

        public void setInnerWidthByClient(String width) {
            Grid.this._innerWidth = width == null ? "100%" : width;
        }

        public void renderItems(Set items) {
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            if ((cnt = 20 - cnt) > 0 && Grid.this._preloadsz > 0) {
                Row row;
                if (cnt > Grid.this._preloadsz) {
                    cnt = Grid.this._preloadsz;
                }
                LinkedList<Row> toload = new LinkedList<Row>();
                Iterator it = Grid.this.getRows().getChildren().iterator();
                while (it.hasNext() && !items.contains((Object)(row = (Row)((Object)it.next())))) {
                    if (row.isLoaded()) continue;
                    toload.add(0, row);
                }
                if (!toload.isEmpty()) {
                    int bfcnt = cnt / 3;
                    Iterator e = toload.iterator();
                    while (bfcnt > 0 && e.hasNext()) {
                        items.add(e.next());
                        --bfcnt;
                        --cnt;
                    }
                }
                while (cnt > 0 && it.hasNext()) {
                    row = (Row)((Object)it.next());
                    if (row.isLoaded() || !items.add(row)) continue;
                    --cnt;
                }
            }
            Grid.this.renderItems(items);
        }
    }

    private class Renderer
    implements Serializable {
        private final RowRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Grid.this.getRealRenderer();
        }

        private void render(Row row) throws Throwable {
            if (row.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Component cell = row.getFirstChild();
            if (!(this._renderer instanceof RowRendererExt) || (((RowRendererExt)((Object)this._renderer)).getControls() & 1) != 0) {
                cell.detach();
            }
            try {
                this._renderer.render(row, Grid.this._model.getElementAt(row.getIndex()));
            }
            catch (Throwable ex) {
                try {
                    Label label = Grid.newRenderLabel(Exceptions.getMessage((Throwable)ex));
                    label.applyProperties();
                    label.setParent((Component)row);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                row.setLoaded(true);
                throw ex;
            }
            finally {
                if (row.getChildren().isEmpty()) {
                    cell.setParent((Component)row);
                }
            }
            row.setLoaded(true);
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

