/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Iframe
extends XulElement {
    private String _align;
    private String _name;
    private String _src;
    private Media _media;
    private int _medver;
    private boolean _autohide;

    public Iframe() {
    }

    public Iframe(String src) {
        this.setSrc(src);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (align != null && align.length() == 0) {
            align = null;
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public boolean isAutohide() {
        return this._autohide;
    }

    public void setAutohide(boolean autohide) {
        if (this._autohide != autohide) {
            this._autohide = autohide;
            this.smartUpdate("z.autohide", "true");
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            if (this._media == null) {
                this.smartUpdateDeferred("src", new EncodedSrc());
            }
        }
    }

    private String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._media != null ? this.getMediaSrc() : (dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "");
    }

    public void setContent(Media media) {
        if (media != this._media) {
            this._media = media;
            if (this._media != null) {
                ++this._medver;
            }
            this.smartUpdateDeferred("src", new EncodedSrc());
        }
    }

    public Media getContent() {
        return this._media;
    }

    private String getMediaSrc() {
        return Utils.getDynamicMediaURI((AbstractComponent)this, this._medver, this._media.getName(), this._media.getFormat());
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"name", (String)this._name);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"src", (String)this.getEncodedSrc());
        if (this._autohide) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.autohide", (boolean)this._autohide);
        }
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private class EncodedSrc
    implements DeferredValue {
        private EncodedSrc() {
        }

        public String getValue() {
            return Iframe.this.getEncodedSrc();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Iframe.this);
        }

        public Media getMedia(String pathInfo) {
            return Iframe.this._media;
        }
    }
}

