/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Image
extends XulElement {
    private String _align;
    private String _border;
    private String _hspace;
    private String _vspace;
    private String _src;
    private org.zkoss.image.Image _image;
    private int _imgver;

    public Image() {
    }

    public Image(String src) {
        this.setSrc(src);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (align != null && align.length() == 0) {
            align = null;
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border != null && border.length() == 0) {
            border = null;
        }
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.smartUpdate("border", this._border);
        }
    }

    public String getHspace() {
        return this._hspace;
    }

    public void setHspace(String hspace) {
        if (hspace != null && hspace.length() == 0) {
            hspace = null;
        }
        if (!Objects.equals((Object)this._hspace, (Object)hspace)) {
            this._hspace = hspace;
            this.smartUpdate("hspace", this._hspace);
        }
    }

    public String getVspace() {
        return this._vspace;
    }

    public void setVspace(String vspace) {
        if (vspace != null && vspace.length() == 0) {
            vspace = null;
        }
        if (!Objects.equals((Object)this._vspace, (Object)vspace)) {
            this._vspace = vspace;
            this.smartUpdate("vspace", this._vspace);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            if (this._image == null) {
                this.smartUpdateDeferred("src", new EncodedSrc());
            }
        }
    }

    private String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._image != null ? this.getContentSrc() : (dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "");
    }

    public void setContent(org.zkoss.image.Image image) {
        if (image != this._image) {
            this._image = image;
            if (this._image != null) {
                ++this._imgver;
            }
            this.smartUpdateDeferred("src", new EncodedSrc());
        }
    }

    public org.zkoss.image.Image getContent() {
        return this._image;
    }

    private String getContentSrc() {
        return Utils.getDynamicMediaURI((AbstractComponent)this, this._imgver, this._image.getName(), this._image.getFormat());
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String clkattrs = this.getAllOnClickAttrs(false);
        if (!this.alphafix()) {
            return clkattrs == null ? attrs : attrs + clkattrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        sb.append(" zk_alpha=\"true\"");
        return sb.toString();
    }

    private boolean alphafix() {
        Desktop dt;
        if ("alphafix".equals(this.getMold()) && (dt = this.getDesktop()) != null) {
            Execution exec = dt.getExecution();
            return exec != null && exec.isExplorer() && !exec.isExplorer7();
        }
        return false;
    }

    public String getInnerAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getInnerAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"border", (String)this._border);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"hspace", (String)this._hspace);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"vspace", (String)this._vspace);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"src", (String)this.getEncodedSrc());
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }

    public void smartUpdate(String attr, String value) {
        if (this.alphafix()) {
            this.invalidate();
        } else {
            super.smartUpdate(attr, value);
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private class EncodedSrc
    implements DeferredValue {
        private EncodedSrc() {
        }

        public String getValue() {
            return Image.this.getEncodedSrc();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Image.this);
        }

        public Media getMedia(String pathInfo) {
            return Image.this._image;
        }
    }
}

