/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zul.impl.XulElement;

public class Include
extends XulElement {
    private static final Log log = Log.lookup((Class)Include.class);
    protected String _src;
    private boolean _localized;

    public Include() {
    }

    public Include(String src) {
        this.setSrc(src);
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) throws WrongValueException {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.invalidate();
        }
    }

    public final boolean isLocalized() {
        return this._localized;
    }

    public final void setLocalized(boolean localized) {
        if (this._localized != localized) {
            this._localized = localized;
            this.invalidate();
        }
    }

    public boolean isChildable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw(Writer out) throws IOException {
        UiEngine ueng = ((WebAppCtrl)this.getDesktop().getWebApp()).getUiEngine();
        ueng.pushOwner((Component)this);
        try {
            out.write("<div id=\"");
            out.write(this.getUuid());
            out.write(34);
            out.write(this.getOuterAttrs());
            out.write(this.getInnerAttrs());
            out.write(">\n");
            if (this._src != null && this._src.length() > 0) {
                this.include(out);
            }
            out.write("\n</div>");
        }
        finally {
            ueng.popOwner();
        }
    }

    private void include(Writer out) throws IOException {
        Desktop desktop = this.getDesktop();
        Execution exec = desktop.getExecution();
        String src = exec.toAbsoluteURI(this._src, false);
        try {
            exec.include(out, src, null, 0);
        }
        catch (Throwable err) {
            String errpg = desktop.getWebApp().getConfiguration().getErrorPage(desktop.getDeviceType(), err);
            if (errpg != null) {
                try {
                    exec.setAttribute("javax.servlet.error.message", (Object)Exceptions.getMessage((Throwable)err));
                    exec.setAttribute("javax.servlet.error.exception", (Object)err);
                    exec.setAttribute("javax.servlet.error.exception_type", err.getClass());
                    exec.setAttribute("javax.servlet.error.status_code", (Object)new Integer(500));
                    exec.include(out, errpg, null, 0);
                    return;
                }
                catch (IOException ex) {
                }
                catch (Throwable ex) {
                    log.warning("Failed to load the error page: " + errpg, ex);
                }
            }
            String msg = Messages.get((int)MZk.PAGE_FAILED, (Object[])new Object[]{src, Exceptions.getMessage((Throwable)err), Exceptions.formatStackTrace(null, (Throwable)err, null, (int)6)});
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("px_alert_type", "error");
            attrs.put("px_alert", msg);
            exec.include(out, "~./html/alert.dsp", attrs, 3);
        }
    }
}

