/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Intbox
extends NumberInputElement {
    public Intbox() {
        this.setCols(11);
    }

    public Intbox(int value) throws WrongValueException {
        this();
        this.setValue(new Integer(value));
    }

    public Integer getValue() throws WrongValueException {
        return (Integer)this.getTargetValue();
    }

    public int intValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (Integer)val : 0;
    }

    public void setValue(Integer value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            int v;
            int divscale;
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            for (v = Integer.parseInt(val); v != 0 && --divscale >= 0; v /= 10) {
            }
            return new Integer(v);
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? value.toString() : this.formatNumber(value, null);
    }
}

