/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import org.zkoss.lang.Objects;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListModelExt;

public class ListModelSet
extends AbstractListModel
implements ListModelExt,
Set,
Serializable {
    protected Set _set;

    public static ListModelSet instance(Set set) {
        return new ListModelSet(set, true);
    }

    public ListModelSet(Set set, boolean live) {
        this._set = live ? set : new LinkedHashSet(set);
    }

    public ListModelSet() {
        this._set = new LinkedHashSet();
    }

    public ListModelSet(Collection c) {
        this._set = new LinkedHashSet(c);
    }

    public ListModelSet(Object[] array) {
        this._set = new LinkedHashSet(array.length);
        for (int j = 0; j < array.length; ++j) {
            this._set.add(array[j]);
        }
    }

    public ListModelSet(int initialCapacity) {
        this._set = new LinkedHashSet(initialCapacity);
    }

    public ListModelSet(int initialCapacity, float loadFactor) {
        this._set = new LinkedHashSet(initialCapacity, loadFactor);
    }

    public Set getInnerSet() {
        return this._set;
    }

    public int getSize() {
        return this._set.size();
    }

    public Object getElementAt(int j) {
        Object o;
        if (j < 0 || j >= this._set.size()) {
            throw new IndexOutOfBoundsException("" + j);
        }
        Iterator it = this._set.iterator();
        do {
            o = it.next();
        } while (--j >= 0);
        return o;
    }

    public boolean add(Object o) {
        if (!this._set.contains(o)) {
            boolean ret = this._set.add(o);
            if (this._set instanceof LinkedHashSet) {
                int i1 = this._set.size() - 1;
                this.fireEvent(1, i1, i1);
            } else if (this._set instanceof SortedSet) {
                int i1 = this.indexOf(o);
                this.fireEvent(1, i1, i1);
            } else {
                this.fireEvent(0, -1, -1);
            }
            return ret;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        if (this._set instanceof LinkedHashSet) {
            int begin = this._set.size();
            int added = 0;
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (this._set.contains(o)) continue;
                this._set.add(o);
                ++added;
            }
            if (added > 0) {
                this.fireEvent(1, begin, begin + added - 1);
                return true;
            }
            return false;
        }
        boolean ret = this._set.addAll(c);
        this.fireEvent(0, -1, -1);
        return ret;
    }

    public void clear() {
        int i2 = this._set.size() - 1;
        if (i2 < 0) {
            return;
        }
        this._set.clear();
        this.fireEvent(2, 0, i2);
    }

    public boolean contains(Object elem) {
        return this._set.contains(elem);
    }

    public boolean containsAll(Collection c) {
        return this._set.containsAll(c);
    }

    public boolean equals(Object o) {
        return ((Object)this._set).equals(o instanceof ListModelSet ? ((ListModelSet)o)._set : o);
    }

    public int hashCode() {
        return ((Object)this._set).hashCode();
    }

    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    public String toString() {
        return this._set.toString();
    }

    public Iterator iterator() {
        return new Iterator(){
            private Iterator _it;
            private Object _current;
            {
                this._it = ListModelSet.this._set.iterator();
                this._current = null;
            }

            public boolean hasNext() {
                return this._it.hasNext();
            }

            public Object next() {
                this._current = this._it.next();
                return this._current;
            }

            public void remove() {
                if (ListModelSet.this._set instanceof LinkedHashSet || ListModelSet.this._set instanceof SortedSet) {
                    int index = ListModelSet.this.indexOf(this._current);
                    this._it.remove();
                    ListModelSet.this.fireEvent(2, index, index);
                } else {
                    this._it.remove();
                    ListModelSet.this.fireEvent(0, -1, -1);
                }
            }
        };
    }

    public boolean remove(Object o) {
        boolean ret = false;
        if (this._set.contains(o)) {
            if (this._set instanceof LinkedHashSet || this._set instanceof SortedSet) {
                int index = this.indexOf(o);
                ret = this._set.remove(o);
                this.fireEvent(2, index, index);
            } else {
                ret = this._set.remove(o);
                this.fireEvent(0, -1, -1);
            }
        }
        return ret;
    }

    public int indexOf(Object o) {
        int j = 0;
        Iterator it = this._set.iterator();
        while (it.hasNext()) {
            if (Objects.equals((Object)o, it.next())) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public boolean removeAll(Collection c) {
        if (this._set == c || this == c) {
            this.clear();
            return true;
        }
        if (this._set instanceof LinkedHashSet || this._set instanceof SortedSet) {
            return this.removePartial(c, true);
        }
        boolean ret = this._set.removeAll(c);
        if (ret) {
            this.fireEvent(0, -1, -1);
        }
        return ret;
    }

    public boolean retainAll(Collection c) {
        if (this._set == c || this == c) {
            return false;
        }
        if (this._set instanceof LinkedHashSet || this._set instanceof SortedSet) {
            return this.removePartial(c, false);
        }
        boolean ret = this._set.retainAll(c);
        if (ret) {
            this.fireEvent(0, -1, -1);
        }
        return ret;
    }

    private boolean removePartial(Collection c, boolean isRemove) {
        int sz = c.size();
        int removed = 0;
        int retained = 0;
        int index = 0;
        int begin = -1;
        Iterator it = this._set.iterator();
        while (!(!it.hasNext() || isRemove && removed >= sz || !isRemove && retained >= sz)) {
            Object item = it.next();
            if (c.contains(item) == isRemove) {
                if (begin < 0) {
                    begin = index;
                }
                ++removed;
                it.remove();
            } else {
                ++retained;
                if (begin >= 0) {
                    this.fireEvent(2, begin, index - 1);
                    index = begin;
                    begin = -1;
                }
            }
            ++index;
        }
        if (begin >= 0) {
            this.fireEvent(2, begin, index - 1);
        }
        return removed > 0;
    }

    public int size() {
        return this._set.size();
    }

    public Object[] toArray() {
        return this._set.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._set.toArray(a);
    }

    public void sort(Comparator cmpr, boolean ascending) {
        ArrayList copy = new ArrayList(this._set);
        Collections.sort(copy, cmpr);
        this._set.clear();
        this._set.addAll(copy);
        this.fireEvent(0, -1, -1);
    }
}

