/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.client.InnerWidth;
import org.zkoss.zk.ui.ext.client.RenderOnDemand;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listfoot;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.Paging;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.XulElement;

public class Listbox
extends XulElement {
    private static final Log log;
    private transient List _items;
    private transient Set _selItems;
    private transient Set _roSelItems;
    private int _maxlength;
    private int _rows;
    private int _jsel = -1;
    private transient Listhead _listhead;
    private transient Listfoot _listfoot;
    private ListModel _model;
    private ListitemRenderer _renderer;
    private transient ListDataListener _dataListener;
    private transient Collection _heads;
    private int _hdcnt;
    private String _innerWidth = "100%";
    private String _name;
    private transient Paginal _pgi;
    private transient Paging _paging;
    private transient EventListener _pgListener;
    private transient EventListener _pgImpListener;
    private String _scOddRow = "odd";
    private int _tabindex = -1;
    private int _preloadsz = 7;
    private boolean _multiple;
    private boolean _disabled;
    private boolean _checkmark;
    private boolean _vflex;
    private boolean _noSmartUpdate;
    private static final ListitemRenderer _defRend;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Listbox() {
        this.setSclass("listbox");
        this.init();
    }

    private void init() {
        this._items = new AbstractSequentialList(){

            public ListIterator listIterator(int index) {
                return new ItemIter(index);
            }

            public Object get(int j) {
                Object o = Listbox.this.getChildren().get(j + Listbox.this._hdcnt);
                if (!(o instanceof Listitem)) {
                    throw new IndexOutOfBoundsException("Wrong index: " + j);
                }
                return o;
            }

            public int size() {
                int sz = Listbox.this.getChildren().size() - Listbox.this._hdcnt;
                if (Listbox.this._listfoot != null) {
                    --sz;
                }
                if (Listbox.this._paging != null) {
                    --sz;
                }
                return sz;
            }
        };
        this._selItems = new LinkedHashSet(5);
        this._roSelItems = Collections.unmodifiableSet(this._selItems);
        this._heads = new AbstractCollection(){

            public int size() {
                return Listbox.this._hdcnt;
            }

            public Iterator iterator() {
                return new Iter();
            }
        };
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Listbox.this.onListDataChange(event);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    public Listhead getListhead() {
        return this._listhead;
    }

    public Listfoot getListfoot() {
        return this._listfoot;
    }

    public Collection getHeads() {
        return this._heads;
    }

    final boolean inSelectMold() {
        return "select".equals(this.getMold());
    }

    public final boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            if (!this.inSelectMold()) {
                this.invalidate();
            }
        }
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("z.innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public final boolean isVflex() {
        return this._vflex;
    }

    public void setVflex(boolean vflex) {
        if (this._vflex != vflex) {
            this._vflex = vflex;
            if (!this.inSelectMold()) {
                this.smartUpdate("z.flex", this._vflex);
            }
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            if (this.inSelectMold()) {
                this.smartUpdate("disabled", this._disabled);
            } else {
                this.smartUpdate("z.disabled", this._disabled);
            }
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            if (tabindex < 0) {
                this.smartUpdate("tabindex", null);
            } else {
                this.smartUpdate("tabindex", Integer.toString(this._tabindex));
            }
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            if (this.inSelectMold()) {
                this.smartUpdate("size", this._rows > 0 ? Integer.toString(this._rows) : null);
            } else {
                this.smartUpdate("z.size", Integer.toString(this._rows));
            }
        }
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                Listitem item = this.getSelectedItem();
                Iterator it = this._selItems.iterator();
                while (it.hasNext()) {
                    Listitem li = (Listitem)((Object)it.next());
                    if (li == item) continue;
                    li.setSelectedDirectly(false);
                    it.remove();
                }
            }
            if (this.inSelectMold()) {
                this.smartUpdate("multiple", this._multiple);
            } else if (this.isCheckmark()) {
                this.invalidate();
            } else {
                this.smartUpdate("z.multiple", this._multiple);
            }
        }
    }

    private String getSelectedId() {
        Listitem sel = this.getSelectedItem();
        return sel != null ? sel.getUuid() : "zk_n_a";
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            if (this.inSelectMold()) {
                this.invalidate();
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            if (this.inSelectMold()) {
                this.smartUpdate("name", this._name);
            } else if (this._name != null) {
                this.smartUpdate("z.name", this._name);
            } else {
                this.invalidate();
            }
        }
    }

    public List getItems() {
        return this._items;
    }

    public int getItemCount() {
        return this._items.size();
    }

    public Listitem getItemAtIndex(int index) {
        return (Listitem)((Object)this._items.get(index));
    }

    public int getIndexOfItem(Listitem item) {
        return item == null ? -1 : item.getIndex();
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        if (jsel >= this._items.size()) {
            throw new UiException("Out of bound: " + jsel + " while size=" + this._items.size());
        }
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel < 0) {
            this.clearSelection();
        } else if (jsel != this._jsel || this._multiple && this._selItems.size() > 1) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                Listitem item = (Listitem)((Object)it.next());
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = jsel;
            Listitem item = this.getItemAtIndex(this._jsel);
            item.setSelectedDirectly(true);
            this._selItems.add(item);
            if (this.inSelectMold()) {
                this.smartUpdate("selectedIndex", Integer.toString(this._jsel));
            } else {
                this.smartUpdate("select", item.getUuid());
            }
        }
    }

    public void selectItem(Listitem item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            if (this._multiple || !item.isSelected()) {
                this.setSelectedIndex(item.getIndex());
            }
        }
    }

    public void addItemToSelection(Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                if (item.getIndex() < this._jsel || this._jsel < 0) {
                    this._jsel = item.getIndex();
                    if (!this.inSelectMold()) {
                        this.smartUpdate("z.selId", this.getSelectedId());
                    }
                }
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                if (this.inSelectMold()) {
                    item.smartUpdate("selected", true);
                } else {
                    this.smartUpdateSelection();
                }
            }
        }
    }

    public void removeItemFromSelection(Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + (Object)((Object)item));
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                int oldSel = this._jsel;
                item.setSelectedDirectly(false);
                this._selItems.remove((Object)item);
                this.fixSelectedIndex(0);
                if (this.inSelectMold()) {
                    item.smartUpdate("selected", false);
                } else {
                    this.smartUpdateSelection();
                    if (oldSel != this._jsel) {
                        this.smartUpdate("z.selId", this.getSelectedId());
                    }
                }
            }
        }
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        Iterator it = this._selItems.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(((Listitem)((Object)it.next())).getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(Listitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                Listitem item = (Listitem)((Object)it.next());
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = -1;
            if (this.inSelectMold()) {
                this.smartUpdate("selectedIndex", "-1");
            } else {
                this.smartUpdate("select", "");
            }
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + (Object)((Object)this));
        }
        if (this._items.size() != this._selItems.size()) {
            Iterator it = this._items.iterator();
            while (it.hasNext()) {
                Listitem item = (Listitem)((Object)it.next());
                this._selItems.add(item);
                item.setSelectedDirectly(true);
            }
            this._jsel = this._items.isEmpty() ? -1 : 0;
            this.smartUpdate("selectAll", "true");
        }
    }

    public Listitem getSelectedItem() {
        return this._jsel >= 0 ? (this._jsel > 0 && this._selItems.size() == 1 ? (Listitem)((Object)this._selItems.iterator().next()) : this.getItemAtIndex(this._jsel)) : null;
    }

    public void setSelectedItem(Listitem item) {
        this.selectItem(item);
    }

    public Set getSelectedItems() {
        return this._roSelItems;
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public Listitem appendItem(String label, String value) {
        Listitem item = new Listitem(label, value);
        item.applyProperties();
        item.setParent((Component)this);
        return item;
    }

    public Listitem removeItemAt(int index) {
        Listitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this.getItemCount());
                    this.addPagingListener(this._pgi);
                }
            }
        }
    }

    private void newInternalPaging() {
        if (!$assertionsDisabled && !this.inPagingMold()) {
            throw new AssertionError((Object)"paging mold only");
        }
        if (!($assertionsDisabled || this._paging == null && this._pgi == null)) {
            throw new AssertionError();
        }
        Paging paging = new Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        paging.setTotalSize(this.getItemCount());
        paging.setParent((Component)this);
        this.addPagingListener(this._pgi);
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new EventListener(){

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Listbox.this, evt.getPageable(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._pgImpListener == null) {
            this._pgImpListener = new EventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(Event event) {
                    if (Listbox.this._model != null && Listbox.this.inPagingMold()) {
                        Renderer renderer = new Renderer();
                        try {
                            Paginal pgi = Listbox.this.getPaginal();
                            int pgsz = pgi.getPageSize();
                            int ofs = pgi.getActivePage() * pgsz;
                            ListIterator it = Listbox.this.getItems().listIterator(ofs);
                            while (--pgsz >= 0 && it.hasNext()) {
                                renderer.render((Listitem)((Object)it.next()));
                            }
                        }
                        catch (Throwable ex) {
                            renderer.doCatch(ex);
                        }
                        finally {
                            renderer.doFinally();
                        }
                    }
                    Listbox.this.invalidate();
                }
            };
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public Paging getPaging() {
        return this._paging;
    }

    public int getPageSize() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi.getPageSize();
    }

    public void setPageSize(int pgsz) {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        this._pgi.setPageSize(pgsz);
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public int getVisibleBegin() {
        if (!this.inPagingMold()) {
            return 0;
        }
        Paginal pgi = this.getPaginal();
        return pgi.getActivePage() * pgi.getPageSize();
    }

    public int getVisibleEnd() {
        if (!this.inPagingMold()) {
            return Integer.MAX_VALUE;
        }
        Paginal pgi = this.getPaginal();
        return (pgi.getActivePage() + 1) * pgi.getPageSize() - 1;
    }

    public String getOddRowSclass() {
        return this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("z.scOddRow", scls);
        }
    }

    public void smartUpdate(String attr, String value) {
        if (!this._noSmartUpdate) {
            super.smartUpdate(attr, value);
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (this.inSelectMold()) {
            this.invalidate();
        } else if (this.inPagingMold() && child instanceof Listitem) {
            this._pgi.setTotalSize(this.getItemCount());
        }
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this.inSelectMold()) {
            this.invalidate();
        } else if (this.inPagingMold() && child instanceof Listitem) {
            this._pgi.setTotalSize(this.getItemCount());
        }
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Listitem) {
            int jfrom;
            if (refChild != null && refChild.getParent() != this) {
                refChild = null;
            }
            if (refChild != null && (refChild == this._listhead || refChild instanceof Auxhead)) {
                refChild = this.getChildren().size() > this._hdcnt ? (Component)this.getChildren().get(this._hdcnt) : null;
            }
            refChild = this.fixRefChildBeforeFoot((Component)refChild);
            Listitem newItem = (Listitem)newChild;
            int n = jfrom = newItem.getParent() == this ? newItem.getIndex() : -1;
            if (super.insertBefore(newChild, refChild)) {
                int fixFrom;
                int jto = refChild instanceof Listitem ? ((Listitem)((Object)refChild)).getIndex() : -1;
                int n2 = fixFrom = jfrom < 0 || jto >= 0 && jfrom > jto ? jto : jfrom;
                if (fixFrom < 0) {
                    newItem.setIndexDirectly(this._items.size() - 1);
                } else {
                    this.fixItemIndices(fixFrom);
                }
                int newIndex = newItem.getIndex();
                if (newItem.isSelected()) {
                    if (this._jsel < 0) {
                        this._jsel = newIndex;
                        if (!this.inSelectMold()) {
                            this.smartUpdate("z.selId", this.getSelectedId());
                        }
                        this._selItems.add(newItem);
                    } else if (this._multiple) {
                        if (this._jsel > newIndex) {
                            this._jsel = newIndex;
                            if (!this.inSelectMold()) {
                                this.smartUpdate("z.selId", this.getSelectedId());
                            }
                        }
                        this._selItems.add(newItem);
                    } else {
                        newItem.setSelectedDirectly(false);
                    }
                } else {
                    int oldjsel = this._jsel;
                    if (jfrom < 0) {
                        if (this._jsel >= newIndex) {
                            ++this._jsel;
                        }
                    } else if (this._jsel >= 0) {
                        if (jfrom > this._jsel) {
                            if (jto >= 0 && jto <= this._jsel) {
                                ++this._jsel;
                            }
                        } else if (jto < 0 || jto > this._jsel) {
                            --this._jsel;
                        }
                    }
                    if (oldjsel != this._jsel && !this.inSelectMold()) {
                        this.smartUpdate("z.selId", this.getSelectedId());
                    }
                }
                return true;
            }
            return false;
        }
        if (newChild instanceof Listhead) {
            if (this._listhead != null && this._listhead != newChild) {
                throw new UiException("Only one listhead is allowed: " + (Object)((Object)this));
            }
            boolean added = this._listhead == null;
            refChild = this.fixRefChildForHeader((Component)refChild);
            this._listhead = (Listhead)newChild;
            if (super.insertBefore(newChild, refChild)) {
                if (added) {
                    ++this._hdcnt;
                }
                this.invalidate();
                return true;
            }
            return false;
        }
        if (newChild instanceof Auxhead) {
            boolean added = newChild.getParent() != this;
            if (super.insertBefore(newChild, refChild = this.fixRefChildForHeader((Component)refChild))) {
                if (added) {
                    ++this._hdcnt;
                }
                return true;
            }
            return false;
        }
        if (newChild instanceof Listfoot) {
            if (this._listfoot != null && this._listfoot != newChild) {
                throw new UiException("Only one listfoot is allowed: " + (Object)((Object)this));
            }
            if (this.inSelectMold()) {
                log.warning("Mold select ignores listfoot");
            }
            this.invalidate();
            this._listfoot = (Listfoot)newChild;
            refChild = this._paging;
            return super.insertBefore(newChild, refChild);
        }
        if (newChild instanceof Paging) {
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + (Object)((Object)this));
            }
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
            this.invalidate();
            this._paging = (Paging)newChild;
            this._pgi = this._paging;
            refChild = null;
            return super.insertBefore(newChild, refChild);
        }
        throw new UiException("Unsupported child for Listbox: " + newChild);
    }

    private Component fixRefChildForHeader(Component refChild) {
        if (refChild != null && refChild.getParent() != this) {
            refChild = null;
        }
        if (refChild == null || refChild != this._listhead && !(refChild instanceof Auxhead)) {
            refChild = this.getChildren().size() > this._hdcnt ? (Component)this.getChildren().get(this._hdcnt) : null;
        }
        refChild = this.fixRefChildBeforeFoot(refChild);
        return refChild;
    }

    private Component fixRefChildBeforeFoot(Component refChild) {
        if (refChild == null) {
            refChild = this._listfoot != null ? this._listfoot : this._paging;
        } else if (refChild == this._paging && this._listfoot != null) {
            refChild = this._listfoot;
        }
        return refChild;
    }

    public boolean removeChild(Component child) {
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._listhead == child) {
            this._listhead = null;
            --this._hdcnt;
        } else if (this._listfoot == child) {
            this._listfoot = null;
        } else {
            if (child instanceof Listitem) {
                Listitem item = (Listitem)child;
                int index = item.getIndex();
                item.setIndexDirectly(-1);
                this.fixItemIndices(index);
                if (item.isSelected()) {
                    this._selItems.remove((Object)item);
                    if (this._jsel == index) {
                        this.fixSelectedIndex(index);
                        if (!this.inSelectMold()) {
                            this.smartUpdate("z.selId", this.getSelectedId());
                        }
                    }
                } else if (this._jsel >= index) {
                    --this._jsel;
                    if (!this.inSelectMold()) {
                        this.smartUpdate("z.selId", this.getSelectedId());
                    }
                }
                return true;
            }
            if (this._paging == child) {
                this._paging = null;
                if (this._pgi == child) {
                    this._pgi = null;
                }
            } else if (child instanceof Auxhead) {
                --this._hdcnt;
            }
        }
        this.invalidate();
        return true;
    }

    private void fixSelectedIndex(int j) {
        if (!this._selItems.isEmpty()) {
            ListIterator it = this._items.listIterator(j);
            while (it.hasNext()) {
                Listitem item = (Listitem)((Object)it.next());
                if (item.isSelected()) {
                    this._jsel = j;
                    return;
                }
                ++j;
            }
        }
        this._jsel = -1;
    }

    private void fixItemIndices(int j) {
        ListIterator it = this._items.listIterator(j);
        while (it.hasNext()) {
            ((Listitem)((Object)it.next())).setIndexDirectly(j);
            ++j;
        }
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                } else {
                    this.getItems().clear();
                    if (!this.inSelectMold()) {
                        this.smartUpdate("z.model", "true");
                    }
                }
                this._model = model;
                this.initDataListener();
            }
            this.syncModel(-1, -1);
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            this.getItems().clear();
            if (!this.inSelectMold()) {
                this.smartUpdate("z.model", null);
            }
        }
    }

    public ListitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ListitemRenderer renderer) {
        this._renderer = renderer;
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ListitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public int getPreloadSize() {
        return this._preloadsz;
    }

    public void setPreloadSize(int sz) {
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        this._preloadsz = sz;
    }

    private void syncModel(int min, int max) {
        int j;
        ListitemRenderer renderer = null;
        int newsz = this._model.getSize();
        int oldsz = this.getItemCount();
        if (oldsz > 0) {
            if (newsz > 0 && min < oldsz) {
                if (max < 0 || max >= oldsz) {
                    max = oldsz - 1;
                }
                if (max >= newsz) {
                    max = newsz - 1;
                }
                if (min < 0) {
                    min = 0;
                }
                ListIterator it = new ArrayList(this._items).listIterator(min);
                while (min <= max && it.hasNext()) {
                    Listitem item = (Listitem)((Object)it.next());
                    if (item.isLoaded()) {
                        if (renderer == null) {
                            renderer = this.getRealRenderer();
                        }
                        this.unloadItem(renderer, item);
                    }
                    ++min;
                }
            }
            for (j = newsz; j < oldsz; ++j) {
                this.getItemAtIndex(newsz).detach();
            }
        }
        for (j = oldsz; j < newsz; ++j) {
            if (renderer == null) {
                renderer = this.getRealRenderer();
            }
            this.newUnloadedItem(renderer).setParent((Component)this);
        }
    }

    private final Listitem newUnloadedItem(ListitemRenderer renderer) {
        Listitem item = null;
        if (renderer instanceof ListitemRendererExt) {
            item = ((ListitemRendererExt)((Object)renderer)).newListitem(this);
        }
        if (item == null) {
            item = new Listitem();
            item.applyProperties();
        }
        item.setLoaded(false);
        this.newUnloadedCell(renderer, item);
        return item;
    }

    private Listcell newUnloadedCell(ListitemRenderer renderer, Listitem item) {
        Listcell cell = null;
        if (renderer instanceof ListitemRendererExt) {
            cell = ((ListitemRendererExt)((Object)renderer)).newListcell(item);
        }
        if (cell == null) {
            cell = new Listcell();
            cell.applyProperties();
        }
        cell.setParent((Component)item);
        return cell;
    }

    private final void unloadItem(ListitemRenderer renderer, Listitem item) {
        if (!(renderer instanceof ListitemRendererExt) || (((ListitemRendererExt)((Object)renderer)).getControls() & 2) == 0) {
            List cells = item.getChildren();
            if (cells.isEmpty()) {
                this.newUnloadedCell(renderer, item);
            } else {
                ListIterator it = cells.listIterator(1);
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
                Listcell listcell = (Listcell)((Object)cells.get(0));
                listcell.getChildren().clear();
                listcell.setLabel(null);
                listcell.setImage(null);
            }
            item.setLoaded(false);
        } else {
            item.getParent().insertBefore((Component)this.newUnloadedItem(renderer), (Component)item);
            item.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender() {
        Renderer renderer = new Renderer();
        try {
            int ofs;
            int pgsz;
            if (this.inPagingMold()) {
                int cnt;
                pgsz = this._pgi.getPageSize();
                ofs = this._pgi.getActivePage() * pgsz;
                if (ofs >= (cnt = this.getItemCount()) && (ofs = cnt - pgsz) < 0) {
                    ofs = 0;
                }
            } else {
                pgsz = this.inSelectMold() ? this.getItemCount() : (this._rows > 0 ? this._rows + 5 : 20);
                ofs = 0;
            }
            ListIterator it = this.getItems().listIterator(ofs);
            for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                renderer.render((Listitem)((Object)it.next()));
            }
            if (!this.inPagingMold() && this.getItemCount() > pgsz) {
                this.getItemAtIndex(pgsz).setAttribute("org.zkoss.zul.SkipSibling", Boolean.TRUE);
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    private void postOnInitRender() {
        Events.postEvent((String)"onInitRender", (Component)this, null);
        this.smartUpdate("z.render", true);
    }

    private void onListDataChange(ListDataEvent event) {
        if (this.inSelectMold()) {
            this.invalidate();
            this.syncModel(-1, -1);
            this.postOnInitRender();
            return;
        }
        int newsz = this._model.getSize();
        int oldsz = this.getItemCount();
        int min = event.getIndex0();
        int max = event.getIndex1();
        if (min < 0) {
            min = 0;
        }
        boolean done = false;
        switch (event.getType()) {
            case 1: {
                if (max < 0) {
                    max = newsz - 1;
                }
                if (max - min + 1 != newsz - oldsz) {
                    log.warning("Conflict event: number of added items not matched: " + event);
                    break;
                }
                ListitemRenderer renderer = null;
                Listitem before = min < oldsz ? this.getItemAtIndex(min) : null;
                for (int j = min; j <= max; ++j) {
                    if (renderer == null) {
                        renderer = this.getRealRenderer();
                    }
                    this.insertBefore((Component)this.newUnloadedItem(renderer), (Component)before);
                }
                done = true;
                break;
            }
            case 2: {
                int cnt;
                if (max < 0) {
                    max = oldsz - 1;
                }
                if ((cnt = max - min + 1) != oldsz - newsz) {
                    log.warning("Conflict event: number of removed items not matched: " + event);
                    break;
                }
                ListIterator it = this.getItems().listIterator(min);
                while (--cnt >= 0 && it.hasNext()) {
                    it.next();
                    it.remove();
                }
                done = true;
            }
        }
        if (!done) {
            this.syncModel(min, max);
        }
        this.postOnInitRender();
    }

    private static final ListitemRenderer getDefaultItemRenderer() {
        return _defRend;
    }

    private ListitemRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : Listbox.getDefaultItemRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listitem renderItem(Listitem li) {
        if (this._model != null && !li.isLoaded()) {
            Renderer renderer = new Renderer();
            try {
                renderer.render(li);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
        return li;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = this.getItems().iterator();
            while (it.hasNext()) {
                renderer.render((Listitem)((Object)it.next()));
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set items) {
        if (this._model == null) {
            return;
        }
        if (items.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                renderer.render((Listitem)((Object)it.next()));
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
            }
        }
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        if (this.inSelectMold()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"name", (String)this._name);
            HTMLs.appendAttribute((StringBuffer)sb, (String)"size", (int)this.getRows());
            if (this.isMultiple()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"multiple", (String)"multiple");
            }
            if (this._disabled) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
            }
            if (this._tabindex >= 0) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"tabindex", (int)this._tabindex);
            }
        } else {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.name", (String)this._name);
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.size", (int)this._rows);
            if (this._disabled) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disabled", (boolean)true);
            }
            if (this._multiple) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.multiple", (boolean)true);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.selId", (String)this.getSelectedId());
            if (this._vflex) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.vflex", (boolean)true);
            }
            if (this._model != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.model", (boolean)true);
            }
            if (this._scOddRow != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.scOddRow", (String)this._scOddRow);
            }
            if (this.getModel() != null) {
                int index = this.getItemCount();
                ListIterator it = this.getItems().listIterator(index);
                while (it.hasPrevious() && !((Listitem)((Object)it.previous())).isLoaded()) {
                    --index;
                }
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.lastLoadIdx", (int)(index - 1));
            }
        }
        this.appendAsapAttr(sb, "onSelect");
        return sb.toString();
    }

    public Object clone() {
        Listbox clone = (Listbox)((Object)super.clone());
        clone.init();
        clone.afterUnmarshal();
        if (clone._model != null) {
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private void afterUnmarshal() {
        int index = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof Listitem) {
                Listitem li = (Listitem)((Object)child);
                li.setIndexDirectly(index++);
                if (!li.isSelected()) continue;
                this._selItems.add(li);
                continue;
            }
            if (child instanceof Listhead) {
                this._listhead = (Listhead)((Object)child);
                continue;
            }
            if (child instanceof Listfoot) {
                this._listfoot = (Listfoot)((Object)child);
                continue;
            }
            if (!(child instanceof Paging)) continue;
            this._paging = (Paging)child;
            this._pgi = this._paging;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal();
        if (this._model != null) {
            this.initDataListener();
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        $assertionsDisabled = !Listbox.class.desiredAssertionStatus();
        log = Log.lookup((Class)Listbox.class);
        _defRend = new ListitemRenderer(){

            public void render(Listitem item, Object data) {
                item.setLabel(Objects.toString((Object)data));
                item.setValue(data);
            }
        };
    }

    private class Iter
    implements Iterator {
        private final Iterator _it;
        private int _j;

        private Iter() {
            this._it = Listbox.this.getChildren().iterator();
        }

        public boolean hasNext() {
            return this._j < Listbox.this._hdcnt;
        }

        public Object next() {
            Object o = this._it.next();
            ++this._j;
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements InnerWidth,
    Selectable,
    Cropper,
    RenderOnDemand {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Listbox.this);
        }

        public void setInnerWidthByClient(String width) {
            Listbox.this._innerWidth = width == null ? "100%" : width;
        }

        public void renderItems(Set items) {
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            if ((cnt = 20 - cnt) > 0 && Listbox.this._preloadsz > 0) {
                Listitem li;
                if (cnt > Listbox.this._preloadsz) {
                    cnt = Listbox.this._preloadsz;
                }
                LinkedList<Listitem> toload = new LinkedList<Listitem>();
                Iterator it = Listbox.this._items.iterator();
                while (it.hasNext() && !items.contains((Object)(li = (Listitem)((Object)it.next())))) {
                    if (li.isLoaded()) continue;
                    toload.add(0, li);
                }
                if (!toload.isEmpty()) {
                    int bfcnt = cnt / 3;
                    Iterator e = toload.iterator();
                    while (bfcnt > 0 && e.hasNext()) {
                        items.add(e.next());
                        --bfcnt;
                        --cnt;
                    }
                }
                while (cnt > 0 && it.hasNext()) {
                    li = (Listitem)((Object)it.next());
                    if (li.isLoaded() || !items.add(li)) continue;
                    --cnt;
                }
            }
            Listbox.this.renderItems(items);
        }

        public boolean isCropper() {
            return Listbox.this.inPagingMold();
        }

        public Set getAvailableAtClient() {
            if (!Listbox.this.inPagingMold()) {
                return null;
            }
            HashSet<XulElement> avail = new HashSet<XulElement>(37);
            avail.addAll(Listbox.this._heads);
            if (Listbox.this._listfoot != null) {
                avail.add(Listbox.this._listfoot);
            }
            if (Listbox.this._paging != null) {
                avail.add(Listbox.this._paging);
            }
            Paginal pgi = Listbox.this.getPaginal();
            int pgsz = pgi.getPageSize();
            int ofs = pgi.getActivePage() * pgsz;
            ListIterator it = Listbox.this.getItems().listIterator(ofs);
            while (--pgsz >= 0 && it.hasNext()) {
                avail.add((XulElement)((Object)it.next()));
            }
            return avail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectItemsByClient(Set selItems) {
            Listbox.this._noSmartUpdate = true;
            try {
                boolean paging = Listbox.this.inPagingMold();
                if (!Listbox.this._multiple || !paging && (selItems == null || selItems.size() <= 1)) {
                    Listitem item = selItems != null && selItems.size() > 0 ? (Listitem)((Object)selItems.iterator().next()) : null;
                    Listbox.this.selectItem(item);
                } else {
                    int to;
                    int from;
                    if (paging) {
                        Paginal pgi = Listbox.this.getPaginal();
                        int pgsz = pgi.getPageSize();
                        from = pgi.getActivePage() * pgsz;
                        to = from + pgsz;
                    } else {
                        to = 0;
                        from = 0;
                    }
                    int j = 0;
                    Iterator it = Listbox.this._items.iterator();
                    while (it.hasNext()) {
                        Listitem item = (Listitem)((Object)it.next());
                        if (selItems.contains((Object)item)) {
                            Listbox.this.addItemToSelection(item);
                        } else if (!paging) {
                            Listbox.this.removeItemFromSelection(item);
                        } else {
                            int index = item.getIndex();
                            if (index >= from && index < to) {
                                Listbox.this.removeItemFromSelection(item);
                            }
                        }
                        ++j;
                    }
                }
            }
            finally {
                Listbox.this._noSmartUpdate = false;
            }
        }
    }

    private class ItemIter
    implements ListIterator,
    Serializable {
        private ListIterator _it;
        private int _j;
        private boolean _bNxt;

        private ItemIter(int index) {
            this._j = index;
        }

        public void add(Object o) {
            this.prepare();
            this._it.add(o);
            ++this._j;
        }

        public boolean hasNext() {
            return this._j < Listbox.this._items.size();
        }

        public boolean hasPrevious() {
            return this._j > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Object o = this._it.next();
            ++this._j;
            this._bNxt = true;
            return o;
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Object o = this._it.previous();
            --this._j;
            this._bNxt = false;
            return o;
        }

        public int nextIndex() {
            return this._j;
        }

        public int previousIndex() {
            return this._j - 1;
        }

        public void remove() {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.remove();
            if (this._bNxt) {
                --this._j;
            }
        }

        public void set(Object o) {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.set(o);
        }

        private void prepare() {
            if (this._it == null) {
                this._it = Listbox.this.getChildren().listIterator(this._j + Listbox.this._hdcnt);
            }
        }
    }

    private class Renderer
    implements Serializable {
        private final ListitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Listbox.this.getRealRenderer();
        }

        private void render(Listitem item) throws Throwable {
            if (item.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Listcell cell = (Listcell)item.getFirstChild();
            if (!(this._renderer instanceof ListitemRendererExt) || (((ListitemRendererExt)((Object)this._renderer)).getControls() & 1) != 0) {
                cell.detach();
            }
            try {
                this._renderer.render(item, Listbox.this._model.getElementAt(item.getIndex()));
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error(t);
                }
                item.setLoaded(true);
                throw ex;
            }
            finally {
                if (item.getChildren().isEmpty()) {
                    cell.setParent((Component)item);
                }
            }
            item.setLoaded(true);
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

