/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.Iterator;
import java.util.List;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.impl.LabelImageElement;

public class Listcell
extends LabelImageElement {
    private Object _value;
    private int _span = 1;

    public Listcell() {
    }

    public Listcell(String label) {
        this.setLabel(label);
    }

    public Listcell(String label, String src) {
        this.setLabel(label);
        this.setImage(src);
    }

    public Listbox getListbox() {
        Component comp = this.getParent();
        return comp != null ? (Listbox)comp.getParent() : null;
    }

    public Listitem getListitem() {
        return (Listitem)this.getParent();
    }

    public Listheader getListheader() {
        List lcschs;
        int j;
        Listhead lcs;
        Listbox listbox = this.getListbox();
        if (listbox != null && (lcs = listbox.getListhead()) != null && (j = this.getColumnIndex()) < (lcschs = lcs.getChildren()).size()) {
            return (Listheader)((Object)lcschs.get(j));
        }
        return null;
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    public int getMaxlength() {
        Listbox listbox = this.getListbox();
        if (listbox == null) {
            return 0;
        }
        if (listbox.inSelectMold()) {
            return listbox.getMaxlength();
        }
        Listheader lc = this.getListheader();
        return lc != null ? lc.getMaxlength() : 0;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public int getSpan() {
        return this._span;
    }

    public void setSpan(int span) {
        if (this._span != span) {
            this._span = span;
            this.smartUpdate("colspan", Integer.toString(this._span));
        }
    }

    public void setWidth(String width) {
        throw new UnsupportedOperationException("Set listheader's width instead");
    }

    public String getColumnHtmlPrefix() {
        Listitem item = this.getListitem();
        Listbox listbox = this.getListbox();
        if (listbox != null && item.getFirstChild() == this) {
            StringBuffer sb = new StringBuffer(64);
            if (listbox.isCheckmark()) {
                sb.append("<input type=\"").append(listbox.isMultiple() ? "checkbox" : "radio").append('\"');
                if (item.isDisabled()) {
                    sb.append(" disabled=\"disabled\"");
                }
                if (item.isSelected()) {
                    sb.append(" checked=\"checked\"");
                }
                sb.append(" id=\"").append(item.getUuid()).append("!cm\" z.type=\"Lcfc\"/>");
                return sb.toString();
            }
            if (this.isFocusRequired(listbox, (Component)item)) {
                sb.append("<a href=\"javascript:;\" id=\"").append(item.getUuid()).append("!sel\" z.type=\"Lcfc\"> </a>");
                return sb.toString();
            }
        }
        boolean empty = this.getImage() == null && this.getLabel().length() == 0 && this.getChildren().isEmpty();
        return empty ? "&nbsp;" : null;
    }

    public String getColumnHtmlPostfix() {
        return null;
    }

    private boolean isFocusRequired(Listbox listbox, Component parent) {
        Listitem sel = listbox.getSelectedItem();
        return parent == sel || sel == null && ((Listitem)parent).getIndex() == 0;
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        Listheader header = this.getListheader();
        String clkattrs = this.getAllOnClickAttrs(false);
        if (header == null && clkattrs == null && this._span == 1) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        if (header != null) {
            sb.append(header.getColAttrs());
        }
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        if (this._span != 1) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"colspan", (int)this._span);
        }
        return sb.toString();
    }

    public String getLabelAttrs() {
        String style = HTMLs.getTextRelevantStyle((String)this.getRealStyle());
        return style.length() > 0 ? " style=\"" + style + '\"' : "";
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Listitem)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.setParent(parent);
    }

    public void invalidate() {
        Listbox listbox = this.getListbox();
        if (listbox != null && listbox.inSelectMold()) {
            this.getParent().invalidate();
        } else {
            super.invalidate();
        }
    }
}

