/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.impl.XulElement;

public class Listitem
extends XulElement {
    private static final Log log = Log.lookup((Class)Listitem.class);
    private Object _value;
    private int _index = -1;
    private boolean _selected;
    private boolean _disabled;
    private boolean _loaded;

    public Listitem() {
    }

    public Listitem(String label) {
        this.setLabel(label);
    }

    public Listitem(String label, Object value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public Listbox getListbox() {
        return (Listbox)this.getParent();
    }

    private final boolean inSelectMold() {
        Listbox listbox = this.getListbox();
        return listbox != null && listbox.inSelectMold();
    }

    protected String getRealSclass() {
        String sclx = (String)this.getListbox().getAttribute("Z_STRIPE");
        return super.getRealSclass() + (sclx != null ? " " + sclx : "");
    }

    public int getMaxlength() {
        Listbox listbox = this.getListbox();
        return listbox != null ? listbox.getMaxlength() : 0;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                if (listbox.inSelectMold()) {
                    this.smartUpdate("value", Objects.toString((Object)this._value));
                } else if (listbox.getName() != null) {
                    this.smartUpdate("z.value", Objects.toString((Object)this._value));
                }
            }
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            if (this.inSelectMold()) {
                this.smartUpdate("disabled", this._disabled);
            } else {
                this.invalidate();
            }
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Listbox listbox = (Listbox)this.getParent();
            if (listbox != null) {
                listbox.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    public String getLabel() {
        Listcell cell = (Listcell)this.getFirstChild();
        return cell != null ? cell.getLabel() : null;
    }

    public void setLabel(String label) {
        this.autoFirstCell().setLabel(label);
    }

    private Listcell autoFirstCell() {
        Listcell cell = (Listcell)this.getFirstChild();
        if (cell == null) {
            cell = new Listcell();
            cell.applyProperties();
            cell.setParent((Component)this);
        }
        return cell;
    }

    public String getSrc() {
        Listcell cell = (Listcell)this.getFirstChild();
        return cell != null ? cell.getSrc() : null;
    }

    public void setSrc(String src) {
        this.autoFirstCell().setSrc(src);
    }

    public String getImage() {
        return this.getSrc();
    }

    public void setImage(String image) {
        this.setSrc(image);
    }

    public final int getIndex() {
        return this._index;
    }

    final void setLoaded(boolean loaded) {
        if (loaded != this._loaded) {
            this._loaded = loaded;
            Listbox listbox = this.getListbox();
            if (listbox != null && listbox.getModel() != null) {
                if (listbox.inPagingMold()) {
                    this.smartUpdate("z.loaded", this._loaded);
                } else if (loaded) {
                    this.invalidate();
                }
            }
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    final void setIndexDirectly(int index) {
        this._index = index;
    }

    final void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public String getSclass() {
        String scls = super.getSclass();
        if (scls == null) {
            scls = "item";
        }
        if (this.isDisabled()) {
            return scls.length() > 0 ? scls + " disd" : "disd";
        }
        if (this.isSelected()) {
            return scls.length() > 0 ? scls + " seld" : "seld";
        }
        return scls;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Listbox)) {
            throw new UiException("Listitem's parent must be Listbox, not " + parent);
        }
        super.setParent(parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Listcell)) {
            throw new UiException("Unsupported child for listitem: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void invalidate() {
        if (this.inSelectMold()) {
            this.getParent().invalidate();
            return;
        }
        super.invalidate();
    }

    public void onChildAdded(Component child) {
        if (this.inSelectMold()) {
            this.invalidate();
        }
        super.onChildAdded(child);
    }

    public void onChildRemoved(Component child) {
        if (this.inSelectMold()) {
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(80).append(super.getOuterAttrs());
        if (this.inSelectMold()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"value", (String)Objects.toString((Object)this._value));
            if (this.isDisabled()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
            }
            if (this.isSelected()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"selected", (String)"selected");
            }
        } else {
            String clkattrs;
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                if (listbox.getName() != null) {
                    HTMLs.appendAttribute((StringBuffer)sb, (String)"z.value", (String)Objects.toString((Object)this._value));
                }
                if (listbox.getModel() != null) {
                    HTMLs.appendAttribute((StringBuffer)sb, (String)"z.loaded", (boolean)this._loaded);
                }
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.disd", (boolean)this.isDisabled());
            if (this.getAttribute("org.zkoss.zul.SkipSibling") != null) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.skipsib", (String)"true");
                this.removeAttribute("org.zkoss.zul.SkipSibling");
            }
            if (this.isSelected()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z.sel", (String)"true");
            }
            if ((clkattrs = this.getAllOnClickAttrs(false)) != null) {
                sb.append(clkattrs);
            }
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.rid", (String)this.getListbox().getUuid());
        }
        return sb.toString();
    }

    public Object clone() {
        Listitem clone = (Listitem)((Object)super.clone());
        clone._index = -1;
        return clone;
    }
}

