/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.mesg.Messages;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public class Paging
extends XulElement
implements Paginal {
    private int _pgsz = 20;
    private int _ttsz = 0;
    private int _npg = 1;
    private int _actpg = 0;
    private int _pginc = 10;
    private boolean _autohide;
    private boolean _detailed;

    public Paging() {
        this.setSclass("paging");
    }

    public Paging(int totalsz, int pagesz) {
        this();
        this.setTotalSize(totalsz);
        this.setPageSize(pagesz);
    }

    public int getPageSize() {
        return this._pgsz;
    }

    public void setPageSize(int size) throws WrongValueException {
        if (size <= 0) {
            throw new WrongValueException("positive only");
        }
        if (this._pgsz != size) {
            this._pgsz = size;
            this.updatePageNum();
            Events.postEvent((Event)new PagingEvent("onPagingImpl", (Component)this, this._actpg));
        }
    }

    public int getTotalSize() {
        return this._ttsz;
    }

    public void setTotalSize(int size) throws WrongValueException {
        if (size < 0) {
            throw new WrongValueException("non-negative only");
        }
        if (this._ttsz != size) {
            this._ttsz = size;
            this.updatePageNum();
            if (this._detailed) {
                this.invalidate();
            }
        }
    }

    private void updatePageNum() {
        int v = (this._ttsz - 1) / this._pgsz + 1;
        if (v == 0) {
            v = 1;
        }
        if (v != this._npg) {
            this._npg = v;
            if (this._actpg >= this._npg) {
                this._actpg = this._npg - 1;
            }
            this.invalidate();
        }
    }

    public int getPageCount() {
        return this._npg;
    }

    public int getActivePage() {
        return this._actpg;
    }

    public void setActivePage(int pg) throws WrongValueException {
        if (pg >= this._npg || pg < 0) {
            throw new WrongValueException("Unable to set active page to " + pg + " since only " + this._npg + " pages");
        }
        if (this._actpg != pg) {
            this._actpg = pg;
            this.invalidate();
            Events.postEvent((Event)new PagingEvent("onPagingImpl", (Component)this, this._actpg));
        }
    }

    public int getPageIncrement() {
        return this._pginc;
    }

    public void setPageIncrement(int pginc) throws WrongValueException {
        if (pginc <= 0) {
            throw new WrongValueException("Nonpositive is not allowed: " + pginc);
        }
        if (this._pginc != pginc) {
            this._pginc = pginc;
            this.invalidate();
        }
    }

    public boolean isDetailed() {
        return this._detailed;
    }

    public void setDetailed(boolean detailed) {
        if (this._detailed != detailed) {
            this._detailed = detailed;
            this.invalidate();
        }
    }

    public boolean isAutohide() {
        return this._autohide;
    }

    public void setAutohide(boolean autohide) {
        if (this._autohide != autohide) {
            this._autohide = autohide;
            if (this._npg == 1) {
                this.invalidate();
            }
        }
    }

    public String getInnerTags() {
        boolean bNext;
        int begin;
        StringBuffer sb = new StringBuffer(512);
        int half = this._pginc / 2;
        int end = this._actpg + half - 1;
        if (end >= this._npg) {
            end = this._npg - 1;
            begin = end - this._pginc + 1;
            if (begin < 0) {
                begin = 0;
            }
        } else {
            begin = this._actpg - half;
            if (begin < 0) {
                begin = 0;
            }
            if ((end = begin + this._pginc - 1) >= this._npg) {
                end = this._npg - 1;
            }
        }
        if (this._actpg > 0) {
            if (begin > 0) {
                Paging.appendAnchor(sb, Messages.get((int)MZul.FIRST), 0);
            }
            Paging.appendAnchor(sb, Messages.get((int)MZul.PREV), this._actpg - 1);
        }
        boolean bl = bNext = this._actpg < this._npg - 1;
        while (begin <= end) {
            if (begin == this._actpg) {
                sb.append(begin + 1).append("&nbsp;");
            } else {
                Paging.appendAnchor(sb, Integer.toString(begin + 1), begin);
            }
            ++begin;
        }
        if (bNext) {
            Paging.appendAnchor(sb, Messages.get((int)MZul.NEXT), this._actpg + 1);
            if (end < this._npg - 1) {
                Paging.appendAnchor(sb, Messages.get((int)MZul.LAST), this._npg - 1);
            }
        }
        if (this._detailed) {
            sb.append("<span>[").append(this._actpg * this._pgsz + 1).append('/').append(this._ttsz).append("]</span>");
        }
        return sb.toString();
    }

    private static final void appendAnchor(StringBuffer sb, String label, int val) {
        sb.append("<a href=\"javascript:;\" onclick=\"zkPg.go(this,").append(val).append(")\">").append(label).append("</a>&nbsp;");
    }

    public boolean isVisible() {
        return super.isVisible() && (this._npg > 1 || !this._autohide);
    }

    public boolean isChildable() {
        return false;
    }
}

